/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.GO_Measure;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.util.InternationalString;

@TitleProperty(name="dimensionName")
@XmlType(name="MD_Dimension_Type", propOrder={"dimensionName", "dimensionSize", "resolution", "dimensionTitle", "dimensionDescription"})
@XmlRootElement(name="MD_Dimension")
public class DefaultDimension
extends ISOMetadata
implements Dimension {
    private static final long serialVersionUID = 1104542984724265236L;
    private DimensionNameType dimensionName;
    private Integer dimensionSize;
    private Double resolution;
    private InternationalString dimensionTitle;
    private InternationalString dimensionDescription;

    public DefaultDimension() {
    }

    public DefaultDimension(DimensionNameType dimensionName, int dimensionSize) {
        ArgumentChecks.ensurePositive("dimensionSize", dimensionSize);
        this.dimensionName = dimensionName;
        this.dimensionSize = dimensionSize;
    }

    public DefaultDimension(Dimension object) {
        super(object);
        if (object != null) {
            this.dimensionName = object.getDimensionName();
            this.dimensionSize = object.getDimensionSize();
            this.resolution = object.getResolution();
            this.dimensionTitle = object.getDimensionTitle();
            this.dimensionDescription = object.getDimensionDescription();
        }
    }

    public static DefaultDimension castOrCopy(Dimension object) {
        if (object == null || object instanceof DefaultDimension) {
            return (DefaultDimension)object;
        }
        return new DefaultDimension(object);
    }

    @Override
    @XmlElement(name="dimensionName", required=true)
    public DimensionNameType getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(DimensionNameType newValue) {
        this.checkWritePermission(this.dimensionName);
        this.dimensionName = newValue;
    }

    @Override
    @ValueRange(minimum=0.0)
    @XmlElement(name="dimensionSize", required=true)
    public Integer getDimensionSize() {
        return this.dimensionSize;
    }

    public void setDimensionSize(Integer newValue) {
        this.checkWritePermission(this.dimensionSize);
        if (ImplementationHelper.ensurePositive(DefaultDimension.class, "dimensionSize", false, newValue)) {
            this.dimensionSize = newValue;
        }
    }

    @Override
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @XmlJavaTypeAdapter(value=GO_Measure.class)
    @XmlElement(name="resolution")
    public Double getResolution() {
        return this.resolution;
    }

    public void setResolution(Double newValue) {
        this.checkWritePermission(this.resolution);
        if (ImplementationHelper.ensurePositive(DefaultDimension.class, "resolution", true, newValue)) {
            this.resolution = newValue;
        }
    }

    @Override
    @XmlElement(name="dimensionTitle")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    public InternationalString getDimensionTitle() {
        return this.dimensionTitle;
    }

    public void setDimensionTitle(InternationalString newValue) {
        this.checkWritePermission(this.dimensionTitle);
        this.dimensionTitle = newValue;
    }

    @Override
    @XmlElement(name="dimensionDescription")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    public InternationalString getDimensionDescription() {
        return this.dimensionDescription;
    }

    public void setDimensionDescription(InternationalString newValue) {
        this.checkWritePermission(this.dimensionDescription);
        this.dimensionDescription = newValue;
    }
}

