/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import jakarta.xml.bind.annotation.XmlTransient;
import javax.measure.Unit;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValue;

@XmlTransient
final class UnmodifiableParameterValue<T>
extends DefaultParameterValue<T> {
    private static final long serialVersionUID = -4760030766220872555L;
    private static final WeakHashSet<UnmodifiableParameterValue> POOL = new WeakHashSet<UnmodifiableParameterValue>(UnmodifiableParameterValue.class);

    private UnmodifiableParameterValue(ParameterValue<T> value) {
        super(value);
    }

    static <T> UnmodifiableParameterValue<T> create(ParameterValue<T> parameter) {
        if (parameter == null || parameter instanceof UnmodifiableParameterValue) {
            return (UnmodifiableParameterValue)parameter;
        }
        return POOL.unique(new UnmodifiableParameterValue<T>(parameter));
    }

    @Override
    public T getValue() {
        Class type;
        Object value = super.getValue();
        if (value instanceof Cloneable && (type = this.getDescriptor().getValueClass()) != null) {
            try {
                value = type.cast(Cloner.cloneIfPublic(value));
            }
            catch (CloneNotSupportedException e) {
                throw new UnsupportedOperationException(Errors.format((short)20, value.getClass()), e);
            }
        }
        return value;
    }

    @Override
    protected void setValue(Object value, Unit<?> unit) {
        throw new UnsupportedOperationException(Errors.format((short)153, this.getClass()));
    }

    @Override
    public DefaultParameterValue<T> clone() {
        return new DefaultParameterValue(this);
    }
}

