/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.GeodeticCalculator;
import org.apache.sis.referencing.GeodeticException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Ellipsoid;

class GeodesicsOnEllipsoid
extends GeodeticCalculator {
    static final boolean STORE_LOCAL_VARIABLES = false;
    static final double ITERATION_TOLERANCE = 7.853353365705227E-11;
    private static final double NEARLY_ANTIPODAL_\u0394\u03bb = 0.004363323129985824;
    final double eccentricitySquared;
    final double secondEccentricitySquared;
    final double thirdFlattening;
    final double axisRatio;
    private double sin\u03b10;
    private double cos\u03b10;
    private double \u03bb1E;
    private double I1_\u03c31;
    private double \u03b5;
    private double A1;
    private double A2;
    private double A3;
    private double C31;
    private double C32;
    private double C33;
    private double C34;
    private double C35;
    private final double R0;
    private final double R2;
    private final double R4;
    private final double R6;

    private double semiMinorAxis() {
        return this.semiMajorAxis * this.axisRatio;
    }

    GeodesicsOnEllipsoid(CoordinateReferenceSystem crs, Ellipsoid ellipsoid) {
        super(crs, ellipsoid);
        double a = this.semiMajorAxis;
        double b = ellipsoid.getSemiMinorAxis();
        double \u03942 = a * a - b * b;
        this.eccentricitySquared = \u03942 / (a * a);
        this.secondEccentricitySquared = \u03942 / (b * b);
        this.thirdFlattening = (a - b) / (a + b);
        this.axisRatio = b / a;
        this.R0 = 1.0 - this.eccentricitySquared * (0.25 + this.eccentricitySquared * (0.046875 + this.eccentricitySquared * 0.01953125));
        double fe = this.eccentricitySquared;
        this.R2 = fe * (-0.375 - this.eccentricitySquared * (0.09375 + this.eccentricitySquared * 0.032552083333333336));
        this.R4 = (fe *= this.eccentricitySquared) * (0.1171875 + this.eccentricitySquared * 0.087890625);
        this.R6 = fe * this.eccentricitySquared * -0.045572916666666664;
    }

    private double computeSeriesExpansionCoefficients() {
        assert (Math.abs(this.sin\u03b10 * this.sin\u03b10 + this.cos\u03b10 * this.cos\u03b10 - 1.0) <= 1.0E-10);
        double k2 = this.secondEccentricitySquared * (this.cos\u03b10 * this.cos\u03b10);
        double h2 = Math.sqrt(1.0 + k2);
        this.\u03b5 = (h2 - 1.0) / (h2 + 1.0);
        double \u03b52 = this.\u03b5 * this.\u03b5;
        this.A1 = (((0.00390625 * \u03b52 + 0.015625) * \u03b52 + 0.25) * \u03b52 + 1.0) / (1.0 - this.\u03b5);
        this.A2 = (((0.09765625 * \u03b52 + 0.140625) * \u03b52 + 0.25) * \u03b52 + 1.0) * (1.0 - this.\u03b5);
        double n = this.thirdFlattening;
        this.A3 = 1.0 - this.\u03b5 * (0.5 - n * 0.5 + this.\u03b5 * (0.25 + n * (0.125 - n * 0.375) + this.\u03b5 * (0.0625 + n * (0.1875 + n * 0.0625) + this.\u03b5 * (0.046875 + n * 0.03125 + this.\u03b5 * 0.0234375))));
        double f\u03b5 = this.\u03b5;
        this.C31 = f\u03b5 * (0.25 - n * 0.25 + this.\u03b5 * (0.125 - n * (n * 0.125) + this.\u03b5 * (0.020833333333333332 + n * (0.09375 - n * 0.041666666666666664) + this.\u03b5 * (0.015625 + n * 0.041666666666666664 + this.\u03b5 * 0.01796875))));
        this.C32 = (f\u03b5 *= this.\u03b5) * (0.125 - n * (0.1875 - n * 0.0625) + this.\u03b5 * (0.09375 - n * (0.0625 + n * 0.09375) + this.\u03b5 * (-0.0078125 + n * 0.125 + this.\u03b5 * -0.015625)));
        this.C33 = (f\u03b5 *= this.\u03b5) * (0.10416666666666667 - n * (0.1875 - n * 0.10416666666666667) + this.\u03b5 * (0.09375 - n * 0.10416666666666667 + this.\u03b5 * -0.04375));
        this.C34 = (f\u03b5 *= this.\u03b5) * (0.109375 - n * 0.21875 + this.\u03b5 * 0.109375);
        this.C35 = f\u03b5 * this.\u03b5 * 0.13125;
        return k2;
    }

    private double sphericalToEllipsoidalAngle(double \u03c3, boolean minusI2) {
        double \u03b52 = this.\u03b5 * this.\u03b5;
        double \u03b53 = this.\u03b5 * \u03b52;
        double \u03b54 = \u03b52 * \u03b52;
        double \u03b55 = \u03b52 * \u03b53;
        double \u03b56 = \u03b53 * \u03b53;
        double \u03b8 = \u03c3 * 2.0;
        double sin\u03b8 = Math.sin(\u03b8);
        double cos\u03b8 = Math.cos(\u03b8);
        double m4 = this.A1 * (\u03c3 + sin\u03b8 * (-0.0484375 * \u03b55 + 0.20833333333333334 * \u03b53 + -0.5 * this.\u03b5 + cos\u03b8 * (-0.052734375 * \u03b56 + 0.1015625 * \u03b54 + -0.125 * \u03b52 + cos\u03b8 * (0.1125 * \u03b55 + -0.08333333333333333 * \u03b53 + cos\u03b8 * (0.15625 * \u03b56 + -0.078125 * \u03b54 + cos\u03b8 * (-0.0875 * \u03b55 + cos\u03b8 * (-0.109375 * \u03b56)))))));
        if (minusI2) {
            m4 -= this.A2 * (\u03c3 + sin\u03b8 * (0.0609375 * \u03b55 + -0.041666666666666664 * \u03b53 + 0.5 * this.\u03b5 + cos\u03b8 * (0.205078125 * \u03b56 + -0.2109375 * \u03b54 + 0.375 * \u03b52 + cos\u03b8 * (-0.5125 * \u03b55 + 0.4166666666666667 * \u03b53 + cos\u03b8 * (-1.09375 * \u03b56 + 0.546875 * \u03b54 + cos\u03b8 * (0.7875 * \u03b55 + cos\u03b8 * (1.203125 * \u03b56)))))));
        }
        return m4;
    }

    private double ellipsoidalToSphericalAngle(double \u03c4) {
        assert (!this.isInvalid(64));
        double \u03b52 = this.\u03b5 * this.\u03b5;
        double \u03b53 = this.\u03b5 * \u03b52;
        double \u03b54 = \u03b52 * \u03b52;
        double \u03b55 = \u03b52 * \u03b53;
        double \u03b56 = \u03b53 * \u03b53;
        double \u03b8 = \u03c4 * 2.0;
        double cos\u03b8 = Math.cos(\u03b8);
        return \u03c4 + Math.sin(\u03b8) * (1.1708333333333334 * \u03b55 + -0.5833333333333334 * \u03b53 + 0.5 * this.\u03b5 + cos\u03b8 * (8.106640625 * \u03b56 + -2.1744791666666665 * \u03b54 + 0.625 * \u03b52 + cos\u03b8 * (-7.7609375 * \u03b55 + 1.2083333333333333 * \u03b53 + cos\u03b8 * (-27.305729166666666 * \u03b56 + 2.8072916666666665 * \u03b54 + cos\u03b8 * (7.222916666666666 * \u03b55 + cos\u03b8 * (19.833854166666665 * \u03b56))))));
    }

    private double sphericalToGeodeticLongitude(double \u03c9, double \u03c3) {
        double \u03b8 = \u03c3 * 2.0;
        double cos\u03b8 = Math.cos(\u03b8);
        double I3 = this.A3 * (Math.sin(\u03b8) * (this.C31 + cos\u03b8 * (this.C32 + cos\u03b8 * (this.C33 + cos\u03b8 * (this.C34 + cos\u03b8 * this.C35)))) + \u03c3);
        return \u03c9 - this.sin\u03b10 * I3 * (1.0 - this.axisRatio);
    }

    private void \u03b10(double sin\u03b11, double cos\u03b11, double sin\u03b21, double cos\u03b21) {
        this.sin\u03b10 = sin\u03b11 * cos\u03b21;
        this.cos\u03b10 = Math.hypot(cos\u03b11, sin\u03b11 * sin\u03b21);
    }

    @Override
    final void computeEndPoint() {
        this.canComputeEndPoint();
        if (this.isInvalid(64)) {
            double m4 = Math.hypot(this.msin\u03b11, this.mcos\u03b11);
            double sin\u03b11 = this.msin\u03b11 / m4;
            double cos\u03b11 = this.mcos\u03b11 / m4;
            double tan\u03b21 = this.axisRatio * Math.tan(this.\u03c61);
            double cos\u03b21 = 1.0 / Math.sqrt(1.0 + tan\u03b21 * tan\u03b21);
            double sin\u03b21 = tan\u03b21 * cos\u03b21;
            this.\u03b10(sin\u03b11, cos\u03b11, sin\u03b21, cos\u03b21);
            double cos\u03b11_cos\u03b21 = cos\u03b11 * cos\u03b21;
            double \u03c31 = Math.atan2(sin\u03b21, cos\u03b11_cos\u03b21);
            double \u03c91 = Math.atan2(sin\u03b21 * this.sin\u03b10, cos\u03b11_cos\u03b21);
            double k2 = this.computeSeriesExpansionCoefficients();
            this.\u03bb1E = this.sphericalToGeodeticLongitude(\u03c91, \u03c31);
            this.I1_\u03c31 = this.sphericalToEllipsoidalAngle(\u03c31, false);
            this.setValid(64);
        }
        double s2b = this.I1_\u03c31 + this.geodesicDistance / this.semiMinorAxis();
        double \u03c32 = this.ellipsoidalToSphericalAngle(s2b / this.A1);
        double sin\u03c32 = Math.sin(\u03c32);
        double cos\u03c32 = Math.cos(\u03c32);
        this.msin\u03b12 = this.sin\u03b10;
        this.mcos\u03b12 = this.cos\u03b10 * cos\u03c32;
        double sin\u03b22 = this.cos\u03b10 * sin\u03c32;
        double cos\u03b22 = Math.hypot(this.msin\u03b12, this.mcos\u03b12);
        double \u03c92 = Math.atan2(this.sin\u03b10 * sin\u03c32, cos\u03c32);
        double \u03bb2E = this.sphericalToGeodeticLongitude(\u03c92, \u03c32);
        this.\u03bb2 = Math.IEEEremainder(\u03bb2E - this.\u03bb1E + this.\u03bb1, Math.PI * 2);
        this.\u03c62 = Math.atan(sin\u03b22 / (cos\u03b22 * this.axisRatio));
        this.setValid(10);
    }

    @Override
    final void computeDistance() {
        double \u03c32;
        double \u03c31;
        double \u03b11;
        boolean inverseLongitudeSigns;
        boolean inverseLatitudeSigns;
        boolean swapPoints;
        this.canComputeDistance();
        double \u03c61 = this.\u03c61;
        double \u03c62 = this.\u03c62;
        double \u0394\u03bb = Math.IEEEremainder(this.\u03bb2 - this.\u03bb1, Math.PI * 2);
        boolean bl = swapPoints = Math.abs(\u03c62) > Math.abs(\u03c61);
        if (swapPoints) {
            \u03c61 = this.\u03c62;
            \u03c62 = this.\u03c61;
            \u0394\u03bb = -\u0394\u03bb;
        }
        boolean bl2 = inverseLatitudeSigns = \u03c61 > 0.0;
        if (inverseLatitudeSigns) {
            \u03c61 = -\u03c61;
            \u03c62 = -\u03c62;
        }
        boolean bl3 = inverseLongitudeSigns = \u0394\u03bb < 0.0;
        if (inverseLongitudeSigns) {
            \u0394\u03bb = -\u0394\u03bb;
        }
        if (\u03c61 > -1.5706706731410454E-10) {
            if (\u0394\u03bb > this.axisRatio * Math.PI) {
                throw new GeodeticException("Cannot compute geodesics for antipodal points on equator.");
            }
            super.computeDistance();
            return;
        }
        double tan\u03b21 = this.axisRatio * Math.tan(\u03c61);
        double tan\u03b22 = this.axisRatio * Math.tan(\u03c62);
        double cos\u03b21 = 1.0 / Math.sqrt(1.0 + tan\u03b21 * tan\u03b21);
        double cos\u03b22 = 1.0 / Math.sqrt(1.0 + tan\u03b22 * tan\u03b22);
        double sin\u03b21 = tan\u03b21 * cos\u03b21;
        double sin\u03b22 = tan\u03b22 * cos\u03b22;
        if (\u0394\u03bb >= 3.137229330459807 && Math.abs(\u03c61 + \u03c62) <= 0.004363323129985824) {
            double \u03b21 = Math.atan2(sin\u03b21, cos\u03b21);
            double \u03b22 = Math.atan2(sin\u03b22, cos\u03b22);
            double \u03941 = (1.0 - this.axisRatio) * Math.PI * cos\u03b21;
            double y = (\u03b22 + \u03b21) / (\u03941 * cos\u03b21);
            double x = (Math.PI - \u0394\u03bb) / \u03941;
            double x2 = x * x;
            double y2 = y * y;
            if (y2 < 1.0E-12) {
                \u03b11 = x2 > 1.0 ? 1.5707963267948966 : Math.atan(x / Math.sqrt(1.0 - x2));
            } else {
                double \u03bc = GeodesicsOnEllipsoid.\u03bc(x2, y2);
                \u03b11 = Math.atan2(x * \u03bc, y * (1.0 + \u03bc));
            }
        } else {
            double w = (cos\u03b21 + cos\u03b22) / 2.0;
            w = Math.sqrt(1.0 - this.eccentricitySquared * (w * w));
            double \u0394\u03c9 = \u0394\u03bb / w;
            double c\u03c9 = Math.cos(\u0394\u03c9);
            double s\u03c9 = Math.sin(\u0394\u03c9);
            double \u03b1x = cos\u03b21 * sin\u03b22 - sin\u03b21 * cos\u03b22 * c\u03c9;
            double \u03b1y = cos\u03b22 * s\u03c9;
            \u03b11 = Math.atan2(\u03b1y, \u03b1x);
        }
        int moreRefinements = 18;
        do {
            double d\u0394\u03bb_d\u03b11;
            this.msin\u03b11 = Math.sin(\u03b11);
            this.mcos\u03b11 = Math.cos(\u03b11);
            this.\u03b10(this.msin\u03b11, this.mcos\u03b11, sin\u03b21, cos\u03b21);
            double k2 = this.computeSeriesExpansionCoefficients();
            double cos\u03b11_cos\u03b21 = this.mcos\u03b11 * cos\u03b21;
            double cos\u03b12_cos\u03b22 = Math.sqrt(cos\u03b11_cos\u03b21 * cos\u03b11_cos\u03b21 + (cos\u03b21 <= 0.7071067811865475 ? (cos\u03b22 - cos\u03b21) * (cos\u03b22 + cos\u03b21) : (sin\u03b21 - sin\u03b22) * (sin\u03b21 + sin\u03b22)));
            this.msin\u03b12 = this.sin\u03b10;
            this.mcos\u03b12 = cos\u03b12_cos\u03b22;
            \u03c31 = Math.atan2(sin\u03b21, cos\u03b11_cos\u03b21);
            \u03c32 = Math.atan2(sin\u03b22, cos\u03b12_cos\u03b22);
            double \u03c91 = Math.atan2(sin\u03b21 * this.sin\u03b10, cos\u03b11_cos\u03b21);
            double \u03c92 = Math.atan2(sin\u03b22 * this.sin\u03b10, cos\u03b12_cos\u03b22);
            this.\u03bb1E = this.sphericalToGeodeticLongitude(\u03c91, \u03c31);
            double \u03bb2E = this.sphericalToGeodeticLongitude(\u03c92, \u03c32);
            double \u0394\u03bb_error = Math.IEEEremainder(\u03bb2E - this.\u03bb1E - \u0394\u03bb, Math.PI * 2);
            if (Math.abs(\u0394\u03bb_error) <= 7.853353365705227E-11) {
                moreRefinements = 0;
            } else if (--moreRefinements == 0) {
                throw new GeodeticException(Resources.format((short)46));
            }
            if (Math.abs(this.mcos\u03b11) < 1.5706706731410454E-10 && -tan\u03b21 - Math.abs(tan\u03b22) < (1.0 + Math.abs(tan\u03b21 * tan\u03b22)) * 1.5706706731410454E-10) {
                d\u0394\u03bb_d\u03b11 = -2.0 * Math.sqrt(1.0 - this.eccentricitySquared * (cos\u03b21 * cos\u03b21)) / sin\u03b21;
            } else {
                double h1 = Math.hypot(sin\u03b21, cos\u03b11_cos\u03b21);
                double h2 = Math.hypot(sin\u03b22, cos\u03b12_cos\u03b22);
                double sin\u03c31 = sin\u03b21 / h1;
                double sin\u03c32 = sin\u03b22 / h2;
                double cos\u03c31 = cos\u03b11_cos\u03b21 / h1;
                double cos\u03c32 = cos\u03b12_cos\u03b22 / h2;
                double J2 = this.sphericalToEllipsoidalAngle(\u03c32, true);
                double J1 = this.sphericalToEllipsoidalAngle(\u03c31, true);
                double \u0394m = Math.sqrt(1.0 + k2 * (sin\u03c32 * sin\u03c32)) * cos\u03c31 * sin\u03c32 - Math.sqrt(1.0 + k2 * (sin\u03c31 * sin\u03c31)) * sin\u03c31 * cos\u03c32 - cos\u03c31 * cos\u03c32 * (J2 - J1);
                d\u0394\u03bb_d\u03b11 = \u0394m * this.axisRatio / cos\u03b12_cos\u03b22;
            }
            double d\u03b11 = \u0394\u03bb_error / d\u0394\u03bb_d\u03b11;
            if (\u03b11 != (\u03b11 -= d\u03b11)) continue;
            moreRefinements = 0;
        } while (moreRefinements != 0);
        this.I1_\u03c31 = this.sphericalToEllipsoidalAngle(\u03c31, false);
        double I1_\u03c32 = this.sphericalToEllipsoidalAngle(\u03c32, false);
        this.geodesicDistance = (I1_\u03c32 - this.I1_\u03c31) * this.semiMinorAxis();
        if (swapPoints) {
            double t2 = this.msin\u03b11;
            this.msin\u03b11 = this.msin\u03b12;
            this.msin\u03b12 = t2;
            t2 = this.mcos\u03b11;
            this.mcos\u03b11 = this.mcos\u03b12;
            this.mcos\u03b12 = t2;
        }
        if (inverseLongitudeSigns ^ swapPoints) {
            this.msin\u03b11 = -this.msin\u03b11;
            this.msin\u03b12 = -this.msin\u03b12;
        }
        if (inverseLatitudeSigns ^ swapPoints) {
            this.mcos\u03b11 = -this.mcos\u03b11;
            this.mcos\u03b12 = -this.mcos\u03b12;
        }
        this.setValid(28);
        if (!(swapPoints | inverseLongitudeSigns | inverseLatitudeSigns)) {
            this.setValid(64);
        }
    }

    private static double \u03bc(double x2, double y2) {
        double T;
        double S = x2 * y2 / 4.0;
        double r = (x2 + y2 - 1.0) / 6.0;
        double r3 = r * r * r;
        double d = S * (S + 2.0 * r3);
        double u = d < 0.0 ? r * (1.0 + 2.0 * Math.cos(Math.atan2(Math.sqrt(-d), -(S + r3)) / 3.0)) : ((T = Math.cbrt(S + r3 + Math.copySign(Math.sqrt(d), S + r3))) == 0.0 ? 0.0 : r + T + r * r / T);
        double v = Math.sqrt(u * u + y2);
        double w = (v + u - y2) / (2.0 * v);
        return (v + u) / (Math.sqrt(v + u + w * w) + w);
    }

    @Override
    double d\u03c6_dy(double \u03c6) {
        double sin\u03c6 = Math.sin(\u03c6);
        double cos\u03c6 = Math.cos(\u03c6);
        return cos\u03c6 / (1.0 - this.eccentricitySquared * (cos\u03c6 * cos\u03c6) / (1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6)));
    }

    final void snapshot() {
        this.store("\u03b5", this.\u03b5);
        this.store("A\u2081", this.A1);
        this.store("A\u2082", this.A2);
        this.store("A\u2083", this.A3);
        this.store("\u03b1\u2080", Math.atan2(this.sin\u03b10, this.cos\u03b10));
        this.store("I\u2081(\u03c3\u2081)", this.I1_\u03c31);
        this.store("s\u2081", this.I1_\u03c31 * this.semiMinorAxis());
        this.store("\u03bb\u2081", this.\u03bb1E);
    }

    void store(String name, double value) {
    }

    double computedToGiven(double \u03b11) {
        return \u03b11;
    }

    @Override
    final void computeRhumbLine() {
        double S;
        this.canComputeDistance();
        double eccentricity = Math.sqrt(this.eccentricitySquared);
        double sin\u03c61 = Math.sin(this.\u03c61);
        double sin\u03c62 = Math.sin(this.\u03c62);
        double sd = eccentricity * (sin\u03c61 - sin\u03c62);
        double sm = 1.0 - this.eccentricitySquared * (sin\u03c61 * sin\u03c62);
        double \u0394\u03a8 = Math.log(Math.tan(0.7853981633974483 + this.\u03c62 / 2.0) / Math.tan(0.7853981633974483 + this.\u03c61 / 2.0) * Math.pow((sm + sd) / (sm - sd), eccentricity / 2.0));
        double \u0394\u03bb = Math.IEEEremainder(this.\u03bb2 - this.\u03bb1, Math.PI * 2);
        double h2 = Math.hypot(\u0394\u03bb, \u0394\u03a8);
        if (Math.abs(this.\u03c61 - this.\u03c62) < 1.5706706731410454E-10) {
            double \u03c6m = (this.\u03c61 + this.\u03c62) / 2.0;
            double sin\u03c6 = Math.sin(\u03c6m);
            S = Math.cos(\u03c6m) / Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6));
        } else {
            double m1 = this.m(this.\u03c61, sin\u03c61);
            double m22 = this.m(this.\u03c62, sin\u03c62);
            S = (m22 - m1) / \u0394\u03a8;
        }
        this.rhumblineLength = S * h2 * this.semiMajorAxis;
        this.rhumblineAzimuth = Math.atan2(\u0394\u03bb, \u0394\u03a8);
    }

    private double m(double \u03c6, double sin\u03c6) {
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03b8 = 2.0 * sin\u03c6 * cos\u03c6;
        double cos\u03b8 = (cos\u03c6 + sin\u03c6) * (cos\u03c6 - sin\u03c6);
        return this.R0 * \u03c6 + sin\u03b8 * (this.R2 + cos\u03b8 * (this.R4 + cos\u03b8 * this.R6));
    }

    @Override
    final String getProjectionMethod() {
        return "Modified Azimuthal Equidistant";
    }
}

