/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import org.apache.sis.internal.jaxb.referencing.CC_Conversion;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.ConversionKeys;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

@XmlType(name="AbstractGeneralDerivedCRSType")
@XmlRootElement(name="AbstractGeneralDerivedCRS")
@XmlSeeAlso(value={DefaultDerivedCRS.class, DefaultProjectedCRS.class})
abstract class AbstractDerivedCRS<C extends Conversion>
extends AbstractCRS
implements GeneralDerivedCRS {
    private static final long serialVersionUID = -175151161496419854L;
    private C conversionFromBase;

    AbstractDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, Conversion conversion, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, derivedCS);
        ArgumentChecks.ensureNonNull("baseCRS", baseCRS);
        ArgumentChecks.ensureNonNull("conversion", conversion);
        ArgumentChecks.ensureDimensionsMatch("baseToDerived", baseCRS.getCoordinateSystem().getDimension(), derivedCS.getDimension(), conversion.getMathTransform());
        this.conversionFromBase = this.createConversionFromBase(properties, baseCRS, conversion);
    }

    AbstractDerivedCRS(Map<String, ?> properties, SingleCRS baseCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform baseToDerived, CoordinateSystem derivedCS) throws MismatchedDimensionException {
        super(properties, derivedCS);
        ArgumentChecks.ensureNonNull("baseCRS", baseCRS);
        ArgumentChecks.ensureNonNull("method", method);
        ArgumentChecks.ensureNonNull("baseToDerived", baseToDerived);
        this.conversionFromBase = new DefaultConversion(ConversionKeys.unprefix(properties), baseCRS, this, interpolationCRS, method, baseToDerived);
    }

    AbstractDerivedCRS(GeneralDerivedCRS crs) {
        super(crs);
        this.conversionFromBase = this.createConversionFromBase(null, crs.getBaseCRS(), crs.getConversionFromBase());
    }

    private C createConversionFromBase(Map<String, ?> properties, SingleCRS baseCRS, Conversion conversion) {
        MathTransformFactory factory = null;
        if (properties != null) {
            factory = (MathTransformFactory)properties.get("mtFactory");
        }
        try {
            return DefaultConversion.castOrCopy(conversion).specialize(this.getConversionType(), baseCRS, this, factory);
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(Errors.getResources(properties).getString((short)45, "conversion", conversion.getName()), e);
        }
    }

    abstract Class<C> getConversionType();

    public abstract Class<? extends GeneralDerivedCRS> getInterface();

    @Override
    public abstract Datum getDatum();

    @XmlElement(name="conversion", required=true)
    public C getConversionFromBase() {
        return this.conversionFromBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            boolean strict;
            boolean bl = strict = mode == ComparisonMode.STRICT;
            if (Semaphores.queryAndSet(4)) {
                return true;
            }
            try {
                boolean bl2 = Utilities.deepEquals(strict ? this.conversionFromBase : this.getConversionFromBase(), strict ? ((AbstractDerivedCRS)object).conversionFromBase : ((GeneralDerivedCRS)object).getConversionFromBase(), mode);
                return bl2;
            }
            finally {
                Semaphores.clear(4);
            }
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.conversionFromBase.getSourceCRS().hashCode()) + (long)(37 * this.conversionFromBase.getMathTransform().hashCode());
    }

    AbstractDerivedCRS() {
    }

    private void setConversionFromBase(C conversion) {
        if (this.conversionFromBase == null) {
            this.conversionFromBase = conversion;
        } else {
            ImplementationHelper.propertyAlreadySet(AbstractDerivedCRS.class, "setConversionFromBase", "conversion");
        }
    }

    final void setBaseCRS(String name, SingleCRS baseCRS) {
        if (this.conversionFromBase != null) {
            SingleCRS previous = CC_Conversion.setBaseCRS(this.conversionFromBase, baseCRS);
            if (previous != null) {
                CC_Conversion.setBaseCRS(this.conversionFromBase, previous);
                ImplementationHelper.propertyAlreadySet(AbstractDerivedCRS.class, "setBaseCRS", name);
            }
        } else {
            throw new IllegalStateException(Errors.format((short)85, this.getInterface(), "conversion"));
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        String property = "conversion";
        if (this.conversionFromBase != null) {
            SingleCRS baseCRS = CC_Conversion.setBaseCRS(this.conversionFromBase, null);
            property = "coordinateSystem";
            if (super.getCoordinateSystem() != null) {
                property = "baseCRS";
                if (baseCRS != null) {
                    this.conversionFromBase = this.createConversionFromBase(null, baseCRS, (Conversion)this.conversionFromBase);
                    return;
                }
            }
        }
        throw new GeodeticException(Identifiers.missingValueForProperty(this.getName(), property));
    }
}

