/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.Legacy;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

@XmlType(name="GeodeticCRSType", propOrder={"ellipsoidalCS", "cartesianCS", "sphericalCS", "datum"})
@XmlRootElement(name="GeodeticCRS")
class DefaultGeodeticCRS
extends AbstractCRS
implements GeodeticCRS {
    private static final long serialVersionUID = -6205678223972395910L;
    private GeodeticDatum datum;

    DefaultGeodeticCRS(Map<String, ?> properties, GeodeticDatum datum, CoordinateSystem cs) {
        super(properties, cs);
        ArgumentChecks.ensureNonNull("datum", datum);
        this.datum = datum;
    }

    protected DefaultGeodeticCRS(GeodeticCRS crs) {
        super(crs);
        this.datum = crs.getDatum();
    }

    public Class<? extends GeodeticCRS> getInterface() {
        return GeodeticCRS.class;
    }

    @Override
    @XmlElement(name="geodeticDatum", required=true)
    public GeodeticDatum getDatum() {
        return this.datum;
    }

    @Override
    AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultGeodeticCRS(properties, this.datum, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isBaseCRS;
        boolean isGeographicWKT1;
        WKTUtilities.appendName(this, formatter, null);
        CoordinateSystem cs = this.getCoordinateSystem();
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        boolean bl = isGeographicWKT1 = isWKT1 && cs instanceof EllipsoidalCS;
        if (isGeographicWKT1 && cs.getDimension() == 3) {
            SingleCRS first = CRS.getHorizontalComponent(this);
            SingleCRS second = CRS.getVerticalComponent(this, true);
            if (first != null && second != null) {
                if (AxisDirection.UP.equals(AxisDirections.absolute(cs.getAxis(0).getDirection()))) {
                    SingleCRS t2 = first;
                    first = second;
                    second = t2;
                }
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable(first));
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable(second));
                formatter.newLine();
                return "Compd_CS";
            }
        }
        GeodeticDatum datum = this.getDatum();
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(datum));
        formatter.newLine();
        PrimeMeridian pm = datum.getPrimeMeridian();
        Unit<Angle> angularUnit = AxisDirections.getAngularUnit(cs, null);
        if (convention != Convention.WKT2_SIMPLIFIED || ReferencingUtilities.getGreenwichLongitude(pm, Units.DEGREE) != 0.0) {
            Unit<Angle> oldUnit = formatter.addContextualUnit(angularUnit);
            formatter.indent(1);
            formatter.append(WKTUtilities.toFormattable(pm));
            formatter.indent(-1);
            formatter.newLine();
            formatter.restoreContextualUnit(angularUnit, oldUnit);
        }
        if (isWKT1) {
            if (!isGeographicWKT1) {
                if (cs instanceof CartesianCS) {
                    cs = Legacy.forGeocentricCRS((CartesianCS)cs, true);
                } else {
                    formatter.setInvalidWKT(cs, null);
                }
            }
            isBaseCRS = false;
        } else {
            isBaseCRS = DefaultGeodeticCRS.isBaseCRS(formatter);
        }
        if (!isBaseCRS || convention == Convention.INTERNAL) {
            this.formatCS(formatter, cs, ReferencingUtilities.getUnit(cs), isWKT1);
        } else if (convention.isSimplified()) {
            formatter.append(formatter.toContextualUnit(angularUnit));
        }
        if (isWKT1) {
            return isGeographicWKT1 ? "GeogCS" : "GeocCS";
        }
        return isBaseCRS ? "BaseGeodCRS" : formatter.shortOrLong("GeodCRS", "GeodeticCRS");
    }

    DefaultGeodeticCRS() {
    }

    private void setDatum(GeodeticDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultGeodeticCRS.class, "setDatum", "geodeticDatum");
        }
    }

    @XmlElement(name="ellipsoidalCS")
    private EllipsoidalCS getEllipsoidalCS() {
        return this.getCoordinateSystem(EllipsoidalCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    private void setEllipsoidalCS(EllipsoidalCS cs) {
        super.setCoordinateSystem("ellipsoidalCS", cs);
    }

    private void setCartesianCS(CartesianCS cs) {
        super.setCoordinateSystem("cartesianCS", cs);
    }

    private void setSphericalCS(SphericalCS cs) {
        super.setCoordinateSystem("sphericalCS", cs);
    }
}

