/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.AnnotatedMatrix;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

@XmlType(name="GeodeticDatumType", propOrder={"primeMeridian", "ellipsoid"})
@XmlRootElement(name="GeodeticDatum")
public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.operation");
    private static final long serialVersionUID = 8832100095648302943L;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    private static final BursaWolfParameters[] EMPTY_ARRAY = new BursaWolfParameters[0];
    private Ellipsoid ellipsoid;
    private PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    public DefaultGeodeticDatum(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(properties);
        ArgumentChecks.ensureNonNull("ellipsoid", ellipsoid);
        ArgumentChecks.ensureNonNull("primeMeridian", primeMeridian);
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        this.bursaWolf = CollectionsExt.nonEmpty(CollectionsExt.nonNullArraySet(BURSA_WOLF_KEY, properties.get(BURSA_WOLF_KEY), EMPTY_ARRAY));
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters param = this.bursaWolf[i];
                ArgumentChecks.ensureNonNullElement(BURSA_WOLF_KEY, i, param);
                param = param.clone();
                param.verify(primeMeridian);
                this.bursaWolf[i] = param;
            }
        }
    }

    protected DefaultGeodeticDatum(GeodeticDatum datum) {
        super(datum);
        this.ellipsoid = datum.getEllipsoid();
        this.primeMeridian = datum.getPrimeMeridian();
        this.bursaWolf = datum instanceof DefaultGeodeticDatum ? ((DefaultGeodeticDatum)datum).bursaWolf : null;
    }

    public static DefaultGeodeticDatum castOrCopy(GeodeticDatum object) {
        return object == null || object instanceof DefaultGeodeticDatum ? (DefaultGeodeticDatum)object : new DefaultGeodeticDatum(object);
    }

    public Class<? extends GeodeticDatum> getInterface() {
        return GeodeticDatum.class;
    }

    @Override
    @XmlElement(name="ellipsoid", required=true)
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    @XmlElement(name="primeMeridian", required=true)
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters[] getBursaWolfParameters() {
        if (this.bursaWolf == null) {
            return EMPTY_ARRAY;
        }
        BursaWolfParameters[] copy = (BursaWolfParameters[])this.bursaWolf.clone();
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = copy[i].clone();
        }
        return copy;
    }

    /*
     * Unable to fully structure code
     */
    public Matrix getPositionVectorTransformation(GeodeticDatum targetDatum, Extent areaOfInterest) {
        ArgumentChecks.ensureNonNull("targetDatum", targetDatum);
        selector = new ExtentSelector<BursaWolfParameters>(areaOfInterest);
        candidate = this.select(targetDatum, selector);
        if (candidate != null) {
            return DefaultGeodeticDatum.createTransformation(candidate, areaOfInterest);
        }
        if (targetDatum instanceof DefaultGeodeticDatum) {
            candidate = ((DefaultGeodeticDatum)targetDatum).select(this, selector);
            if (candidate != null) {
                try {
                    return Matrices.inverse(DefaultGeodeticDatum.createTransformation(candidate, areaOfInterest));
                }
                catch (NoninvertibleMatrixException e) {
                    Logging.unexpectedException(DefaultGeodeticDatum.LOGGER, DefaultGeodeticDatum.class, "getPositionVectorTransformation", e);
                }
            }
            if (this.bursaWolf != null) {
                bbox = selector.getAreaOfInterest();
                timeOfInterest = selector.getTimeOfInterest();
                useAOI = true;
                while (true) {
                    for (BursaWolfParameters toPivot : this.bursaWolf) {
                        if (!selector.setExtentOfInterest(toPivot.getDomainOfValidity(), bbox, timeOfInterest) || (candidate = ((DefaultGeodeticDatum)targetDatum).select(toPivot.getTargetDatum(), selector)) == null) continue;
                        step1 = DefaultGeodeticDatum.createTransformation(toPivot, areaOfInterest);
                        step2 = DefaultGeodeticDatum.createTransformation(candidate, areaOfInterest);
                        try {
                            m = MatrixSIS.castOrCopy(step2).inverse().multiply(step1);
                            return AnnotatedMatrix.indirect(m, useAOI);
                        }
                        catch (NoninvertibleMatrixException e) {
                            Logging.unexpectedException(DefaultGeodeticDatum.LOGGER, DefaultGeodeticDatum.class, "getPositionVectorTransformation", e);
                        }
                    }
                    useAOI = false;
                    v0 = bbox;
                    bbox = null;
                    if (v0 != null) ** continue;
                    v1 = timeOfInterest;
                    timeOfInterest = null;
                    if (v1 == null) break;
                }
            }
        }
        return null;
    }

    private static Matrix createTransformation(BursaWolfParameters bursaWolf, Extent areaOfInterest) {
        return bursaWolf.getPositionVectorTransformation(bursaWolf.getClass() != BursaWolfParameters.class ? Extents.getDate(areaOfInterest, 0.5) : null);
    }

    private BursaWolfParameters select(GeodeticDatum targetDatum, ExtentSelector<BursaWolfParameters> selector) {
        if (this.bursaWolf == null) {
            return null;
        }
        for (BursaWolfParameters candidate : this.bursaWolf) {
            if (!Utilities.deepEquals(targetDatum, candidate.getTargetDatum(), ComparisonMode.IGNORE_METADATA)) continue;
            selector.evaluate(candidate.getDomainOfValidity(), candidate);
        }
        return selector.best();
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        final String meridian = this.primeMeridian.getName().getCode();
        return NameToIdentifier.isHeuristicMatchForName(super.getName(), super.getAlias(), name, new AbstractDatum.Simplifier(){

            @Override
            protected CharSequence apply(CharSequence name) {
                int upper;
                int lower = CharSequences.indexOf(name = super.apply(name), meridian, 0, name.length()) - 1;
                if (lower >= 0 && name.charAt(lower) == '(' && (upper = lower + meridian.length() + 1) < name.length() && name.charAt(upper) == ')') {
                    int c;
                    for (lower = CharSequences.skipTrailingWhitespaces(name, 0, lower); lower > 0; lower -= Character.charCount(c)) {
                        c = Character.codePointBefore(name, lower);
                        if (!Character.isLetterOrDigit(c)) continue;
                        name = new StringBuilder(name).delete(lower, upper + 1).toString();
                        break;
                    }
                }
                return name;
            }
        });
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultGeodeticDatum that = (DefaultGeodeticDatum)object;
                return Objects.equals(this.ellipsoid, that.ellipsoid) && Objects.equals(this.primeMeridian, that.primeMeridian) && Arrays.equals(this.bursaWolf, that.bursaWolf);
            }
        }
        GeodeticDatum that = (GeodeticDatum)object;
        return Utilities.deepEquals(this.getEllipsoid(), that.getEllipsoid(), mode) && Utilities.deepEquals(this.getPrimeMeridian(), that.getPrimeMeridian(), mode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.ellipsoid) + (long)(31 * Objects.hashCode(this.primeMeridian));
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isWKT1;
        super.formatTo(formatter);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(this.getEllipsoid()));
        boolean bl = isWKT1 = formatter.getConvention().majorVersion() == 1;
        if (isWKT1 && this.bursaWolf != null) {
            for (BursaWolfParameters candidate : this.bursaWolf) {
                if (!candidate.isToWGS84()) continue;
                formatter.newLine();
                formatter.append(candidate);
                break;
            }
        }
        formatter.newLine();
        if (!isWKT1 && !(formatter.getEnclosingElement(1) instanceof GeodeticCRS)) {
            return formatter.shortOrLong("Datum", "GeodeticDatum");
        }
        return "Datum";
    }

    private DefaultGeodeticDatum() {
        this.bursaWolf = null;
    }

    private void setEllipsoid(Ellipsoid value) {
        if (this.ellipsoid == null) {
            this.ellipsoid = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultGeodeticDatum.class, "setEllipsoid", "ellipsoid");
        }
    }

    private void setPrimeMeridian(PrimeMeridian value) {
        if (this.primeMeridian == null) {
            this.primeMeridian = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultGeodeticDatum.class, "setPrimeMeridian", "primeMeridian");
        }
    }
}

