/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public class IdentifiedObjectFinder {
    static final ComparisonMode COMPARISON_MODE = ComparisonMode.APPROXIMATE;
    protected final AuthorityFactory factory;
    private transient AuthorityFactoryProxy<?> proxy;
    private IdentifiedObjectFinder wrapper;
    private Domain domain = Domain.VALID_DATASET;
    private boolean ignoreAxes;

    protected IdentifiedObjectFinder(AuthorityFactory factory) {
        ArgumentChecks.ensureNonNull("factory", factory);
        this.factory = factory;
    }

    final void setWrapper(IdentifiedObjectFinder other) {
        this.wrapper = other;
        this.setSearchDomain(other.domain);
        this.setIgnoringAxes(other.ignoreAxes);
    }

    public Domain getSearchDomain() {
        return this.domain;
    }

    public void setSearchDomain(Domain domain) {
        ArgumentChecks.ensureNonNull("domain", (Object)domain);
        this.domain = domain;
    }

    public boolean isIgnoringAxes() {
        return this.ignoreAxes;
    }

    public void setIgnoringAxes(boolean ignore) {
        this.ignoreAxes = ignore;
    }

    private boolean match(IdentifiedObject candidate, IdentifiedObject object) {
        return Utilities.deepEquals(candidate, object, this.ignoreAxes ? ComparisonMode.ALLOW_VARIANT : COMPARISON_MODE);
    }

    Set<IdentifiedObject> getFromCache(IdentifiedObject object) {
        return this.wrapper != null ? this.wrapper.getFromCache(object) : null;
    }

    Set<IdentifiedObject> cache(IdentifiedObject object, Set<IdentifiedObject> result) {
        if (this.wrapper != null) {
            result = this.wrapper.cache(object, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
        ArgumentChecks.ensureNonNull("object", object);
        Set<IdentifiedObject> result = this.getFromCache(object);
        if (result == null) {
            AuthorityFactoryProxy<?> previousProxy = this.proxy;
            this.proxy = AuthorityFactoryProxy.getInstance(object.getClass());
            try {
                if (this.domain != Domain.EXHAUSTIVE_VALID_DATASET) {
                    IdentifiedObject candidate = this.createFromIdentifiers(object);
                    if (candidate == null) {
                        candidate = this.createFromNames(object);
                    }
                    if (candidate != null) {
                        result = Set.of(candidate);
                    }
                }
                if (result == null) {
                    result = this.domain == Domain.DECLARATION ? Set.of() : this.createFromCodes(object);
                }
            }
            finally {
                this.proxy = previousProxy;
            }
            result = this.cache(object, result);
        }
        return result;
    }

    public IdentifiedObject findSingleton(IdentifiedObject object) throws FactoryException {
        IdentifiedObject result = null;
        boolean sameAxisOrder = false;
        boolean ambiguous = false;
        try {
            for (IdentifiedObject candidate : this.find(object)) {
                boolean equalsIncludingAxes;
                boolean bl = equalsIncludingAxes = !this.ignoreAxes || Utilities.deepEquals(candidate, object, COMPARISON_MODE);
                if (result != null) {
                    ambiguous = true;
                    if (sameAxisOrder & equalsIncludingAxes) {
                        return null;
                    }
                }
                result = candidate;
                sameAxisOrder = equalsIncludingAxes;
            }
        }
        catch (BackingStoreException e) {
            throw e.unwrapOrRethrow(FactoryException.class);
        }
        return sameAxisOrder || !ambiguous ? result : null;
    }

    private IdentifiedObject createFromIdentifiers(IdentifiedObject object) throws FactoryException {
        for (Identifier id : object.getIdentifiers()) {
            IdentifiedObject candidate;
            String code = IdentifiedObjects.toString(id);
            if (code.indexOf(58) < 0) continue;
            try {
                candidate = this.create(code);
            }
            catch (NoSuchAuthorityCodeException e) {
                IdentifiedObjectFinder.exceptionOccurred(e);
                continue;
            }
            if (!this.match(candidate, object)) continue;
            return candidate;
        }
        return null;
    }

    private IdentifiedObject createFromNames(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate;
        String code = object.getName().getCode();
        try {
            candidate = this.create(code);
        }
        catch (FactoryException e) {
            IdentifiedObjectFinder.exceptionOccurred(e);
            candidate = null;
        }
        if (this.match(candidate, object)) {
            return candidate;
        }
        for (GenericName id : object.getAlias()) {
            code = id.toString();
            try {
                candidate = this.create(code);
            }
            catch (FactoryException e) {
                IdentifiedObjectFinder.exceptionOccurred(e);
                continue;
            }
            if (!this.match(candidate, object)) continue;
            return candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<IdentifiedObject> createFromCodes(IdentifiedObject object) throws FactoryException {
        LinkedHashSet<IdentifiedObject> result = new LinkedHashSet<IdentifiedObject>();
        boolean finer = Semaphores.queryAndSet(32);
        try {
            for (String code : this.getCodeCandidates(object)) {
                IdentifiedObject candidate;
                try {
                    candidate = this.create(code);
                }
                catch (FactoryException e) {
                    IdentifiedObjectFinder.exceptionOccurred(e);
                    continue;
                }
                if (!this.match(candidate, object)) continue;
                result.add(candidate);
            }
        }
        finally {
            Semaphores.clear(32, finer);
        }
        return result;
    }

    private IdentifiedObject create(String code) throws FactoryException {
        return (IdentifiedObject)this.proxy.createFromAPI(this.factory, code);
    }

    protected Set<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
        return this.factory.getAuthorityCodes(this.proxy.type.asSubclass(IdentifiedObject.class));
    }

    private static void exceptionOccurred(FactoryException exception) {
        Logging.completeAndLog(GeodeticAuthorityFactory.LOGGER, IdentifiedObjectFinder.class, "find", new LogRecord(Level.FINER, exception.getMessage()));
    }

    public static enum Domain {
        DECLARATION,
        VALID_DATASET,
        EXHAUSTIVE_VALID_DATASET,
        ALL_DATASET;

    }
}

