/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.resources.embedded;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.resources.Errors;

public class EmbeddedResources
extends InstallationResources {
    @Override
    public Set<String> getAuthorities() {
        return Collections.singleton("Embedded");
    }

    private void verifyAuthority(String authority) {
        if (!"Embedded".equalsIgnoreCase(authority)) {
            throw new IllegalArgumentException(Errors.format((short)45, "authority", authority));
        }
    }

    @Override
    public String getLicense(String authority, Locale locale, String mimeType) throws IOException {
        String filename;
        this.verifyAuthority(authority);
        if ("text/plain".equalsIgnoreCase(mimeType)) {
            filename = "LICENSE.txt";
        } else if ("text/html".equalsIgnoreCase(mimeType)) {
            filename = "LICENSE.html";
        } else {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(EmbeddedResources.class.getResourceAsStream(filename), "UTF-8"));){
            String line;
            while ((line = in.readLine()) != null) {
                buffer.append(line).append(lineSeparator);
            }
        }
        return buffer.toString();
    }

    @Override
    public String[] getResourceNames(String authority) {
        this.verifyAuthority(authority);
        return new String[]{"SpatialMetadata"};
    }

    @Override
    public DataSource getResource(String authority, int index) {
        this.verifyAuthority(authority);
        EmbeddedDataSource ds = new EmbeddedDataSource();
        ds.setDataSourceName("SpatialMetadata");
        ds.setDatabaseName("classpath:SIS_DATA/Databases/spatial-metadata");
        return ds;
    }

    @Override
    public BufferedReader openScript(String authority, int resource) throws IOException {
        this.verifyAuthority(authority);
        throw new IOException(Errors.format((short)7, DataSource.class, BufferedReader.class));
    }
}

