/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridResource;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedGridCoverage
extends GridCoverage {
    private final GridSliceLocator locator;
    private final int startAt;
    private final Loader loader;
    private final Object[] slices;
    private final boolean isConverted;
    private final MergeStrategy strategy;

    ConcatenatedGridCoverage(ConcatenatedGridResource source, GridGeometry domain, Object[] slices, int startAt, int[] deferred, GridGeometry request, int[] ranges) {
        super(domain, source.getSampleDimensions());
        this.loader = deferred != null ? new Loader(deferred, request, ranges) : null;
        this.slices = slices;
        this.startAt = startAt;
        this.isConverted = source.isConverted;
        this.locator = source.locator;
        this.strategy = source.strategy;
    }

    private ConcatenatedGridCoverage(ConcatenatedGridCoverage source, Object[] slices, List<SampleDimension> sampleDimensions, boolean converted) {
        super(source.getGridGeometry(), sampleDimensions);
        this.slices = slices;
        this.loader = source.loader;
        this.startAt = source.startAt;
        this.locator = source.locator;
        this.strategy = source.strategy;
        this.isConverted = converted;
    }

    private boolean isDeferred(int i) {
        return this.loader == null || (this.loader.deferred[i >>> 5] & 1 << i) != 0;
    }

    @Override
    protected GridCoverage createConvertedValues(boolean converted) {
        List<SampleDimension> sampleDimensions;
        boolean changed = false;
        GridCoverage template = null;
        Object[] c = (Object[])this.slices.clone();
        for (int i = 0; i < c.length; ++i) {
            if (!this.isDeferred(i)) {
                GridCoverage source = (GridCoverage)c[i];
                c[i] = source.forConvertedValues(converted);
                changed |= c[i] != source;
                template = source;
                continue;
            }
            changed |= converted != this.isConverted;
        }
        if (!changed) {
            return this;
        }
        if (template != null) {
            sampleDimensions = template.getSampleDimensions();
        } else {
            sampleDimensions = new ArrayList<SampleDimension>(this.getSampleDimensions());
            sampleDimensions.replaceAll(b -> b.forConvertedValues(converted));
        }
        return new ConcatenatedGridCoverage(this, c, sampleDimensions, converted);
    }

    @Override
    public RenderedImage render(GridExtent extent) {
        Object slice;
        GridGeometry[] candidates;
        GridGeometry request;
        int lower = this.startAt;
        int upper = lower + this.slices.length;
        if (extent != null) {
            upper = this.locator.getUpper(extent, lower, upper);
            lower = this.locator.getLower(extent, lower, upper);
        } else {
            extent = this.gridGeometry.getExtent();
        }
        int count = upper - lower;
        if (count > 1) {
            if (this.strategy == null) {
                Object[] arguments;
                short message;
                if (this.locator.isSlice(extent)) {
                    message = 79;
                    arguments = new Object[]{this.locator.getDimensionName(extent), lower, count};
                } else {
                    message = 52;
                    arguments = new Object[]{this.locator.getDimensionName(extent), count};
                }
                throw new SubspaceNotSpecifiedException(Resources.format(message, arguments));
            }
            try {
                request = new GridGeometry(this.getGridGeometry(), extent, null);
                candidates = new GridGeometry[count];
                for (int i = 0; i < count; ++i) {
                    int j = lower + i;
                    slice = this.slices[j];
                    candidates[i] = this.isDeferred(j) ? ((GridCoverageResource)slice).getGridGeometry() : ((GridCoverage)slice).getGridGeometry();
                }
            }
            catch (DataStoreException | TransformException e) {
                throw new CannotEvaluateException(Resources.format((short)53), e);
            }
        } else {
            request = null;
            candidates = null;
        }
        DisjointExtentException failure = null;
        if (count > 0) {
            while (true) {
                GridCoverage coverage;
                int index = lower;
                if (candidates != null) {
                    Integer n = this.strategy.apply(request, candidates);
                    if (n == null) break;
                    candidates[n.intValue()] = null;
                    index += n.intValue();
                }
                slice = this.slices[index];
                if (!this.isDeferred(index)) {
                    coverage = (GridCoverage)slice;
                } else {
                    try {
                        coverage = this.loader.getOrLoad(index, (GridCoverageResource)slice).forConvertedValues(this.isConverted);
                    }
                    catch (DataStoreException e) {
                        throw new CannotEvaluateException(Resources.format((short)78, index + this.startAt), e);
                    }
                }
                try {
                    RenderedImage image = coverage.render(this.locator.toSliceExtent(extent, index));
                    if (failure != null) {
                        Logging.ignorableException(ImageUtilities.LOGGER, ConcatenatedGridCoverage.class, "render", failure);
                    }
                    return image;
                }
                catch (DisjointExtentException e) {
                    if (failure == null) {
                        failure = e;
                        continue;
                    }
                    failure.addSuppressed(e);
                    if (candidates != null) continue;
                }
                break;
            }
        }
        if (failure == null) {
            failure = new DisjointExtentException(this.gridGeometry.getExtent(), extent, this.locator.searchDimension);
        }
        throw failure;
    }

    private static final class Loader {
        final int[] deferred;
        private final GridGeometry domain;
        private final int[] ranges;
        private final Cache<Integer, GridCoverage> coverages;

        Loader(int[] deferred, GridGeometry domain, int[] ranges) {
            this.deferred = deferred;
            this.domain = domain;
            this.ranges = ranges;
            this.coverages = new Cache(15, 2L, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final GridCoverage getOrLoad(Integer key, GridCoverageResource source) throws DataStoreException {
            GridCoverage coverage = this.coverages.peek(key);
            if (coverage == null) {
                Cache.Handler<GridCoverage> handler = this.coverages.lock(key);
                try {
                    coverage = handler.peek();
                    if (coverage == null) {
                        coverage = source.read(this.domain, this.ranges);
                    }
                }
                finally {
                    handler.putAndUnlock(coverage);
                }
            }
            return coverage;
        }
    }
}

