/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.CascadedStoreEvent;
import org.apache.sis.storage.event.CloseEvent;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;

public class StoreListeners
implements Localized {
    private final StoreListeners parent;
    private final Resource source;
    private volatile ForType<?> listeners;
    private volatile Set<Class<? extends StoreEvent>> permittedEventTypes;
    private static final Set<Class<? extends StoreEvent>> READ_EVENT_TYPES = Set.of(WarningEvent.class, CloseEvent.class);
    private Map<Class<?>, StoreListener<?>> cascadedListeners;

    public StoreListeners(StoreListeners parent, Resource source) {
        ArgumentChecks.ensureNonNull("source", source);
        this.source = source;
        this.parent = parent;
        if (parent != null) {
            this.permittedEventTypes = parent.permittedEventTypes;
        }
    }

    public Optional<StoreListeners> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Resource getSource() {
        return this.source;
    }

    private static DataStore getDataStore(StoreListeners m4) {
        do {
            DataStore ds;
            Resource source;
            if ((source = m4.source) instanceof StoreResource && (ds = ((StoreResource)source).getOriginator()) != null) {
                return ds;
            }
            if (!(source instanceof DataStore)) continue;
            return (DataStore)source;
        } while ((m4 = m4.parent) != null);
        return null;
    }

    public String getSourceName() {
        DataStore ds = StoreListeners.getDataStore(this);
        if (ds != null) {
            String name = ds.getDisplayName();
            if (name != null) {
                return name;
            }
            DataStoreProvider provider = ds.getProvider();
            if (provider != null && (name = provider.getShortName()) != null) {
                return name;
            }
        }
        return Vocabulary.getResources(this.getLocale()).getString((short)208);
    }

    @Override
    public Locale getLocale() {
        DataStore ds = StoreListeners.getDataStore(this);
        return ds != null ? ds.getLocale() : null;
    }

    public Logger getLogger() {
        Resource src = this.source;
        DataStore ds = StoreListeners.getDataStore(this);
        if (ds != null) {
            Logger logger;
            DataStoreProvider provider = ds.getProvider();
            if (provider != null && (logger = provider.getLogger()) != null) {
                return logger;
            }
            src = ds;
        }
        return Logging.getLogger(src.getClass());
    }

    public void warning(String message) {
        ArgumentChecks.ensureNonNull("message", message);
        this.warning(Level.WARNING, message, null);
    }

    public void warning(Exception exception) {
        ArgumentChecks.ensureNonNull("exception", exception);
        this.warning(Level.WARNING, null, exception);
    }

    public void warning(String message, Exception exception) {
        this.warning(Level.WARNING, message, exception);
    }

    public void warning(Level level, String message, Exception exception) {
        ArgumentChecks.ensureNonNull("level", level);
        if (exception == null) {
            ArgumentChecks.ensureNonEmpty("message", message);
        } else {
            message = Exceptions.formatChainedMessages(this.getLocale(), message, exception);
            if (message == null) {
                message = exception.toString();
            }
        }
        LogRecord record = new LogRecord(level, message);
        if (exception == null) {
            StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> stream.filter(frame -> StoreListeners.setPublicSource(record, frame.getDeclaringClass(), frame.getMethodName())).findFirst());
        } else {
            try {
                record.setThrown(exception);
                for (StackTraceElement e : exception.getStackTrace()) {
                    if (StoreListeners.setPublicSource(record, Class.forName(e.getClassName()), e.getMethodName())) break;
                }
            }
            catch (ClassNotFoundException e) {
                Logging.ignorableException(StoreUtilities.LOGGER, StoreListeners.class, "warning", e);
            }
        }
        this.warning(record, StoreUtilities.removeStackTraceInLogs());
    }

    private static boolean setPublicSource(LogRecord record, Class<?> type, String methodName) {
        if (Resource.class.isAssignableFrom(type)) {
            record.setSourceClassName(type.getCanonicalName());
            record.setSourceMethodName(methodName);
            for (Method m4 : type.getMethods()) {
                if (!methodName.equals(m4.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void warning(LogRecord description) {
        this.warning(description, null);
    }

    public void warning(LogRecord description, Filter onUnhandled) {
        if (!this.fire(WarningEvent.class, new WarningEvent(this.source, description)) && (onUnhandled == null || onUnhandled.isLoggable(description))) {
            Logger logger;
            String name = description.getLoggerName();
            if (name != null) {
                logger = Logger.getLogger(name);
            } else {
                logger = this.getLogger();
                description.setLoggerName(logger.getName());
            }
            logger.log(description);
        }
    }

    static void canNotNotify(String method, ExecutionException error) {
        Logging.unexpectedException(StoreUtilities.LOGGER, StoreListeners.class, method, error);
    }

    public <E extends StoreEvent> boolean fire(Class<E> eventType, E event) {
        ArgumentChecks.ensureNonNull("event", event);
        ArgumentChecks.ensureNonNull("eventType", eventType);
        Set<Class<? extends StoreEvent>> permittedEventTypes = this.permittedEventTypes;
        if (permittedEventTypes != null && !permittedEventTypes.contains(eventType)) {
            throw this.illegalEventType(eventType);
        }
        try {
            return StoreListeners.fire(this, eventType, event);
        }
        catch (ExecutionException ex) {
            StoreListeners.canNotNotify("fire", ex);
            return true;
        }
    }

    static <E extends StoreEvent> boolean fire(StoreListeners m4, Class<E> eventType, E event) throws ExecutionException {
        Map<StoreListener<?>, Boolean> done = null;
        ExecutionException error = null;
        do {
            ForType<?> e = m4.listeners;
            while (e != null) {
                if (e.type.isAssignableFrom(eventType)) {
                    try {
                        done = e.eventOccured(event, done);
                    }
                    catch (ExecutionException ex) {
                        if (error == null) {
                            error = ex;
                        }
                        error.getCause().addSuppressed(ex.getCause());
                    }
                }
                e = e.next;
            }
        } while (!event.isConsumedForParent() && (m4 = m4.parent) != null);
        if (error != null) {
            throw error;
        }
        return done != null && !done.isEmpty();
    }

    private IllegalArgumentException illegalEventType(Class<?> type) {
        return new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)65, type));
    }

    private static boolean isPossibleEvent(Set<Class<? extends StoreEvent>> permittedEventTypes, Class<?> eventType) {
        if (permittedEventTypes == null) {
            return true;
        }
        for (Class<? extends StoreEvent> type : permittedEventTypes) {
            if (!eventType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public synchronized <E extends StoreEvent> void addListener(Class<E> eventType, StoreListener<? super E> listener) {
        ArgumentChecks.ensureNonNull("listener", listener);
        ArgumentChecks.ensureNonNull("eventType", eventType);
        if (StoreListeners.isPossibleEvent(this.permittedEventTypes, eventType)) {
            ForType<Object> ce = null;
            ForType<?> e = this.listeners;
            while (e != null) {
                if (e.type.equals(eventType)) {
                    ce = e;
                    break;
                }
                e = e.next;
            }
            if (ce == null) {
                ce = new ForType<E>(eventType, this.listeners);
                this.listeners = ce;
            }
            ce.add(listener);
            if (this.parent != null && CascadedStoreEvent.class.isAssignableFrom(eventType)) {
                StoreListener<?> cascade;
                if (this.cascadedListeners == null) {
                    this.cascadedListeners = new IdentityHashMap(4);
                }
                if ((cascade = this.cascadedListeners.get(eventType)) == null) {
                    cascade = new CascadedStoreEvent.ParentListener(eventType, this.parent, this);
                    this.cascadedListeners.put(eventType, cascade);
                    this.parent.addListener(eventType, cascade);
                }
            }
        }
    }

    public synchronized <E extends StoreEvent> void removeListener(Class<E> eventType, StoreListener<? super E> listener) {
        ArgumentChecks.ensureNonNull("listener", listener);
        ArgumentChecks.ensureNonNull("eventType", eventType);
        ForType<?> e = this.listeners;
        while (e != null) {
            if (e.type.equals(eventType)) {
                StoreListener<?> cascade;
                if (!e.remove(listener) || this.cascadedListeners == null || (cascade = this.cascadedListeners.remove(eventType)) == null) break;
                this.parent.removeListener(eventType, cascade);
                break;
            }
            e = e.next;
        }
    }

    public <E extends StoreEvent> boolean hasListener(Class<E> eventType, StoreListener<? super E> listener) {
        ArgumentChecks.ensureNonNull("listener", listener);
        ArgumentChecks.ensureNonNull("eventType", eventType);
        ForType<? super E> e = this.listeners;
        while (e != null) {
            if (e.type.equals(eventType) && e.hasListener(listener)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean hasListeners(Class<? extends StoreEvent> eventType) {
        ArgumentChecks.ensureNonNull("eventType", eventType);
        StoreListeners m4 = this;
        do {
            ForType<?> e = m4.listeners;
            while (e != null) {
                if (eventType.isAssignableFrom(e.type) && e.count() != 0) {
                    return true;
                }
                e = e.next;
            }
        } while ((m4 = m4.parent) != null);
        return false;
    }

    public synchronized void setUsableEventTypes(Class<?> ... permitted) {
        ArgumentChecks.ensureNonEmpty("permitted", permitted);
        Set<Class<? extends StoreEvent>> current = this.permittedEventTypes;
        HashSet<Class<? extends StoreEvent>> types = new HashSet<Class<? extends StoreEvent>>(Containers.hashMapCapacity(permitted.length));
        for (Class<?> type : permitted) {
            if (!(current != null ? current.contains(type) : StoreEvent.class.isAssignableFrom(type))) {
                throw this.illegalEventType(type);
            }
            types.add(type);
        }
        this.permittedEventTypes = READ_EVENT_TYPES.equals(types) ? READ_EVENT_TYPES : Set.copyOf(types);
        ForType.removeUnreachables(this.listeners, types);
    }

    public synchronized void useReadOnlyEvents() {
        Set<Class<? extends StoreEvent>> current = this.permittedEventTypes;
        if (current == null) {
            this.permittedEventTypes = READ_EVENT_TYPES;
        } else if (!READ_EVENT_TYPES.equals(current)) {
            throw this.illegalEventType(WarningEvent.class);
        }
        ForType.removeUnreachables(this.listeners, READ_EVENT_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            StoreListeners.fire(this, CloseEvent.class, new CloseEvent(this.source));
        }
        catch (ExecutionException ex) {
            StoreListeners.canNotNotify("close", ex);
        }
        StoreListeners storeListeners = this;
        synchronized (storeListeners) {
            this.cascadedListeners = null;
            this.listeners = null;
        }
    }

    public String toString() {
        int count = 0;
        ForType<?> e = this.listeners;
        while (e != null) {
            count += e.count();
            e = e.next;
        }
        return Strings.toString(this.getClass(), "parent", this.parent != null ? Classes.getShortClassName(this.parent.source) : null, "source", Classes.getShortClassName(this.source), "count", count);
    }

    private static final class ForType<E extends StoreEvent> {
        final Class<E> type;
        private volatile StoreListener<? super E>[] listeners;
        final ForType<?> next;

        ForType(Class<E> type, ForType<?> next) {
            this.type = type;
            this.next = next;
        }

        final void add(StoreListener<? super E> listener) {
            StoreListener<? super E>[] list = this.listeners;
            int length = list != null ? list.length : 0;
            StoreListener[] copy = new StoreListener[length + 1];
            if (list != null) {
                System.arraycopy(list, 0, copy, 0, length);
            }
            copy[length] = listener;
            this.listeners = copy;
        }

        final boolean remove(StoreListener<? super E> listener) {
            Object list = this.listeners;
            if (list != null) {
                int i = ((StoreListener<? super E>[])list).length;
                while (--i >= 0) {
                    if (list[i] != listener) continue;
                    list = ((StoreListener<? super E>[])list).length == 1 ? null : ArraysExt.remove(list, i, 1);
                    this.listeners = list;
                    break;
                }
            }
            return list == null;
        }

        static void removeUnreachables(ForType<?> listeners, Set<Class<? extends StoreEvent>> permittedEventTypes) {
            while (listeners != null) {
                if (!StoreListeners.isPossibleEvent(permittedEventTypes, listeners.type)) {
                    listeners.listeners = null;
                }
                listeners = listeners.next;
            }
        }

        final boolean hasListener(StoreListener<?> listener) {
            return ArraysExt.containsIdentity(this.listeners, listener);
        }

        final int count() {
            return this.listeners != null ? this.listeners.length : 0;
        }

        final Map<StoreListener<?>, Boolean> eventOccured(E event, Map<StoreListener<?>, Boolean> done) throws ExecutionException {
            RuntimeException error = null;
            StoreListener<? super E>[] list = this.listeners;
            if (list != null) {
                if (done == null) {
                    done = new IdentityHashMap(list.length);
                }
                for (StoreListener<E> storeListener : list) {
                    if (((StoreEvent)event).isConsumed()) break;
                    if (done.put(storeListener, Boolean.TRUE) != null) continue;
                    try {
                        storeListener.eventOccured(event);
                    }
                    catch (RuntimeException ex) {
                        if (error == null) {
                            error = ex;
                            continue;
                        }
                        error.addSuppressed(ex);
                    }
                }
            }
            if (error != null) {
                throw new ExecutionException(Resources.format((short)74, this.type), error);
            }
            return done;
        }
    }
}

