/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.internal.converter.SurjectiveConverter;
import org.apache.sis.internal.metadata.RecordSchemaSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.iso.RecordDefinition;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.Record;
import org.opengis.util.RecordSchema;
import org.opengis.util.RecordType;
import org.opengis.util.Type;
import org.opengis.util.TypeName;

@XmlType(name="RecordType")
public class DefaultRecordType
extends RecordDefinition
implements RecordType,
Serializable {
    private static final long serialVersionUID = -1534515712654429099L;
    private final TypeName typeName;
    private final RecordSchema container;
    private transient Type[] fieldTypes;

    public DefaultRecordType(RecordType other) {
        this.typeName = other.getTypeName();
        this.container = other.getContainer();
        this.fieldTypes = this.computeTransientFields(other.getFieldTypes());
    }

    public DefaultRecordType(TypeName typeName, RecordSchema container, Map<? extends MemberName, ? extends Type> fields) {
        ArgumentChecks.ensureNonNull("typeName", typeName);
        ArgumentChecks.ensureNonNull("container", container);
        ArgumentChecks.ensureNonNull("field", fields);
        this.typeName = typeName;
        this.container = container;
        this.fieldTypes = this.computeTransientFields(fields);
        LocalName schemaName = container.getSchemaName();
        GenericName fullTypeName = typeName.toFullyQualifiedName();
        if (schemaName.compareTo(typeName.scope().name().tip()) != 0) {
            throw new IllegalArgumentException(Errors.format((short)68, schemaName, fullTypeName));
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MemberName name = this.getName(i);
            Type type = this.fieldTypes[i];
            if (type == null || name.getAttributeType().compareTo(type.getTypeName()) != 0) {
                throw new IllegalArgumentException(Errors.format((short)55, name, type));
            }
            if (fullTypeName.compareTo(name.scope().name()) == 0) continue;
            throw new IllegalArgumentException(Errors.format((short)68, fullTypeName, name.toFullyQualifiedName()));
        }
    }

    DefaultRecordType(TypeName typeName, RecordSchema container, Map<? extends CharSequence, ? extends Type> fields, NameFactory nameFactory) {
        this.typeName = typeName;
        this.container = container;
        NameSpace namespace = nameFactory.createNameSpace(typeName, null);
        LinkedHashMap<MemberName, Type> fieldTypes = new LinkedHashMap<MemberName, Type>(Containers.hashMapCapacity(fields.size()));
        for (Map.Entry<? extends CharSequence, ? extends Type> entry : fields.entrySet()) {
            Type type = entry.getValue();
            CharSequence name = entry.getKey();
            MemberName member = nameFactory.createMemberName(namespace, name, type.getTypeName());
            if (fieldTypes.put(member, type) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)24, member));
        }
        this.fieldTypes = this.computeTransientFields(fieldTypes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        LinkedHashMap<MemberName, Type> fields = new LinkedHashMap<MemberName, Type>(Containers.hashMapCapacity(size));
        for (int i = 0; i < size; ++i) {
            Type type;
            MemberName member = (MemberName)in.readObject();
            if (fields.put(member, type = (Type)in.readObject()) == null) continue;
            throw new InvalidObjectException(Errors.format((short)24, member));
        }
        this.fieldTypes = this.computeTransientFields(fields);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int size = this.size();
        out.defaultWriteObject();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(this.getName(i));
            out.writeObject(this.fieldTypes[i]);
        }
    }

    public static DefaultRecordType castOrCopy(RecordType other) {
        if (other == null || other instanceof DefaultRecordType) {
            return (DefaultRecordType)other;
        }
        return new DefaultRecordType(other);
    }

    @Override
    final RecordType getRecordType() {
        return this;
    }

    @Override
    public TypeName getTypeName() {
        return this.typeName;
    }

    @Override
    @Deprecated(since="1.0")
    public RecordSchema getContainer() {
        return this.container;
    }

    @Override
    public Map<MemberName, Type> getFieldTypes() {
        return ObjectConverters.derivedValues(this.fieldIndices(), MemberName.class, new SurjectiveConverter<Integer, Type>(){

            @Override
            public Class<Integer> getSourceClass() {
                return Integer.class;
            }

            @Override
            public Class<Type> getTargetClass() {
                return Type.class;
            }

            @Override
            public Type apply(Integer index) {
                return DefaultRecordType.this.getType(index);
            }
        });
    }

    @Override
    public Set<MemberName> getMembers() {
        return this.fieldIndices().keySet();
    }

    final Type getType(int index) {
        return this.fieldTypes[index];
    }

    @Override
    public TypeName locate(MemberName fieldName) {
        Integer index = this.indexOf(fieldName);
        return index != null ? this.getType(index).getTypeName() : null;
    }

    @Override
    public boolean isInstance(Record record) {
        return record != null && this.getMembers().containsAll(record.getAttributes().keySet());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            DefaultRecordType that = (DefaultRecordType)other;
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.container, that.container) && Arrays.equals(this.fieldTypes, that.fieldTypes) && this.fieldIndices().equals(that.fieldIndices());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.typeName) + 31 * (this.fieldIndices().hashCode() + 31 * Arrays.hashCode(this.fieldTypes));
    }

    private DefaultRecordType() {
        this.typeName = RecordSchemaSIS.MULTILINE;
        this.container = RecordSchemaSIS.STRING.container;
    }

    @XmlValue
    private String getValue() {
        switch (this.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return String.valueOf(this.fieldTypes[0]);
            }
        }
        return this.toString(null, null);
    }

    private void setValue(String value) {
        if (value != null) {
            LinkedHashMap<MemberName, Type> fields = new LinkedHashMap<MemberName, Type>();
            for (CharSequence element : CharSequences.splitOnEOL(value)) {
                int s2 = ((String)element).indexOf(58);
                if (s2 >= 0) {
                    element = element.subSequence(0, CharSequences.skipTrailingWhitespaces(element, 0, s2));
                }
                MemberName m4 = Names.createMemberName(this.typeName, element, String.class);
                fields.put(m4, RecordSchemaSIS.INSTANCE.toAttributeType(String.class));
            }
            this.fieldTypes = this.computeTransientFields(fields);
        }
    }
}

