/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.xml.ValueConverter;
import org.opengis.metadata.Metadata;

final class LegacyCodes {
    static final Map<String, String> IANA_TO_LEGACY;
    static final Map<String, String> LEGACY_TO_IANA;

    private LegacyCodes() {
    }

    static String fromIANA(String name) {
        String legacy = IANA_TO_LEGACY.get(name);
        if (legacy == null && (legacy = IANA_TO_LEGACY.get(name.toUpperCase(Locale.US))) == null) {
            return name;
        }
        return legacy;
    }

    static String toIANA(String legacy) {
        String name = LEGACY_TO_IANA.get(legacy);
        if (name == null && (name = LEGACY_TO_IANA.get(legacy.toLowerCase(Locale.US))) == null) {
            return legacy;
        }
        return name;
    }

    static {
        Properties codes = new Properties();
        try (InputStream in = Metadata.class.getResourceAsStream("2003/charset-codes.properties");){
            codes.load(in);
        }
        catch (IOException e) {
            Logging.unexpectedException(Context.LOGGER, ValueConverter.class, "toCharset[Code]", e);
        }
        int capacity = Containers.hashMapCapacity(codes.size());
        IANA_TO_LEGACY = new HashMap<String, String>(capacity);
        LEGACY_TO_IANA = new HashMap<String, String>(capacity);
        for (Map.Entry<Object, Object> entry : codes.entrySet()) {
            String legacy = ((String)entry.getKey()).intern();
            String name = ((String)entry.getValue()).intern();
            IANA_TO_LEGACY.put(name.toUpperCase(Locale.US), legacy);
            LEGACY_TO_IANA.put(legacy.toLowerCase(Locale.US), name);
            IANA_TO_LEGACY.put(name, legacy);
            LEGACY_TO_IANA.put(legacy, name);
        }
    }
}

