/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.jaxb.IdentifierMapAdapter;
import org.apache.sis.internal.jaxb.ModifiableIdentifierMap;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.metadata.Identifier;

final class NilObjectHandler
implements InvocationHandler {
    private final Object attribute;

    NilObjectHandler(Identifier[] identifiers) {
        ArrayList<Identifier> asList = new ArrayList<Identifier>(identifiers.length);
        for (Identifier identifier : identifiers) {
            if (identifier == null) continue;
            asList.add(identifier);
        }
        this.attribute = new ModifiableIdentifierMap(asList);
    }

    NilObjectHandler(NilReason nilReason) {
        this.attribute = nilReason;
    }

    static boolean isIgnoredInterface(Class<?> type) {
        return IdentifiedObject.class.isAssignableFrom(type) || NilObject.class.isAssignableFrom(type) || LenientComparable.class.isAssignableFrom(type);
    }

    private static Class<?> getInterface(Object proxy) {
        for (Class<?> type : proxy.getClass().getInterfaces()) {
            if (NilObjectHandler.isIgnoredInterface(type)) continue;
            return type;
        }
        throw new AssertionError(proxy);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (args == null) {
            switch (name) {
                case "getNilReason": {
                    return this.attribute instanceof NilReason ? (NilReason)this.attribute : null;
                }
                case "getIdentifierMap": {
                    return this.attribute instanceof IdentifierMap ? (IdentifierMap)this.attribute : Collections.emptyMap();
                }
                case "getIdentifiers": {
                    return this.attribute instanceof IdentifierMapAdapter ? ((IdentifierMapAdapter)this.attribute).getIdentifiers(method.getReturnType()) : Collections.emptyList();
                }
                case "toString": {
                    return Strings.bracket(NilObjectHandler.getInterface(proxy), this.attribute);
                }
                case "hashCode": {
                    return ~this.attribute.hashCode();
                }
            }
            if (name.startsWith("get") || name.startsWith("is")) {
                return Numbers.valueOfNil(method.getReturnType());
            }
        } else {
            switch (args.length) {
                case 1: {
                    if (name.equals("equals")) {
                        return this.equals(proxy, args[0], ComparisonMode.STRICT);
                    }
                    if (!name.startsWith("set")) break;
                    throw new UnsupportedOperationException(Errors.format((short)153, NilObjectHandler.getInterface(proxy)));
                }
                case 2: {
                    if (!name.equals("equals")) break;
                    return this.equals(proxy, args[0], (ComparisonMode)((Object)args[1]));
                }
            }
        }
        throw new UnsupportedOperationException(Errors.format((short)162, NilObjectHandler.getInterface(proxy).getSimpleName() + "." + name));
    }

    private boolean equals(Object proxy, Object other, ComparisonMode mode) throws Throwable {
        if (other == proxy) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (proxy.getClass() == other.getClass()) {
            if (mode.isIgnoringMetadata()) {
                return true;
            }
            NilObjectHandler h2 = (NilObjectHandler)Proxy.getInvocationHandler(other);
            return this.attribute.equals(h2.attribute);
        }
        switch (mode) {
            case STRICT: {
                return false;
            }
            case BY_CONTRACT: {
                Collection<Identifier> tx = this.attribute;
                Object ox = null;
                if (tx instanceof IdentifierMapAdapter) {
                    tx = ((IdentifierMapAdapter)((Object)tx)).identifiers;
                    if (other instanceof IdentifiedObject) {
                        ox = ((IdentifiedObject)other).getIdentifiers();
                    }
                } else if (other instanceof NilObject) {
                    ox = ((NilObject)other).getNilReason();
                }
                if (Objects.equals(tx, ox)) break;
                return false;
            }
        }
        Class<?> type = NilObjectHandler.getInterface(proxy);
        if (!type.isInstance(other)) {
            return false;
        }
        for (Method getter : type.getMethods()) {
            Object value;
            if (!Classes.isPossibleGetter(getter)) continue;
            try {
                value = getter.invoke(other, (Object[])null);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            if (value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof Map && ((Map)value).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

