/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSGeometryFactory;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive.JTSPrimitiveFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class GeometryUtils {
    private static final Logger LOGGER = Logger.getLogger("org.geotoolkit.geometry.isoonjts");
    private static final Envelope WHOLE_WORLD;

    private GeometryUtils() {
    }

    public static Envelope getWholeWorld() {
        return WHOLE_WORLD;
    }

    public static CoordinateReferenceSystem getCRS(Envelope envelope) {
        return envelope.getLowerCorner().getCoordinateReferenceSystem();
    }

    public static double[] getBBox(Envelope envelope, Unit unit) {
        if (unit.equals(Units.DEGREE)) {
            try {
                envelope = Envelopes.transform(envelope, CommonCRS.WGS84.normalizedGeographic());
            }
            catch (TransformException ex) {
                LOGGER.severe("unable to reproject the envelope:" + ex.getMessage());
            }
        }
        double[] returnable = new double[4];
        DirectPosition lowerCorner = envelope.getLowerCorner();
        DirectPosition upperCorner = envelope.getUpperCorner();
        CoordinateSystem cs = GeometryUtils.getCRS(envelope).getCoordinateSystem();
        int xIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.EAST);
        Unit xUnit = GeometryUtils.getDirectedAxisUnit(cs, AxisDirection.EAST);
        int yIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.NORTH);
        Unit yUnit = GeometryUtils.getDirectedAxisUnit(cs, AxisDirection.NORTH);
        UnitConverter xConverter = xUnit.getConverterTo(unit);
        UnitConverter yConverter = yUnit.getConverterTo(unit);
        returnable[0] = xConverter.convert(lowerCorner.getOrdinate(xIndex));
        returnable[1] = yConverter.convert(lowerCorner.getOrdinate(yIndex));
        returnable[2] = xConverter.convert(upperCorner.getOrdinate(xIndex));
        returnable[3] = yConverter.convert(upperCorner.getOrdinate(yIndex));
        return returnable;
    }

    public static Envelope createCRSEnvelope(CoordinateReferenceSystem crs, double minx, double miny, double maxx, double maxy) {
        JTSGeometryFactory geometryFactory = new JTSGeometryFactory(crs);
        DirectPosition lowerCorner = geometryFactory.createDirectPosition();
        lowerCorner.setOrdinate(0, minx);
        lowerCorner.setOrdinate(1, miny);
        DirectPosition upperCorner = geometryFactory.createDirectPosition();
        upperCorner.setOrdinate(0, maxx);
        upperCorner.setOrdinate(1, maxy);
        return geometryFactory.createEnvelope(lowerCorner, upperCorner);
    }

    public static Envelope createEnvelope(CoordinateReferenceSystem crs, double minx, double miny, double maxx, double maxy, Unit unit) {
        JTSGeometryFactory geometryFactory = new JTSGeometryFactory(crs);
        CoordinateSystem cs = crs.getCoordinateSystem();
        int xIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.EAST);
        Unit xUnit = GeometryUtils.getDirectedAxisUnit(cs, AxisDirection.EAST);
        int yIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.NORTH);
        Unit yUnit = GeometryUtils.getDirectedAxisUnit(cs, AxisDirection.NORTH);
        UnitConverter xConverter = xUnit.getConverterTo(unit);
        UnitConverter yConverter = yUnit.getConverterTo(unit);
        double[] lowerOrdinates = new double[crs.getCoordinateSystem().getDimension()];
        lowerOrdinates[xIndex] = xConverter.convert(minx);
        lowerOrdinates[yIndex] = yConverter.convert(miny);
        double[] upperOrdinates = new double[crs.getCoordinateSystem().getDimension()];
        upperOrdinates[xIndex] = xConverter.convert(maxx);
        upperOrdinates[yIndex] = yConverter.convert(maxy);
        DirectPosition lowerCorner = geometryFactory.createDirectPosition(lowerOrdinates);
        DirectPosition upperCorner = geometryFactory.createDirectPosition(upperOrdinates);
        return geometryFactory.createEnvelope(lowerCorner, upperCorner);
    }

    public static boolean within(Envelope envelope, CoordinateReferenceSystem crs, double minx, double miny, double maxx, double maxy) {
        CoordinateSystem cs = crs.getCoordinateSystem();
        int xIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.EAST);
        int yIndex = GeometryUtils.getDirectedAxisIndex(cs, AxisDirection.NORTH);
        return minx <= envelope.getMinimum(xIndex) && maxx >= envelope.getMaximum(xIndex) && miny <= envelope.getMinimum(yIndex) && maxy >= envelope.getMaximum(yIndex);
    }

    public static boolean equals(Envelope envelope1, Envelope envelope2) {
        double[] bbox2;
        if (envelope1 == null || envelope2 == null) {
            return false;
        }
        double[] bbox1 = GeometryUtils.getBBox(envelope1, Units.DEGREE);
        return bbox1[0] == (bbox2 = GeometryUtils.getBBox(envelope2, Units.DEGREE))[0] && bbox1[1] == bbox2[1] && bbox1[2] == bbox2[2] && bbox1[3] == bbox2[3];
    }

    public static boolean intersects(Envelope envelope1, Envelope envelope2) {
        DirectPosition top1 = envelope1.getUpperCorner();
        DirectPosition bot1 = envelope1.getLowerCorner();
        DirectPosition top2 = envelope2.getUpperCorner();
        DirectPosition bot2 = envelope2.getLowerCorner();
        CoordinateReferenceSystem crs = top1.getCoordinateReferenceSystem();
        if (!(crs.equals(bot1.getCoordinateReferenceSystem()) && crs.equals(top2.getCoordinateReferenceSystem()) && crs.equals(bot2.getCoordinateReferenceSystem()))) {
            throw new IllegalArgumentException("Current implementation of GeoemtryUtils.intersect requires that the corners of both Envelopes have the same CRS");
        }
        double minx1 = bot1.getOrdinate(0);
        double maxx1 = top1.getOrdinate(0);
        double miny1 = bot1.getOrdinate(1);
        double maxy1 = top1.getOrdinate(1);
        double minx2 = bot2.getOrdinate(0);
        double maxx2 = top2.getOrdinate(0);
        double miny2 = bot2.getOrdinate(1);
        double maxy2 = top2.getOrdinate(1);
        boolean xoverlap = minx2 < maxx1 && maxx2 > minx1;
        return xoverlap && miny2 < maxy1 && maxy2 > miny1;
    }

    public static DirectPosition[] getDirectPositions(double[] points, AxisDirection[] sourceDirections, Unit[] sourceUnits, CoordinateReferenceSystem crs) {
        int dimension = crs.getCoordinateSystem().getDimension();
        int length = points.length / dimension;
        DirectPosition[] returnable = new DirectPosition[length];
        for (int i = 0; i < length; ++i) {
            LOGGER.fine("need to make a DirectPosition");
        }
        return returnable;
    }

    public static double[] getPoints(DirectPosition[] positions, AxisDirection[] targetDirections, Unit[] targetUnits) {
        int i;
        int length = positions.length * targetDirections.length;
        double[] returnable = new double[length];
        CoordinateReferenceSystem crs = positions[0].getCoordinateReferenceSystem();
        CoordinateSystem cs = crs.getCoordinateSystem();
        int dimension = cs.getDimension();
        int[] axisIndices = new int[targetDirections.length];
        UnitConverter[] converters = new UnitConverter[targetUnits.length];
        for (i = 0; i < targetDirections.length; ++i) {
            boolean notfound = true;
            for (int j = 0; notfound && j < dimension; ++j) {
                if (!cs.getAxis(j).getDirection().equals(targetDirections[i])) continue;
                axisIndices[i] = j;
                converters[i] = cs.getAxis(j).getUnit().getConverterTo(targetUnits[i]);
                notfound = false;
            }
        }
        for (i = 0; i < positions.length; ++i) {
            for (int j = 0; j < axisIndices.length; ++j) {
                returnable[i * dimension + j] = converters[j].convert(positions[i].getOrdinate(axisIndices[j]));
            }
        }
        return returnable;
    }

    public static DirectPosition ensureWGS84(DirectPosition dp) {
        GeographicCRS wgs84crs;
        CoordinateReferenceSystem crs = dp.getCoordinateReferenceSystem();
        int dim = crs.getCoordinateSystem().getDimension();
        CoordinateReferenceSystem bcrs = crs instanceof ProjectedCRS ? ((ProjectedCRS)crs).getBaseCRS() : crs;
        if (bcrs.equals(wgs84crs = CommonCRS.WGS84.geographic3D())) {
            return dp;
        }
        if (bcrs.toWKT().indexOf("WGS84") > -1) {
            return dp;
        }
        if (bcrs instanceof GeographicCRS && ((GeographicCRS)bcrs).getDatum().equals(wgs84crs.getDatum())) {
            return dp;
        }
        DirectPosition dp2 = new JTSGeometryFactory(wgs84crs).createDirectPosition();
        try {
            MathTransform transform = CRS.findOperation(crs, wgs84crs, null).getMathTransform();
            transform.transform(dp, dp2);
        }
        catch (FactoryException fe) {
            LOGGER.log(Level.WARNING, "Could not create CoordinateOperation to convert DirectPosition CRS " + crs.getName() + " to WGS84, using original coordinates", fe);
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not transform DirectPosition CRS " + crs.getName() + " to WGS84, using original coordinates", e);
        }
        catch (MismatchedDimensionException e) {
            LOGGER.log(Level.WARNING, "Dimension mismatch prevented conversion of DirectPosition CRS " + crs.getName() + " to WGS84, using original coordinates", e);
        }
        return dp2;
    }

    public static void populatePointArray(PointArray pointArray, DirectPosition[] dps) {
        PointArray pts = pointArray;
        pts.clear();
        int count = dps.length;
        for (int i = 0; i < count; ++i) {
            pts.add(dps[i]);
        }
    }

    public static LineString[] getLineCharSequences(CompositeCurve cc) {
        ArrayList lsList = GeometryUtils.getLineCharSequences(cc, new ArrayList());
        if (lsList == null) {
            throw new IllegalArgumentException("Unable to convert all elements of CompositeCurve to LineString");
        }
        return lsList.toArray(new LineString[lsList.size()]);
    }

    private static ArrayList getLineCharSequences(CompositeCurve cc, ArrayList lsList) {
        Collection elements = cc.getGenerators();
        boolean valid = true;
        if (!elements.isEmpty()) {
            Iterator it = elements.iterator();
            LineString ls = null;
            while (it.hasNext() && valid) {
                Object element = it.next();
                if (element instanceof CompositeCurve) {
                    valid = GeometryUtils.getLineCharSequences((CompositeCurve)element, lsList) != null;
                    continue;
                }
                if (element instanceof Curve) {
                    ls = ((Curve)element).asLineString(Double.MAX_VALUE, Double.MAX_VALUE);
                    if (ls != null) {
                        lsList.add(ls);
                        continue;
                    }
                    valid = false;
                    continue;
                }
                valid = false;
            }
        }
        if (valid) {
            return null;
        }
        return lsList;
    }

    public static DirectPosition[] getDirectPositions(LineString lineString) {
        PointArray controlPoints = lineString.getControlPoints();
        DirectPosition[] returnable = new DirectPosition[controlPoints.size()];
        for (int i = 0; i < controlPoints.size(); ++i) {
            returnable[i] = controlPoints.getDirectPosition(i, null);
        }
        return returnable;
    }

    public static DirectPosition[] getDirectPositions(Ring ring) {
        ArrayList<DirectPosition> directPositionList = new ArrayList<DirectPosition>();
        Collection generators = ring.getGenerators();
        for (int i = 0; i < generators.size(); ++i) {
            Curve curve = (Curve)generators.get(i);
            List<? extends CurveSegment> segments = curve.getSegments();
            for (int j = 0; j < segments.size(); ++j) {
                CurveSegment curveSegment = segments.get(j);
                if (!(curveSegment instanceof LineString)) continue;
                LineString lineString = (LineString)curveSegment;
                DirectPosition[] positions = GeometryUtils.getDirectPositions(lineString);
                directPositionList.addAll(Arrays.asList(positions));
            }
        }
        if (directPositionList.size() > 0) {
            return directPositionList.toArray(new DirectPosition[directPositionList.size()]);
        }
        return new DirectPosition[0];
    }

    public static DirectPosition[] getExteriorDirectPositions(Polygon polygon) {
        SurfaceBoundary surfaceBoundary = polygon.getBoundary();
        Ring exteriorRing = surfaceBoundary.getExterior();
        return GeometryUtils.getDirectPositions(exteriorRing);
    }

    public static DirectPosition[][] getInteriorDirectPositions(Polygon polygon) {
        SurfaceBoundary surfaceBoundary = polygon.getBoundary();
        List<Ring> interiorRings = surfaceBoundary.getInteriors();
        DirectPosition[][] returnable = new DirectPosition[interiorRings.size()][];
        for (int i = 0; i < interiorRings.size(); ++i) {
            returnable[i] = GeometryUtils.getDirectPositions(interiorRings.get(i));
        }
        return returnable;
    }

    public static PolyhedralSurface createPolyhedralSurface(DirectPosition[][] patchPoints) {
        CoordinateReferenceSystem crs = patchPoints[0][0].getCoordinateReferenceSystem();
        JTSGeometryFactory geometryFactory = new JTSGeometryFactory(crs);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(patchPoints.length);
        for (int i = 0; i < patchPoints.length; ++i) {
            Polygon polygon = GeometryUtils.createPolygon(patchPoints[i]);
            polygons.add(polygon);
        }
        return geometryFactory.createPolyhedralSurface(polygons);
    }

    public static Polygon createPolygon(DirectPosition[] exteriorRing) {
        return GeometryUtils.createPolygon(exteriorRing, new DirectPosition[0][0]);
    }

    public static Polygon createPolygon(DirectPosition[] exteriorRingPoints, DirectPosition[][] interiorRingsPoints) {
        CoordinateReferenceSystem crs = exteriorRingPoints[0].getCoordinateReferenceSystem();
        JTSGeometryFactory geometryFactory = new JTSGeometryFactory(crs);
        JTSPrimitiveFactory primitiveFactory = new JTSPrimitiveFactory(crs);
        Ring exteriorRing = GeometryUtils.createRing(primitiveFactory, exteriorRingPoints);
        List interiorRingList = interiorRingsPoints.length == 0 ? Collections.EMPTY_LIST : new ArrayList(interiorRingsPoints.length);
        for (int i = 0; i < interiorRingsPoints.length; ++i) {
            DirectPosition[] interiorRingPoints = interiorRingsPoints[i];
            interiorRingList.add(GeometryUtils.createRing(primitiveFactory, interiorRingPoints));
        }
        SurfaceBoundary surfaceBoundary = primitiveFactory.createSurfaceBoundary(exteriorRing, (List<Ring>)interiorRingList);
        return geometryFactory.createPolygon(surfaceBoundary);
    }

    public static SurfaceBoundary createSurfaceBoundary(DirectPosition[] exteriorRingPoints, DirectPosition[][] interiorRingsPoints) {
        CoordinateReferenceSystem crs = exteriorRingPoints[0].getCoordinateReferenceSystem();
        JTSPrimitiveFactory primitiveFactory = new JTSPrimitiveFactory(crs);
        return GeometryUtils.createSurfaceBoundary(primitiveFactory, exteriorRingPoints, interiorRingsPoints);
    }

    private static SurfaceBoundary createSurfaceBoundary(PrimitiveFactory primitiveFactory, DirectPosition[] exteriorRingPoints, DirectPosition[][] interiorRingsPoints) {
        Ring exteriorRing = GeometryUtils.createRing(primitiveFactory, exteriorRingPoints);
        List interiorRingList = interiorRingsPoints.length == 0 ? Collections.EMPTY_LIST : new ArrayList();
        for (int i = 0; i < interiorRingsPoints.length; ++i) {
            interiorRingList.add(GeometryUtils.createRing(primitiveFactory, interiorRingsPoints[i]));
        }
        SurfaceBoundary surfaceBoundary = primitiveFactory.createSurfaceBoundary(exteriorRing, interiorRingList);
        return surfaceBoundary;
    }

    public static Ring createRing(DirectPosition[] points) {
        CoordinateReferenceSystem crs = points[0].getCoordinateReferenceSystem();
        JTSPrimitiveFactory primitiveFactory = new JTSPrimitiveFactory(crs);
        return GeometryUtils.createRing(primitiveFactory, points);
    }

    private static Ring createRing(PrimitiveFactory primitiveFactory, DirectPosition[] points) {
        List<OrientableCurve> curveList = Collections.singletonList(GeometryUtils.createCurve(primitiveFactory, points));
        Ring ring = primitiveFactory.createRing(curveList);
        return ring;
    }

    public static Curve createCurve(DirectPosition[] points) {
        CoordinateReferenceSystem crs = points[0].getCoordinateReferenceSystem();
        JTSPrimitiveFactory primitiveFactory = new JTSPrimitiveFactory(crs);
        return GeometryUtils.createCurve(primitiveFactory, points);
    }

    private static Curve createCurve(PrimitiveFactory primitiveFactory, DirectPosition[] points) {
        JTSGeometryFactory geometryFactory = new JTSGeometryFactory(primitiveFactory.getCoordinateReferenceSystem());
        List<CurveSegment> curveSegmentList = Collections.singletonList(GeometryUtils.createLineString(geometryFactory, points));
        Curve curve = primitiveFactory.createCurve(curveSegmentList);
        return curve;
    }

    public static LineString createLineString(DirectPosition[] points) {
        CoordinateReferenceSystem crs = points[0].getCoordinateReferenceSystem();
        JTSGeometryFactory geometryFactory = new JTSGeometryFactory(crs);
        return GeometryUtils.createLineString(geometryFactory, points);
    }

    private static LineString createLineString(GeometryFactory geometryFactory, DirectPosition[] points) {
        LineString lineString = geometryFactory.createLineString(new ArrayList<Position>(Arrays.asList(points)));
        return lineString;
    }

    public static void checkDimension(String name, CoordinateReferenceSystem crs, int expected) {
        int actual;
        if (crs != null && (actual = crs.getCoordinateSystem().getDimension()) != expected) {
            throw new IllegalArgumentException("");
        }
    }

    public static void ensureDimensionMatch(String name, int dimension, int expectedDimension) throws MismatchedDimensionException {
        if (dimension != expectedDimension) {
            throw new MismatchedDimensionException(name + " does not have " + dimension + "dimension(s)");
        }
    }

    public static CoordinateSystemAxis getDirectedAxis(CoordinateSystem cs, AxisDirection direction) {
        int dimension = cs.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (!cs.getAxis(i).getDirection().equals(direction)) continue;
            return cs.getAxis(i);
        }
        return null;
    }

    public static int getDirectedAxisIndex(CoordinateSystem cs, AxisDirection direction) {
        int dimension = cs.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (!cs.getAxis(i).getDirection().equals(direction)) continue;
            return i;
        }
        return -1;
    }

    public static Unit getDirectedAxisUnit(CoordinateSystem cs, AxisDirection direction) {
        CoordinateSystemAxis axis = GeometryUtils.getDirectedAxis(cs, direction);
        if (axis != null) {
            return axis.getUnit();
        }
        return null;
    }

    static {
        GeographicCRS crs = CommonCRS.WGS84.geographic();
        JTSGeometryFactory geometryFactory = new JTSGeometryFactory(crs);
        DirectPosition lowerCorner = geometryFactory.createDirectPosition(new double[]{-90.0, -180.0});
        DirectPosition upperCorner = geometryFactory.createDirectPosition(new double[]{90.0, 180.0});
        WHOLE_WORLD = geometryFactory.createEnvelope(lowerCorner, upperCorner);
    }
}

