/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.geometry.JTSPolygon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.complex.CompositeSurface;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlType(name="PolyHedralSurfaceType", namespace="http://www.opengis.net/gml")
public class JTSPolyhedralSurface
extends AbstractJTSGeometry
implements PolyhedralSurface {
    private static final long serialVersionUID = 4153619785904408034L;
    @XmlElement(name="polygonPatches", namespace="http://www.opengis.net/gml")
    protected final List<JTSPolygon> patches = new ArrayList<JTSPolygon>();

    public JTSPolyhedralSurface() {
        this(null);
    }

    public JTSPolyhedralSurface(CoordinateReferenceSystem crs) {
        super(crs);
    }

    @Override
    public SurfaceBoundary getBoundary() {
        return (SurfaceBoundary)super.getBoundary();
    }

    public List<JTSPolygon> getPatches() {
        return this.patches;
    }

    @Override
    public double[] getUpNormal(DirectPosition point) {
        return new double[]{0.0, 0.0, 1.0};
    }

    @Override
    public double getPerimeter() {
        return this.getJTSGeometry().getBoundary().getLength();
    }

    @Override
    public double getArea() {
        return this.getJTSGeometry().getArea();
    }

    @Override
    public CompositeSurface getComposite() {
        return null;
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public Surface getPrimitive() {
        return this;
    }

    public Set getComplexes() {
        return null;
    }

    public Set getContainingPrimitives() {
        return null;
    }

    @Override
    public OrientableSurface[] getProxy() {
        return null;
    }

    public Set getContainedPrimitives() {
        return null;
    }

    @Override
    protected Geometry computeJTSPeer() {
        if (this.patches.size() > 1) {
            Polygon[] polygons = new Polygon[this.patches.size()];
            for (int i = 0; i < this.patches.size(); ++i) {
                JTSGeometry jtsGeometry = this.patches.get(i);
                polygons[i] = (Polygon)jtsGeometry.getJTSGeometry();
            }
            return JTSUtils.GEOMETRY_FACTORY.createMultiPolygon(polygons);
        }
        return ((JTSGeometry)this.patches.get(0)).getJTSGeometry();
    }

    @Override
    public JTSPolyhedralSurface clone() {
        return (JTSPolyhedralSurface)super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JTSPolyhedralSurface && super.equals(object)) {
            JTSPolyhedralSurface that = (JTSPolyhedralSurface)object;
            return Objects.equals(this.patches, that.patches);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 67 * hash + (this.patches != null ? this.patches.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.patches != null) {
            for (JTSPolygon patche : this.patches) {
                sb.append("patche:").append(patche).append('\n');
            }
        }
        return sb.toString();
    }
}

