/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.awt;

import org.geotoolkit.geometry.jts.awt.JTSGeometryIterator;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.MathTransform;

public final class JTSPolygonIterator
extends JTSGeometryIterator<Polygon> {
    private LineString[] rings;
    private int currentRing = 0;
    private int currentCoord = 0;
    private CoordinateSequence coords = null;
    private int csSize = 0;
    private boolean done = false;

    public JTSPolygonIterator(Polygon p, MathTransform trs) {
        super(p, trs);
        this.setGeometry(p);
    }

    @Override
    public void setGeometry(Polygon geom) {
        this.geometry = geom;
        if (geom != null) {
            int numInteriorRings = geom.getNumInteriorRing();
            this.rings = new LineString[numInteriorRings + 1];
            this.rings[0] = geom.getExteriorRing();
            for (int i = 0; i < numInteriorRings; ++i) {
                this.rings[i + 1] = geom.getInteriorRingN(i);
            }
        }
        this.reset();
    }

    @Override
    public void reset() {
        this.currentRing = 0;
        this.currentCoord = 0;
        this.coords = this.rings[0].getCoordinateSequence();
        this.csSize = this.coords.size() - 1;
        this.done = false;
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.currentCoord == this.csSize) {
            return 4;
        }
        if (this.currentCoord == 0) {
            coords[0] = this.coords.getX(0);
            coords[1] = this.coords.getY(0);
            this.safeTransform(coords, 0, coords, 0, 1);
            return 0;
        }
        coords[0] = this.coords.getX(this.currentCoord);
        coords[1] = this.coords.getY(this.currentCoord);
        this.safeTransform(coords, 0, coords, 0, 1);
        return 1;
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.currentCoord == this.csSize) {
            return 4;
        }
        if (this.currentCoord == 0) {
            coords[0] = (float)this.coords.getX(0);
            coords[1] = (float)this.coords.getY(0);
            this.safeTransform(coords, 0, coords, 0, 1);
            return 0;
        }
        coords[0] = (float)this.coords.getX(this.currentCoord);
        coords[1] = (float)this.coords.getY(this.currentCoord);
        this.safeTransform(coords, 0, coords, 0, 1);
        return 1;
    }

    @Override
    public int getWindingRule() {
        return 0;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        if (this.currentCoord == this.csSize) {
            if (this.currentRing < this.rings.length - 1) {
                this.currentCoord = 0;
                ++this.currentRing;
                this.coords = this.rings[this.currentRing].getCoordinateSequence();
                this.csSize = this.coords.size() - 1;
            } else {
                this.done = true;
            }
        } else {
            ++this.currentCoord;
        }
    }
}

