/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts.distance;

import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.IntStream;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.geometry.jts.distance.LoxodromicEngine;
import org.geotoolkit.geometry.jts.distance.OrthodromicEngine;
import org.geotoolkit.util.exceptions.IllegalCrsException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.util.FactoryException;

public class DistanceSpliterator
implements Spliterator.OfDouble {
    private final CoordinateSequence sequence;
    private final CoordinateReferenceSystem crs;
    private final Spliterator.OfInt idxSpliterator;
    private final Supplier<ToDoubleBiFunction<Coordinate, Coordinate>> engineProvider;
    private final ToDoubleBiFunction<Coordinate, Coordinate> distanceEngine;
    private final IntConsumer pointConsumer;
    private double resultBuffer = 0.0;

    private DistanceSpliterator(CoordinateSequence polyline, CoordinateReferenceSystem polylineCrs, Spliterator.OfInt coordinateIndexSpliterator, Supplier<ToDoubleBiFunction<Coordinate, Coordinate>> distanceCalculatorSupplier) {
        this.sequence = polyline;
        this.crs = polylineCrs;
        this.idxSpliterator = coordinateIndexSpliterator;
        this.distanceEngine = distanceCalculatorSupplier.get();
        this.engineProvider = distanceCalculatorSupplier;
        this.pointConsumer = idx -> {
            this.resultBuffer = this.distanceEngine.applyAsDouble(this.sequence.getCoordinate(idx - 1), this.sequence.getCoordinate(idx));
        };
    }

    @Override
    public Spliterator.OfDouble trySplit() {
        Spliterator.OfInt idxSplitted = this.idxSpliterator.trySplit();
        if (idxSplitted != null) {
            return new DistanceSpliterator(this.sequence, this.crs, idxSplitted, this.engineProvider);
        }
        return null;
    }

    @Override
    public boolean tryAdvance(DoubleConsumer action) {
        if (this.idxSpliterator.tryAdvance(this.pointConsumer)) {
            action.accept(this.resultBuffer);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.idxSpliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.idxSpliterator.characteristics() - 1 - 4;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CoordinateSequence polyline;
        private CoordinateReferenceSystem crs;
        private int fromInclusive;
        private int toExclusive = -1;

        public Builder setpolyline(LineString polyline) throws FactoryException {
            ArgumentChecks.ensureNonNull("Polyline to use for distance computing", polyline);
            CoordinateReferenceSystem crs = JTS.findCoordinateReferenceSystem(polyline);
            if (crs != null) {
                this.crs = crs;
            }
            this.polyline = polyline.getCoordinateSequence();
            return this;
        }

        public Builder setPolyline(CoordinateSequence polyline) {
            this.polyline = polyline;
            return this;
        }

        public Builder setCrs(CoordinateReferenceSystem crs) {
            this.crs = crs;
            return this;
        }

        public Builder setRange(int startInclusive, int endExclusive) {
            this.fromInclusive = startInclusive;
            this.toExclusive = endExclusive;
            return this;
        }

        public Spliterator.OfDouble buildOrthodromic() {
            return this.buildCustom(() -> new OrthodromicEngine(this.crs));
        }

        public Spliterator.OfDouble buildLoxodromic() {
            return this.buildCustom(() -> new LoxodromicEngine(this.crs));
        }

        public Spliterator.OfDouble buildCustom(Supplier<ToDoubleBiFunction<Coordinate, Coordinate>> segmentLengthComputerProvider) {
            ArgumentChecks.ensureNonNull("Supplier of segment length computing engine", segmentLengthComputerProvider);
            this.checkValues();
            return new DistanceSpliterator(this.polyline, this.crs, IntStream.range(this.fromInclusive + 1, this.toExclusive + 1).spliterator(), segmentLengthComputerProvider);
        }

        private void checkValues() {
            if (this.polyline == null) {
                throw new IllegalStateException("No polyline provided for the distance measure.");
            }
            int ptNumber = this.polyline.size();
            if (ptNumber < 1) {
                throw new IllegalStateException("An empty polyline has been given for distance measure.");
            }
            if (ptNumber < 2) {
                throw new IllegalStateException("The polyline to measure contains only one point. There no segment to compute length for.");
            }
            if (this.crs == null) {
                throw new IllegalStateException("No coordinate reference system given for the polyline. We need one to be able to represent the polyline on an earth ellipsoid");
            }
            int crsDimension = this.crs.getCoordinateSystem().getDimension();
            if (crsDimension < 2) {
                throw new IllegalCrsException(this.crs, String.format("Given coordinate reference system has not enough dimension.%nExpected: 2, but found: %d%nGiven coordinate reference system: %s", crsDimension, this.crs.getName().getCode()));
            }
            if (crsDimension > 2) {
                SingleCRS horizontalCpt = CRS.getHorizontalComponent(this.crs);
                if (horizontalCpt == null) {
                    throw new IllegalCrsException(this.crs, String.format("No horizontal component can be found in given coordinate reference system [%s]. Impossible to project the polyline on an ellispoid", this.crs.getName().getCode()));
                }
                this.crs = horizontalCpt;
            }
            if (this.fromInclusive < 0) {
                this.fromInclusive = 0;
            } else if (this.fromInclusive < 0 || this.fromInclusive > ptNumber - 2) {
                throw new IllegalStateException(String.format("Invalid start position (from parameter). Given value: %d, authorized interval: [%d..%d]", this.fromInclusive, 0, ptNumber - 2));
            }
            if (this.toExclusive < 0) {
                this.toExclusive = ptNumber - 1;
            } else if (this.toExclusive < 1 || this.toExclusive >= ptNumber) {
                throw new IllegalStateException(String.format("Invalid end position (to parameter). Given value: %d, authorized interval: [%d..%d]", this.toExclusive, 1, ptNumber));
            }
        }
    }
}

