/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import org.geotoolkit.geometry.math.Tuple;

public class Tuple2i
implements Tuple {
    public int x;
    public int y;

    public Tuple2i() {
    }

    public Tuple2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double get(int indice) {
        switch (indice) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index " + indice);
    }

    @Override
    public void set(int indice, double value) {
        switch (indice) {
            case 0: {
                this.x = (int)value;
                break;
            }
            case 1: {
                this.y = (int)value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index " + indice);
            }
        }
    }

    @Override
    public void set(double[] values) {
        if (this.getDimension() != values.length) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + values.length);
        }
        this.x = (int)values[0];
        this.y = (int)values[1];
    }

    @Override
    public int[] toArrayInt() {
        return new int[]{this.x, this.y};
    }

    @Override
    public float[] toArrayFloat() {
        return new float[]{this.x, this.y};
    }

    @Override
    public double[] toArrayDouble() {
        return new double[]{this.x, this.y};
    }

    @Override
    public void toArrayInt(int[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
    }

    @Override
    public void toArrayFloat(float[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
    }

    @Override
    public void toArrayDouble(double[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.toArrayDouble());
    }
}

