/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.math;

import java.util.Arrays;
import org.geotoolkit.geometry.math.Tuple;
import org.geotoolkit.geometry.math.Vector;

public class Vector3d
implements Vector {
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d(double[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public double get(int indice) {
        switch (indice) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index " + indice);
    }

    @Override
    public void set(int indice, double value) {
        switch (indice) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index " + indice);
            }
        }
    }

    @Override
    public void set(double[] values) {
        if (this.getDimension() != values.length) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + values.length);
        }
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @Override
    public double lengthSquare() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    @Override
    public void normalize() {
        double s2 = 1.0 / this.length();
        this.x *= s2;
        this.y *= s2;
        this.z *= s2;
    }

    @Override
    public void add(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x += other.get(0);
        this.y += other.get(1);
        this.z += other.get(2);
    }

    @Override
    public void subtract(Tuple other) {
        if (this.getDimension() != other.getDimension()) {
            throw new IllegalArgumentException("Vectors size are different : " + this.getDimension() + " and " + other.getDimension());
        }
        this.x -= other.get(0);
        this.y -= other.get(1);
        this.z -= other.get(2);
    }

    @Override
    public void scale(double scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    @Override
    public int[] toArrayInt() {
        return new int[]{(int)this.x, (int)this.y, (int)this.z};
    }

    @Override
    public float[] toArrayFloat() {
        return new float[]{(float)this.x, (float)this.y, (float)this.z};
    }

    @Override
    public double[] toArrayDouble() {
        return new double[]{this.x, this.y, this.z};
    }

    @Override
    public void toArrayInt(int[] buffer, int offset) {
        buffer[offset] = (int)this.x;
        buffer[offset + 1] = (int)this.y;
        buffer[offset + 2] = (int)this.z;
    }

    @Override
    public void toArrayFloat(float[] buffer, int offset) {
        buffer[offset] = (float)this.x;
        buffer[offset + 1] = (float)this.y;
        buffer[offset + 2] = (float)this.z;
    }

    @Override
    public void toArrayDouble(double[] buffer, int offset) {
        buffer[offset] = this.x;
        buffer[offset + 1] = this.y;
        buffer[offset + 2] = this.z;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.toArrayDouble());
    }
}

