/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.iso.citation.DefaultCitation;

public class GMLStandard
extends MetadataStandard {
    private static final String PREFIX = "Abstract";
    private final String implSubPackage;

    public GMLStandard(String name, Package pck, String implSubPackage, MetadataStandard ... dependencies) {
        super(new DefaultCitation(name), pck, dependencies);
        this.implSubPackage = implSubPackage;
    }

    @Override
    public <T> Class<? extends T> getImplementation(Class<T> type) {
        Class<?> impl;
        if (!type.isInterface()) {
            return null;
        }
        String interfaceName = type.getName();
        int s2 = interfaceName.lastIndexOf(46) + 1;
        StringBuilder implName = new StringBuilder(interfaceName);
        if (interfaceName.regionMatches(s2, PREFIX, 0, PREFIX.length())) {
            implName.delete(s2, s2 + PREFIX.length());
        }
        implName.insert(s2, this.implSubPackage + ".");
        try {
            impl = Class.forName(implName.toString());
        }
        catch (ClassNotFoundException e) {
            int end = implName.length();
            implName.append("Type");
            try {
                impl = Class.forName(implName.toString());
            }
            catch (ClassNotFoundException e2) {
                implName.setLength(end);
                implName.append("PropertyType");
                try {
                    impl = Class.forName(implName.toString());
                }
                catch (ClassNotFoundException e3) {
                    return null;
                }
            }
        }
        return impl.asSubclass(type);
    }
}

