/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml;

import java.util.ArrayList;
import java.util.List;
import org.geotoolkit.geometry.GeometricUtilities;
import org.geotoolkit.gml.xml.v311.AbstractCurveType;
import org.geotoolkit.gml.xml.v311.AbstractGeometryType;
import org.geotoolkit.gml.xml.v311.CurveInterpolationType;
import org.geotoolkit.gml.xml.v311.CurvePropertyType;
import org.geotoolkit.gml.xml.v311.CurveType;
import org.geotoolkit.gml.xml.v311.GeometryPropertyType;
import org.geotoolkit.gml.xml.v311.LineStringSegmentType;
import org.geotoolkit.gml.xml.v311.LineStringType;
import org.geotoolkit.gml.xml.v311.MultiCurveType;
import org.geotoolkit.gml.xml.v311.MultiGeometryType;
import org.geotoolkit.gml.xml.v311.MultiPointType;
import org.geotoolkit.gml.xml.v311.MultiPolygonType;
import org.geotoolkit.gml.xml.v311.PointPropertyType;
import org.geotoolkit.gml.xml.v311.PointType;
import org.geotoolkit.gml.xml.v311.PolygonPatchArrayPropertyType;
import org.geotoolkit.gml.xml.v311.PolygonPatchType;
import org.geotoolkit.gml.xml.v311.PolygonPropertyType;
import org.geotoolkit.gml.xml.v311.PolygonType;
import org.geotoolkit.gml.xml.v311.PolyhedralSurfaceType;
import org.geotoolkit.gml.xml.v311.RingType;
import org.geotoolkit.gml.xml.v311.SurfaceInterpolationType;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.aggregate.MultiCurve;
import org.opengis.geometry.aggregate.MultiPoint;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.aggregate.MultiSurface;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.SurfaceBoundary;

public class GMLUtilities {
    private static final GeometryFactory GF = GeometricUtilities.getFactory();

    /*
     * WARNING - void declaration
     */
    public static AbstractGeometryType getGMLFromISO(Geometry geometry) {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            PointType gmlPoint = new PointType(null, point.getDirectPosition());
            return gmlPoint;
        }
        if (geometry instanceof OrientableSurface) {
            OrientableSurface surface = (OrientableSurface)geometry;
            SurfaceBoundary boundary = surface.getBoundary();
            Ring exterior = boundary.getExterior();
            ArrayList<CurvePropertyType> arrayList = new ArrayList<CurvePropertyType>();
            for (Primitive primitive : exterior.getElements()) {
                arrayList.add(new CurvePropertyType((CurveType)GMLUtilities.getGMLFromISO(primitive)));
            }
            RingType ringType = new RingType();
            ringType.getCurveMember().addAll(arrayList);
            List<Ring> list = boundary.getInteriors();
            ArrayList<RingType> gmlInteriors = new ArrayList<RingType>();
            for (Ring interior : list) {
                ArrayList<CurvePropertyType> intcurves = new ArrayList<CurvePropertyType>();
                for (Primitive primitive : interior.getElements()) {
                    intcurves.add(new CurvePropertyType((CurveType)GMLUtilities.getGMLFromISO(primitive)));
                }
                RingType ringType2 = new RingType();
                ringType2.getCurveMember().addAll(intcurves);
                gmlInteriors.add(ringType2);
            }
            PolygonType poly = new PolygonType(ringType, gmlInteriors);
            return poly;
        }
        if (geometry instanceof MultiSurface) {
            MultiSurface multiPrim = (MultiSurface)geometry;
            ArrayList<PolygonPropertyType> geometries = new ArrayList<PolygonPropertyType>();
            for (Geometry geometry2 : multiPrim.getElements()) {
                PolygonType polygonType = (PolygonType)GMLUtilities.getGMLFromISO(geometry2);
                PolygonPropertyType polygonPropertyType = new PolygonPropertyType(polygonType);
                geometries.add(polygonPropertyType);
            }
            MultiPolygonType gmlMulti = new MultiPolygonType(null, geometries);
            return gmlMulti;
        }
        if (geometry instanceof MultiCurve) {
            MultiCurve multiPrim = (MultiCurve)geometry;
            ArrayList<CurvePropertyType> geometries = new ArrayList<CurvePropertyType>();
            for (OrientableCurve orientableCurve : multiPrim.getElements()) {
                AbstractCurveType abstractCurveType = (AbstractCurveType)GMLUtilities.getGMLFromISO(orientableCurve);
                CurvePropertyType curvePropertyType = new CurvePropertyType(abstractCurveType);
                geometries.add(curvePropertyType);
            }
            MultiCurveType gmlMulti = new MultiCurveType(geometries);
            return gmlMulti;
        }
        if (geometry instanceof MultiPoint) {
            MultiPoint multiPrim = (MultiPoint)geometry;
            ArrayList<PointPropertyType> geometries = new ArrayList<PointPropertyType>();
            for (Point point : multiPrim.getElements()) {
                PointType pointType = (PointType)GMLUtilities.getGMLFromISO(point);
                PointPropertyType pointPropertyType = new PointPropertyType(pointType);
                geometries.add(pointPropertyType);
            }
            MultiPointType gmlMulti = new MultiPointType(null, geometries);
            return gmlMulti;
        }
        if (geometry instanceof MultiPrimitive) {
            MultiPrimitive multiPrim = (MultiPrimitive)geometry;
            ArrayList<GeometryPropertyType> geometries = new ArrayList<GeometryPropertyType>();
            for (Primitive primitive : multiPrim.getElements()) {
                AbstractGeometryType abstractGeometryType = GMLUtilities.getGMLFromISO(primitive);
                GeometryPropertyType geometryPropertyType = new GeometryPropertyType(abstractGeometryType);
                geometries.add(geometryPropertyType);
            }
            MultiGeometryType gmlMulti = new MultiGeometryType(geometries);
            return gmlMulti;
        }
        if (geometry instanceof Curve) {
            Curve curve = (Curve)geometry;
            List<? extends CurveSegment> segments = curve.getSegments();
            ArrayList<LineStringSegmentType> gmlSegments = new ArrayList<LineStringSegmentType>();
            for (CurveSegment curveSegment : segments) {
                CurveInterpolationType curveInterpolationType = CurveInterpolationType.fromValue(curveSegment.getInterpolation().identifier());
                PointArray array = GeometricUtilities.getSamplePoints(curveSegment);
                ArrayList<DirectPosition> positions = new ArrayList<DirectPosition>();
                for (int i = 0; i < array.size(); ++i) {
                    positions.add(array.getDirectPosition(i, null));
                }
                LineStringSegmentType gmlSegment = new LineStringSegmentType(curveSegment.getNumDerivativesAtStart(), curveSegment.getNumDerivativesAtEnd(), curveSegment.getNumDerivativesInterior(), curveInterpolationType, positions);
                gmlSegments.add(gmlSegment);
            }
            CurveType curveType = new CurveType(gmlSegments);
            return curveType;
        }
        if (geometry instanceof LineString) {
            void var4_38;
            LineString line = (LineString)((Object)geometry);
            PointArray array = GeometricUtilities.getSamplePoints(line);
            ArrayList<DirectPosition> positions = new ArrayList<DirectPosition>();
            boolean bl = false;
            while (var4_38 < array.size()) {
                positions.add(array.getDirectPosition((int)var4_38, null));
                ++var4_38;
            }
            LineStringType lineStringType = new LineStringType(positions);
            return lineStringType;
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)((Object)geometry);
            SurfaceBoundary boundary = polygon.getBoundary();
            Ring exterior = boundary.getExterior();
            ArrayList<CurvePropertyType> arrayList = new ArrayList<CurvePropertyType>();
            for (Primitive primitive : exterior.getElements()) {
                arrayList.add(new CurvePropertyType((CurveType)GMLUtilities.getGMLFromISO(primitive)));
            }
            RingType ringType = new RingType();
            ringType.getCurveMember().addAll(arrayList);
            List<Ring> list = boundary.getInteriors();
            ArrayList<RingType> gmlInteriors = new ArrayList<RingType>();
            for (Ring interior : list) {
                ArrayList<CurvePropertyType> intcurves = new ArrayList<CurvePropertyType>();
                for (Primitive primitive : interior.getElements()) {
                    intcurves.add(new CurvePropertyType((CurveType)GMLUtilities.getGMLFromISO(primitive)));
                }
                RingType ringType3 = new RingType();
                ringType3.getCurveMember().addAll(intcurves);
                gmlInteriors.add(ringType3);
            }
            PolygonType gmlPolygon = new PolygonType(ringType, gmlInteriors);
            return gmlPolygon;
        }
        if (geometry instanceof PolyhedralSurface) {
            PolyhedralSurface polySurface = (PolyhedralSurface)geometry;
            ArrayList<PolygonPatchType> gmlPatches = new ArrayList<PolygonPatchType>();
            List<? extends Polygon> patches = polySurface.getPatches();
            for (Polygon polygon : patches) {
                SurfaceInterpolationType surfaceInterpolationType = SurfaceInterpolationType.fromValue(polygon.getInterpolation().identifier());
                SurfaceBoundary boundary = polygon.getBoundary();
                Ring exterior = boundary.getExterior();
                ArrayList<CurvePropertyType> curves = new ArrayList<CurvePropertyType>();
                for (Primitive primitive : exterior.getElements()) {
                    curves.add(new CurvePropertyType((CurveType)GMLUtilities.getGMLFromISO(primitive)));
                }
                RingType gmlExterior = new RingType();
                gmlExterior.getCurveMember().addAll(curves);
                List<Ring> list = boundary.getInteriors();
                ArrayList<RingType> arrayList = new ArrayList<RingType>();
                for (Ring interior : list) {
                    ArrayList<CurvePropertyType> intcurves = new ArrayList<CurvePropertyType>();
                    for (Primitive primitive : interior.getElements()) {
                        intcurves.add(new CurvePropertyType((CurveType)GMLUtilities.getGMLFromISO(primitive)));
                    }
                    RingType gmlinterior = new RingType();
                    gmlinterior.getCurveMember().addAll(intcurves);
                    arrayList.add(gmlinterior);
                }
                PolygonPatchType patche = new PolygonPatchType(surfaceInterpolationType, gmlExterior, arrayList);
                gmlPatches.add(patche);
            }
            PolygonPatchArrayPropertyType polygonPatchArrayPropertyType = new PolygonPatchArrayPropertyType(gmlPatches);
            PolyhedralSurfaceType polyhedralSurfaceType = new PolyhedralSurfaceType(polygonPatchArrayPropertyType);
            return polyhedralSurfaceType;
        }
        System.out.println("unexpected iso geometry type:" + geometry.getClass().getName());
        return null;
    }
}

