/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.gml.xml.AbstractFeature;
import org.geotoolkit.gml.xml.v311.AbstractFeatureCollectionType;
import org.geotoolkit.gml.xml.v311.AbstractGMLType;
import org.geotoolkit.gml.xml.v311.BoundedFeatureType;
import org.geotoolkit.gml.xml.v311.BoundingShapeType;
import org.geotoolkit.gml.xml.v311.EnvelopeType;
import org.geotoolkit.gml.xml.v311.LocationPropertyType;
import org.geotoolkit.gml.xml.v311.ReferenceType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractFeatureType", propOrder={"srsName", "boundedBy", "location"})
@XmlSeeAlso(value={AbstractFeatureCollectionType.class, BoundedFeatureType.class})
public abstract class AbstractFeatureType
extends AbstractGMLType
implements AbstractFeature {
    private List<String> srsName;
    @XmlElement
    private BoundingShapeType boundedBy;
    @XmlElement
    private LocationPropertyType location;

    public AbstractFeatureType() {
    }

    public AbstractFeatureType(AbstractFeature af) {
        super(af);
        if (af != null) {
            if (af.getSrsName() != null) {
                this.srsName = new ArrayList<String>(af.getSrsName());
            }
            if (af.getBoundedBy() != null) {
                this.boundedBy = new BoundingShapeType(af.getBoundedBy());
            }
            if (af.getLocation() != null) {
                if (af.getLocation() instanceof LocationPropertyType) {
                    this.location = (LocationPropertyType)af.getLocation();
                } else {
                    throw new IllegalArgumentException("LocationProperty clone not implemented yet");
                }
            }
        }
    }

    public AbstractFeatureType(String id, String name, String description) {
        super(id, name, description, null);
        this.boundedBy = new BoundingShapeType("not_bounded");
    }

    public AbstractFeatureType(String id, String name, String description, ReferenceType descriptionReference, BoundingShapeType boundedBy, List<String> srsName) {
        super(id, name, description, descriptionReference);
        this.srsName = srsName;
        this.boundedBy = boundedBy == null ? new BoundingShapeType("not_bounded") : boundedBy;
    }

    @Override
    public BoundingShapeType getBoundedBy() {
        return this.boundedBy;
    }

    public void setBoundedBy(BoundingShapeType boundingShape) {
        this.boundedBy = boundingShape;
    }

    public void setBoundedBy(EnvelopeType envelope) {
        this.boundedBy = new BoundingShapeType(envelope);
    }

    @Override
    public LocationPropertyType getLocation() {
        return this.location;
    }

    @Override
    public List<String> getSrsName() {
        if (this.srsName == null) {
            this.srsName = new ArrayList<String>();
        }
        return this.srsName;
    }

    public void setSrsName(List<String> srsName) {
        this.srsName = srsName;
    }

    public void getSrsName(String name) {
        if (this.srsName == null) {
            this.srsName = new ArrayList<String>();
        }
        this.srsName.add(name);
    }

    public void updateBoundingShape(double x, double y) {
        if (this.boundedBy != null && this.boundedBy.getEnvelope() != null) {
            EnvelopeType envelope = this.boundedBy.getEnvelope();
            if (envelope.getLowerCorner() != null) {
                Double miny;
                Double minx = envelope.getLowerCorner().getValue().get(1);
                if (x < minx) {
                    minx = x;
                }
                if (y < (miny = envelope.getLowerCorner().getValue().get(0))) {
                    miny = y;
                }
                envelope.getLowerCorner().setValue(Arrays.asList(miny, minx));
            }
            if (envelope.getUpperCorner() != null) {
                Double maxy;
                Double maxx = envelope.getUpperCorner().getValue().get(1);
                if (x > maxx) {
                    maxx = x;
                }
                if (y > (maxy = envelope.getUpperCorner().getValue().get(0))) {
                    maxy = y;
                }
                envelope.getUpperCorner().setValue(Arrays.asList(maxy, maxx));
            }
        }
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractFeatureType && super.equals(object, mode)) {
            AbstractFeatureType that = (AbstractFeatureType)object;
            return Objects.equals(this.boundedBy, that.boundedBy) && Objects.equals(this.location, that.location) && Objects.equals(this.srsName, that.srsName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.boundedBy != null ? this.boundedBy.hashCode() : 0);
        hash = 23 * hash + (this.location != null ? this.location.hashCode() : 0);
        hash = 23 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder(super.toString());
        if (this.boundedBy != null) {
            s2.append("boundedBy:").append(this.boundedBy);
        }
        if (this.location != null) {
            s2.append("location:").append(this.location);
        }
        if (this.location != null) {
            s2.append("srsName:").append(this.srsName);
        }
        return s2.toString();
    }
}

