/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.internal.jaxb.ModifiableIdentifierMap;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.Utilities;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.geotoolkit.gml.GMLStandard;
import org.geotoolkit.gml.xml.AbstractGML;
import org.geotoolkit.gml.xml.v311.CodeType;
import org.geotoolkit.gml.xml.v321.AbstractFeatureType;
import org.geotoolkit.gml.xml.v321.AbstractGeometryType;
import org.geotoolkit.gml.xml.v321.AbstractTimeObjectType;
import org.geotoolkit.gml.xml.v321.AbstractTimeSliceType;
import org.geotoolkit.gml.xml.v321.AbstractTopologyType;
import org.geotoolkit.gml.xml.v321.ArrayType;
import org.geotoolkit.gml.xml.v321.BagType;
import org.geotoolkit.gml.xml.v321.CodeWithAuthorityType;
import org.geotoolkit.gml.xml.v321.CompositeValueType;
import org.geotoolkit.gml.xml.v321.DefinitionBaseType;
import org.geotoolkit.gml.xml.v321.MetaDataPropertyType;
import org.geotoolkit.gml.xml.v321.ReferenceType;
import org.geotoolkit.gml.xml.v321.StringOrRefType;
import org.geotoolkit.internal.sql.Entry;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractGMLType", propOrder={"metaDataProperty", "description", "descriptionReference", "identifier", "name"})
@XmlSeeAlso(value={BagType.class, ArrayType.class, AbstractTimeSliceType.class, AbstractTimeObjectType.class, CompositeValueType.class, AbstractGeometryType.class, AbstractTopologyType.class, AbstractFeatureType.class, DefinitionBaseType.class})
public abstract class AbstractGMLType
extends AbstractMetadata
implements AbstractGML,
Serializable,
Entry,
IdentifiedObject {
    protected static final Logger LOGGER = Logger.getLogger("org.geotoolkit.gml.xml.v321");
    private static final GMLStandard STANDARD = new GMLStandard("GML 3.2.1", AbstractGML.class.getPackage(), "v321", MetadataStandard.ISO_19111);
    private List<MetaDataPropertyType> metaDataProperty;
    private StringOrRefType description;
    private ReferenceType descriptionReference;
    private CodeWithAuthorityType identifier;
    private List<Identifier> name;
    @XmlAttribute(namespace="http://www.opengis.net/gml/3.2", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    private String id;
    @XmlTransient
    protected Set<Identifier> identifiers;

    protected AbstractGMLType() {
    }

    public AbstractGMLType(String id) {
        this.setId(id);
    }

    public AbstractGMLType(AbstractGML that) {
        if (that != null) {
            if (that.getDescription() != null) {
                this.description = new StringOrRefType(that.getDescription());
            }
            if (that.getDescriptionReference() != null) {
                this.descriptionReference = new ReferenceType(that.getDescriptionReference());
            }
            this.setId(that.getId());
            if (that.getName() != null) {
                this.name = new ArrayList<Identifier>();
                this.name.add(that.getName());
            }
            if (that instanceof AbstractGMLType) {
                AbstractGMLType thatGML = (AbstractGMLType)that;
                if (thatGML.identifier != null) {
                    this.identifier = new CodeWithAuthorityType(thatGML.identifier);
                }
                if (thatGML.metaDataProperty != null) {
                    this.metaDataProperty = new ArrayList<MetaDataPropertyType>();
                    for (MetaDataPropertyType m4 : thatGML.metaDataProperty) {
                        this.metaDataProperty.add(new MetaDataPropertyType(m4));
                    }
                }
            }
        }
    }

    public AbstractGMLType(String id, String name, String description, ReferenceType descriptionReference) {
        this.setId(id);
        if (name != null) {
            this.name = new ArrayList<Identifier>();
            this.name.add(new DefaultIdentifier(name));
        }
        if (description != null) {
            this.description = new StringOrRefType(description);
        }
        this.descriptionReference = descriptionReference;
    }

    @Override
    public MetadataStandard getStandard() {
        return STANDARD;
    }

    public List<MetaDataPropertyType> getMetaDataProperty() {
        if (this.metaDataProperty == null) {
            this.metaDataProperty = new ArrayList<MetaDataPropertyType>();
        }
        return this.metaDataProperty;
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description.getValue();
        }
        return null;
    }

    public void setDescription(StringOrRefType value) {
        this.description = value;
    }

    @Override
    public void setDescription(String value) {
        this.description = new StringOrRefType(value);
    }

    @Override
    public ReferenceType getDescriptionReference() {
        return this.descriptionReference;
    }

    public void setDescriptionReference(ReferenceType value) {
        this.descriptionReference = value;
    }

    public String getIdentifier() {
        if (this.id == null) {
            this.id = (String)this.getIdentifierMap().get(IdentifierSpace.ID);
        }
        return this.id;
    }

    public CodeWithAuthorityType getFullIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(CodeWithAuthorityType value) {
        this.identifier = value;
    }

    public List<Identifier> getNames() {
        if (this.name == null) {
            this.name = new ArrayList<Identifier>();
        }
        return this.name;
    }

    @Override
    public Identifier getName() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name.get(0);
        }
        return null;
    }

    @Override
    public void setName(Identifier name) {
        if (this.name == null) {
            this.name = new ArrayList<Identifier>();
        }
        this.name.clear();
        if (name != null) {
            this.name.add(0, name);
        }
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = (String)this.getIdentifierMap().get(IdentifierSpace.ID);
        }
        return this.id;
    }

    @Override
    public void setId(String value) {
        if (value != null) {
            this.getIdentifierMap().put(IdentifierSpace.ID, value);
        }
        this.id = value;
    }

    @Override
    public CodeType getParameterName() {
        return null;
    }

    @Override
    public boolean equals(Object obj, ComparisonMode mode) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractGMLType) {
            AbstractGMLType that = (AbstractGMLType)obj;
            return Objects.equals(this.description, that.description) && Objects.equals(this.descriptionReference, that.descriptionReference) && Objects.equals(this.id, that.id) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.metaDataProperty, that.metaDataProperty) && Utilities.deepEquals(this.getName(), that.getName(), ComparisonMode.BY_CONTRACT);
        }
        return false;
    }

    public Set<Identifier> getIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = new HashSet<Identifier>();
        }
        return this.identifiers;
    }

    @Override
    public IdentifierMap getIdentifierMap() {
        if (this.identifiers == null) {
            this.identifiers = new HashSet<Identifier>();
        }
        return new ModifiableIdentifierMap(this.identifiers);
    }

    public Collection<GenericName> getAlias() {
        return null;
    }

    public InternationalString getRemarks() {
        if (this.description != null && this.description.getValue() != null) {
            return new SimpleInternationalString(this.description.getValue());
        }
        return null;
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void prune() {
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 67 * hash + (this.descriptionReference != null ? this.descriptionReference.hashCode() : 0);
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 67 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 67 * hash + (this.identifier != null ? this.identifier.hashCode() : 0);
        hash = 67 * hash + (this.metaDataProperty != null ? this.metaDataProperty.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.getClass().getSimpleName()).append(']').append('\n');
        if (this.id != null) {
            sb.append("id:").append(this.id).append('\n');
        }
        if (this.name != null) {
            sb.append("name:").append(this.name).append('\n');
        }
        if (this.description != null) {
            sb.append("description:").append(this.description).append('\n');
        }
        if (this.descriptionReference != null) {
            sb.append("description reference:").append(this.descriptionReference).append('\n');
        }
        if (this.identifier != null) {
            sb.append("identifier:").append(this.identifier).append('\n');
        }
        if (this.metaDataProperty != null) {
            sb.append("metaDataProperty:\n");
            for (MetaDataPropertyType process : this.metaDataProperty) {
                sb.append(process).append('\n');
            }
        }
        return sb.toString();
    }
}

