/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.xml.datatype.Duration;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.gml.xml.AbstractTimePosition;
import org.geotoolkit.gml.xml.GMLPeriod;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.gml.xml.v321.AbstractTimeGeometricPrimitiveType;
import org.geotoolkit.gml.xml.v321.AbstractTimeObjectType;
import org.geotoolkit.gml.xml.v321.TimeInstantPropertyType;
import org.geotoolkit.gml.xml.v321.TimeInstantType;
import org.geotoolkit.gml.xml.v321.TimeIntervalLengthType;
import org.geotoolkit.gml.xml.v321.TimePositionType;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TimePeriodType", propOrder={"beginPosition", "begin", "endPosition", "end", "duration", "timeInterval"})
@XmlRootElement(name="TimePeriod")
public class TimePeriodType
extends AbstractTimeGeometricPrimitiveType
implements GMLPeriod,
Serializable {
    private TimePositionType beginPosition;
    private TimeInstantPropertyType begin;
    private TimePositionType endPosition;
    private TimeInstantPropertyType end;
    private Duration duration;
    private TimeIntervalLengthType timeInterval;

    TimePeriodType() {
    }

    public TimePeriodType(Instant beginPosition, Instant endPosition) {
        this(null, beginPosition, endPosition);
    }

    public TimePeriodType(String id, Period period) {
        super(id);
        if (period != null) {
            if (period.getBeginning() != null) {
                this.beginPosition = new TimePositionType(period.getBeginning().getDate());
            }
            if (period.getEnding() != null) {
                this.endPosition = new TimePositionType(period.getEnding().getDate());
            }
        }
    }

    public TimePeriodType(String id, Instant beginPosition, Instant endPosition) {
        super(id);
        if (beginPosition != null && beginPosition.getDate() != null) {
            this.beginPosition = new TimePositionType(beginPosition.getDate());
        }
        if (endPosition != null && endPosition.getDate() != null) {
            this.endPosition = new TimePositionType(endPosition.getDate());
        }
    }

    public TimePeriodType(AbstractTimePosition beginPosition, AbstractTimePosition endPosition) {
        if (beginPosition instanceof TimePositionType) {
            this.beginPosition = (TimePositionType)beginPosition;
        } else if (beginPosition != null) {
            this.beginPosition = new TimePositionType(beginPosition.getDate());
        }
        if (endPosition instanceof TimePositionType) {
            this.endPosition = (TimePositionType)endPosition;
        } else if (endPosition != null) {
            this.endPosition = new TimePositionType(endPosition.getDate());
        }
    }

    public TimePeriodType(String id, String beginValue, String endValue) {
        super(id);
        this.beginPosition = new TimePositionType(beginValue);
        this.endPosition = new TimePositionType(endValue);
    }

    public TimePeriodType(String id, Date beginValue, Date endValue) {
        super(id);
        this.beginPosition = new TimePositionType(beginValue);
        this.endPosition = new TimePositionType(endValue);
    }

    public TimePeriodType(TimePositionType beginPosition) {
        this.beginPosition = beginPosition;
        this.endPosition = new TimePositionType(TimeIndeterminateValueType.NOW);
    }

    public TimePeriodType(String id, Date beginPosition) {
        super(id);
        this.beginPosition = new TimePositionType(beginPosition);
        this.endPosition = new TimePositionType(TimeIndeterminateValueType.NOW);
    }

    public TimePeriodType(String id, String beginValue) {
        super(id);
        this.beginPosition = new TimePositionType(beginValue);
        this.endPosition = new TimePositionType(TimeIndeterminateValueType.NOW);
    }

    public TimePeriodType(TimeIndeterminateValueType indeterminateBegin, TimePositionType endPosition) {
        this.beginPosition = new TimePositionType(indeterminateBegin);
        this.endPosition = endPosition;
    }

    public TimePeriodType(TimeIndeterminateValueType indeterminateBegin, Date endPosition) {
        this.beginPosition = new TimePositionType(indeterminateBegin);
        this.endPosition = new TimePositionType(endPosition);
    }

    public TimePeriodType(AbstractTimePosition beginPosition, TimeIndeterminateValueType indeterminateEnd) {
        this.endPosition = new TimePositionType(indeterminateEnd);
        if (beginPosition instanceof TimePositionType) {
            this.beginPosition = (TimePositionType)beginPosition;
        } else if (beginPosition != null) {
            this.beginPosition = new TimePositionType(beginPosition.getDate());
        }
    }

    public TimePeriodType(Date beginPosition, TimeIndeterminateValueType indeterminateEnd) {
        this.endPosition = new TimePositionType(this.endPosition);
        this.endPosition = new TimePositionType(indeterminateEnd);
    }

    public TimePeriodType(Duration duration) {
        this.duration = duration;
    }

    public TimePeriodType(TimePeriodType that) {
        super(that);
        if (that.begin != null) {
            this.begin = new TimeInstantPropertyType(that.begin);
        }
        if (that.beginPosition != null) {
            that.beginPosition = new TimePositionType(that.beginPosition);
        }
        this.duration = that.duration;
        if (that.end != null) {
            this.end = new TimeInstantPropertyType(that.end);
        }
        if (that.endPosition != null) {
            this.endPosition = new TimePositionType(that.endPosition);
        }
        if (that.timeInterval != null) {
            this.timeInterval = new TimeIntervalLengthType(that.timeInterval);
        }
    }

    public TimePositionType getBeginPosition() {
        return this.beginPosition;
    }

    public void setBeginPosition(TimePositionType value) {
        this.beginPosition = value;
    }

    public void setBeginPosition(Date value) {
        this.beginPosition = new TimePositionType(value);
    }

    public void setBeginPosition(TimeIndeterminateValueType value) {
        this.beginPosition = new TimePositionType(value);
    }

    public void setBeginPosition(TimeInstantType value) {
        if (value != null) {
            this.beginPosition = value.getTimePosition();
        }
    }

    public TimeInstantPropertyType getBegin() {
        return this.begin;
    }

    public void setBegin(TimeInstantPropertyType value) {
        this.begin = value;
    }

    public TimePositionType getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(Date value) {
        this.endPosition = new TimePositionType(value);
    }

    public void setEndPosition(TimeIndeterminateValueType value) {
        this.endPosition = new TimePositionType(value);
    }

    public void setEndPosition(TimeInstantType value) {
        if (value != null) {
            this.endPosition = value.getTimePosition();
        }
    }

    public void setEndPosition(TimePositionType value) {
        this.endPosition = value;
    }

    public TimeInstantPropertyType getEnd() {
        return this.end;
    }

    public void setEnd(TimeInstantPropertyType value) {
        this.end = value;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration value) {
        this.duration = value;
    }

    public TimeIntervalLengthType getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(TimeIntervalLengthType value) {
        this.timeInterval = value;
    }

    @Override
    public Instant getBeginning() {
        if (this.begin != null) {
            return this.begin.getTimeInstant();
        }
        if (this.beginPosition != null) {
            return new TimeInstantType(this.beginPosition);
        }
        return null;
    }

    @Override
    public Instant getEnding() {
        if (this.end != null) {
            return this.end.getTimeInstant();
        }
        if (this.endPosition != null) {
            return new TimeInstantType(this.endPosition);
        }
        return null;
    }

    public long getTime() {
        long e;
        long b;
        if (this.beginPosition != null && this.beginPosition.getDate() != null) {
            b = this.beginPosition.getDate().getTime();
        } else if (this.begin != null && this.begin.getTimeInstant() != null && this.begin.getTimeInstant().getTimePosition() != null && this.begin.getTimeInstant().getTimePosition().getDate() != null) {
            b = this.begin.getTimeInstant().getTimePosition().getDate().getTime();
        } else {
            return -1L;
        }
        if (this.endPosition != null && this.endPosition.getDate() != null) {
            e = this.endPosition.getDate().getTime();
        } else if (this.end != null && this.end.getTimeInstant() != null && this.end.getTimeInstant().getTimePosition() != null && this.end.getTimeInstant().getTimePosition().getDate() != null) {
            e = this.end.getTimeInstant().getTimePosition().getDate().getTime();
        } else {
            return -1L;
        }
        return e - b;
    }

    @Override
    public AbstractTimeObjectType getClone() {
        return new TimePeriodType(this);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimePeriodType)) {
            return false;
        }
        TimePeriodType that = (TimePeriodType)object;
        return Objects.equals(this.begin, that.begin) && Objects.equals(this.beginPosition, that.beginPosition) && Objects.equals(this.duration, that.duration) && Objects.equals(this.endPosition, that.endPosition) && Objects.equals(this.timeInterval, that.timeInterval) && Objects.equals(this.end, that.end);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.beginPosition != null ? this.beginPosition.hashCode() : 0);
        hash = 37 * hash + (this.begin != null ? this.begin.hashCode() : 0);
        hash = 37 * hash + (this.endPosition != null ? this.endPosition.hashCode() : 0);
        hash = 37 * hash + (this.end != null ? this.end.hashCode() : 0);
        hash = 37 * hash + (this.duration != null ? this.duration.hashCode() : 0);
        hash = 37 * hash + (this.timeInterval != null ? this.timeInterval.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        char lineSeparator = '\n';
        StringBuilder s2 = new StringBuilder("TimePeriod:").append(lineSeparator);
        if (this.begin != null) {
            s2.append("begin:").append(this.begin).append(lineSeparator);
        }
        if (this.end != null) {
            s2.append("end  :").append(this.end).append(lineSeparator);
        }
        if (this.beginPosition != null) {
            s2.append("beginPosition :").append(this.beginPosition).append(lineSeparator);
        }
        if (this.endPosition != null) {
            s2.append("endPosition   :").append(this.endPosition);
        }
        if (this.duration != null) {
            s2.append(lineSeparator).append("duration:").append(this.duration);
        }
        if (this.timeInterval != null) {
            s2.append(lineSeparator).append("timeInterval:").append(this.timeInterval).append(lineSeparator);
        }
        return s2.toString();
    }
}

