/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.io;

import java.io.File;
import java.io.IOException;
import java.lang.ref.PhantomReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;
import org.geotoolkit.internal.ReferenceQueueConsumer;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.nio.IOUtilities;
import org.geotoolkit.resources.Loggings;

public final class TemporaryFile
extends PhantomReference<Path>
implements Disposable {
    private static final Map<String, TemporaryFile> REFERENCES = new HashMap<String, TemporaryFile>();
    private static Path sharedTemporaryDirectory;
    private final String path;

    private TemporaryFile(Path file) {
        super(file, ReferenceQueueConsumer.DEFAULT.queue);
        this.path = file.toString();
    }

    public static synchronized Path getSharedTemporaryDirectory() {
        Path directory = sharedTemporaryDirectory;
        if (directory == null) {
            directory = Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), "Geotoolkit.org");
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                try {
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    directory = directory.getParent();
                }
            }
            sharedTemporaryDirectory = directory;
        }
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path createTempFile(String prefix, String suffix, Path directory) throws IOException {
        Path tmpFile = directory == null ? Files.createTempFile(prefix, suffix, new FileAttribute[0]) : Files.createTempFile(directory, prefix, suffix, new FileAttribute[0]);
        TemporaryFile ref = new TemporaryFile(tmpFile);
        Map<String, TemporaryFile> map = REFERENCES;
        synchronized (map) {
            if (REFERENCES.put(ref.path, ref) != null) {
                throw new AssertionError(ref);
            }
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(File file) {
        Map<String, TemporaryFile> map = REFERENCES;
        synchronized (map) {
            TemporaryFile ref = REFERENCES.remove(file.getPath());
            if (ref != null) {
                ref.clear();
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(Path file) {
        Map<String, TemporaryFile> map = REFERENCES;
        synchronized (map) {
            TemporaryFile ref = REFERENCES.remove(file.toString());
            if (ref != null) {
                ref.clear();
            }
        }
        return IOUtilities.deleteSilently(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete() {
        Map<String, TemporaryFile> map = REFERENCES;
        synchronized (map) {
            if (REFERENCES.remove(this.path) == this) {
                Path filePath = Paths.get(this.path, new String[0]);
                IOUtilities.deleteSilently(filePath);
                return new File(this.path).delete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteAll() {
        boolean deleted = false;
        Map<String, TemporaryFile> references = REFERENCES;
        if (references != null) {
            Map<String, TemporaryFile> map = references;
            synchronized (map) {
                for (TemporaryFile ref : references.values()) {
                    deleted |= IOUtilities.deleteSilently(Paths.get(ref.path, new String[0]));
                    ref.clear();
                }
                references.clear();
            }
        }
        return deleted;
    }

    @Override
    public void dispose() {
        if (this.delete()) {
            Logging.log(TemporaryFile.class, "delete", Loggings.format(Level.WARNING, (short)39, this));
        }
    }

    public String toString() {
        return this.path;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(Threads.RESOURCE_DISPOSERS, "TemporaryFile"){

            @Override
            public void run() {
                while (TemporaryFile.deleteAll()) {
                    Thread.yield();
                }
            }
        });
    }
}

