/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Cache;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

public class CoordinateReferenceSystemAdapter
extends XmlAdapter<String, CoordinateReferenceSystem> {
    private static final CoordinateReferenceSystem DEFAULT_CRS = CommonCRS.WGS84.normalizedGeographic();
    private static final Cache<CoordinateReferenceSystem, String> cachedIdentifier = new Cache();

    @Override
    public CoordinateReferenceSystem unmarshal(String v) throws Exception {
        if (v != null) {
            return CRS.forCode(v);
        }
        return null;
    }

    @Override
    public String marshal(CoordinateReferenceSystem v) throws Exception {
        return CoordinateReferenceSystemAdapter.getSrsName(v);
    }

    public static String getSrsName(CoordinateReferenceSystem crs) {
        String srsName = null;
        if (crs != null) {
            try {
                srsName = cachedIdentifier.get(crs);
                if (srsName == null && !cachedIdentifier.containsKey(crs)) {
                    CoordinateReferenceSystem candidate = Utilities.equalsIgnoreMetadata(crs, DEFAULT_CRS) || CRS.findOperation(crs, DEFAULT_CRS, null).getMathTransform().isIdentity() ? DEFAULT_CRS : crs;
                    srsName = IdentifiedObjects.lookupURN(candidate, Citations.EPSG);
                    if (srsName == null && (srsName = IdentifiedObjects.lookupURN(candidate, null)) == null) {
                        srsName = IdentifiedObjects.getIdentifierOrName(candidate);
                    }
                    cachedIdentifier.put(crs, srsName);
                }
            }
            catch (FactoryException ex) {
                Logger.getLogger("org.geotoolkit.referencing").log(Level.WARNING, null, ex);
            }
        }
        return srsName;
    }
}

