/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CoordinatesType", propOrder={"value"})
public class CoordinatesType {
    @XmlValue
    private String value;
    @XmlAttribute
    private String decimal;
    @XmlAttribute
    private String cs;
    @XmlAttribute
    private String ts;

    CoordinatesType() {
    }

    public CoordinatesType(String value, String cs, String decimal, String ts) {
        this.value = value;
        this.cs = cs;
        this.ts = ts;
        this.decimal = decimal;
    }

    public CoordinatesType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<Double> getValues() {
        String curentTs = this.ts == null ? " " : this.ts;
        String curentCs = this.cs == null ? "," : this.cs;
        ArrayList<Double> values = new ArrayList<Double>();
        if (this.value != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.value, curentTs);
            while (tokenizer.hasMoreTokens()) {
                String v = tokenizer.nextToken();
                try {
                    int i = v.indexOf(curentCs);
                    if (i == -1) continue;
                    String first = v.substring(0, i);
                    String second = v.substring(i + 1);
                    values.add(Double.parseDouble(first));
                    values.add(Double.parseDouble(second));
                }
                catch (NumberFormatException ex) {
                    Logger.getLogger("org.geotoolkit.internal.jaxb").log(Level.WARNING, "unable to parse coordiante value:{0}", v);
                }
            }
        }
        return values;
    }

    public String getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String value) {
        this.decimal = value;
    }

    public String getCs() {
        return this.cs;
    }

    public void setCs(String value) {
        this.cs = value;
    }

    public String getTs() {
        return this.ts;
    }

    public void setTs(String value) {
        this.ts = value;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 47 * hash + (this.decimal != null ? this.decimal.hashCode() : 0);
        hash = 47 * hash + (this.cs != null ? this.cs.hashCode() : 0);
        hash = 47 * hash + (this.ts != null ? this.ts.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CoordinatesType) {
            CoordinatesType that = (CoordinatesType)object;
            return Objects.equals(this.cs, that.cs) && Objects.equals(this.ts, that.ts) && Objects.equals(this.value, that.value) && Objects.equals(this.decimal, that.decimal);
        }
        return false;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("CoordinatesType[").append('\n');
        if (this.value != null) {
            s2.append("value : ").append(this.value.toString()).append('\n');
        }
        if (this.decimal != null) {
            s2.append("decimal : ").append(this.decimal.toString()).append('\n');
        }
        if (this.cs != null) {
            s2.append("cs : ").append(this.cs.toString()).append('\n');
        }
        if (this.ts != null) {
            s2.append("ts : ").append(this.ts.toString()).append('\n');
        }
        s2.append("]");
        return s2.toString();
    }
}

