/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.sql;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.geotoolkit.internal.sql.Dialect;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;

public class ScriptRunner
implements FilenameFilter {
    private static final String COMMENT = "--";
    public static final char END_OF_STATEMENT = ';';
    public static final char QUOTE = '\'';
    public static final char IDENTIFIER_QUOTE = '\"';
    private static final String[] ESCAPES = new String[]{"$$", "$BODY$"};
    protected final String identifierQuote;
    private String encoding;
    protected final List<String> suffixes = new ArrayList<String>();
    protected final Dialect dialect;
    protected final Map<String, String> replacements = new HashMap<String, String>();
    private final Statement statement;
    private File currentFile;
    private int currentLine;
    private String currentSQL;

    public ScriptRunner(Connection connection) throws SQLException {
        if (connection != null) {
            DatabaseMetaData metadata = connection.getMetaData();
            this.dialect = Dialect.guess(metadata);
            this.identifierQuote = metadata.getIdentifierQuoteString();
            this.statement = connection.createStatement();
        } else {
            this.dialect = Dialect.ANSI;
            this.identifierQuote = "\"";
            this.statement = null;
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.statement != null ? this.statement.getConnection() : null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean accept(File directory, String name) {
        int e = name.lastIndexOf(46);
        return e > 0 && name.charAt(0) != '.' && name.regionMatches(true, e + 1, "sql", 0, 3);
    }

    public int run(File file) throws IOException, SQLException {
        if (file.isDirectory()) {
            return this.run(file, file.list(this));
        }
        return this.runFile(file);
    }

    final int run(File directory, String[] files) throws IOException, SQLException {
        if (files.length == 0) {
            return 0;
        }
        String prefix = null;
        String suffix = null;
        for (String file : files) {
            prefix = CharSequences.commonPrefix(prefix, file).toString();
            suffix = CharSequences.commonSuffix(suffix, file).toString();
        }
        int pl = prefix.length();
        int sl = suffix.length();
        LinkedHashSet<String> uniques = new LinkedHashSet<String>();
        final HashMap<String, Integer> order = new HashMap<String, Integer>();
        String[] versions = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            String version = file.substring(pl, file.length() - sl);
            int size = this.suffixes.size();
            for (int j = 0; j < size; ++j) {
                String s2 = this.suffixes.get(j);
                if (!version.endsWith(s2)) continue;
                version = version.substring(0, version.length() - s2.length());
                order.put(file, j);
                break;
            }
            versions[i] = version;
            uniques.add(version);
        }
        String select = this.selectVersion(uniques.toArray(new String[uniques.size()]));
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            if (!select.equals(versions[i])) continue;
            files[count++] = files[i];
        }
        files = ArraysExt.resize(files, count);
        Arrays.sort(files, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer i1 = (Integer)order.get(o1);
                Integer i2 = (Integer)order.get(o2);
                if (i1 == null) {
                    return 1;
                }
                if (i2 == null) {
                    return -1;
                }
                return i1 - i2;
            }
        });
        count = 0;
        for (String file : files) {
            count += this.runFile(new File(directory, file));
        }
        return count;
    }

    int runFile(File file) throws IOException, SQLException {
        int count;
        String encoding = this.encoding;
        InputStreamReader reader = encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        try (LineNumberReader in = new LineNumberReader(reader);){
            this.currentFile = file;
            count = this.run(in);
            this.currentFile = null;
        }
        return count;
    }

    public final int run(InputStream in) throws IOException, SQLException {
        InputStreamReader reader = this.encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, this.encoding);
        try (LineNumberReader lr = new LineNumberReader(reader);){
            int n = this.run(lr);
            return n;
        }
    }

    public final int run(LineNumberReader in) throws IOException, SQLException {
        String line;
        boolean noReplace = this.replacements.isEmpty();
        boolean replaceTwoWords = false;
        for (String replace : this.replacements.keySet()) {
            if (replace.indexOf(32) < 0) continue;
            replaceTwoWords = true;
            break;
        }
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        boolean insideText = false;
        boolean insideIdentifier = false;
        block6: while ((line = in.readLine()) != null) {
            int i = buffer.length();
            if (i == 0) {
                String[] trimed = line.trim();
                if (trimed.isEmpty() || trimed.startsWith(COMMENT)) continue;
                this.currentLine = in.getLineNumber();
            } else {
                ++i;
                buffer.append('\n');
            }
            for (String escape : ESCAPES) {
                int pos = line.indexOf(escape);
                if (pos < 0) continue;
                pos += escape.length();
                while ((pos = line.indexOf(escape, pos)) < 0) {
                    buffer.append(line).append('\n');
                    line = in.readLine();
                    if (line == null) {
                        throw new EOFException();
                    }
                    pos = 0;
                }
                buffer.append(line.substring(0, pos += escape.length()));
                i = buffer.length();
                line = line.substring(pos);
                break;
            }
            buffer.append(line);
            int length = buffer.length();
            while (i < length) {
                char c = buffer.charAt(i);
                switch (c) {
                    case '\"': {
                        if (insideText) break;
                        insideIdentifier = !insideIdentifier;
                        buffer.replace(i, i + 1, this.identifierQuote);
                        i += this.identifierQuote.length() - 1;
                        break;
                    }
                    case '\'': {
                        if (insideIdentifier) break;
                        if (!insideText) {
                            insideText = true;
                            break;
                        }
                        if (i + 1 == length || buffer.charAt(i + 1) != '\'') {
                            insideText = false;
                            break;
                        }
                        ++i;
                        break;
                    }
                    case ';': {
                        if (insideText || insideIdentifier) break;
                        int stop = i;
                        while (++i < length) {
                            if (Character.isSpaceChar(buffer.charAt(i))) continue;
                            stop = length;
                            break;
                        }
                        buffer.setLength(stop);
                        count += this.execute(buffer);
                        buffer.setLength(0);
                        continue block6;
                    }
                    default: {
                        if (noReplace || insideText || insideIdentifier || !Character.isJavaIdentifierStart(c)) break;
                        int start = i;
                        while (++i < length && Character.isJavaIdentifierPart(buffer.charAt(i))) {
                        }
                        String word = buffer.substring(start, i);
                        String replace = this.replacements.get(word);
                        if (replaceTwoWords && replace == null && i < length && Character.isSpaceChar(buffer.charAt(i))) {
                            int mark = i++;
                            if (i < length && Character.isJavaIdentifierStart(buffer.charAt(i))) {
                                while (++i < length && Character.isJavaIdentifierPart(buffer.charAt(i))) {
                                }
                                word = buffer.substring(start, i);
                                replace = this.replacements.get(word);
                            }
                            if (replace == null) {
                                i = mark;
                            }
                        }
                        if (replace != null) {
                            buffer.replace(start, i, replace);
                            i = start + replace.length();
                            length = buffer.length();
                        }
                        --i;
                    }
                }
                ++i;
            }
        }
        in.close();
        line = buffer.toString().trim();
        if (!line.isEmpty() && !line.startsWith(COMMENT)) {
            throw new EOFException(Errors.format((short)98, Character.valueOf(';')));
        }
        return count;
    }

    public final int run(String statement) throws IOException, SQLException {
        return this.run(new LineNumberReader(new StringReader(statement)));
    }

    protected String selectVersion(String[] versions) {
        StringBuilder buffer = new StringBuilder();
        Version max = null;
        String selected = versions[versions.length - 1];
        for (String version : versions) {
            int length = version.length();
            for (int i = 0; i < length; ++i) {
                char c = version.charAt(i);
                if (c < '0' || c > '9') continue;
                buffer.setLength(0);
                while (i < length) {
                    if (!Character.isLetterOrDigit(c = version.charAt(i++))) {
                        c = '.';
                    }
                    buffer.append(c);
                }
                Version candidate = new Version(buffer.toString());
                if (max != null && max.compareTo(candidate) > 0) continue;
                max = candidate;
                selected = version;
            }
        }
        return selected;
    }

    protected int execute(StringBuilder sql) throws SQLException, IOException {
        int count;
        if (this.statement == null) {
            return 0;
        }
        this.currentSQL = sql.toString();
        if (this.currentSQL.startsWith("SELECT ")) {
            this.statement.executeQuery(this.currentSQL).close();
            count = 0;
        } else {
            count = this.statement.executeUpdate(this.currentSQL);
        }
        this.currentSQL = null;
        return count;
    }

    public void close(boolean vacuum) throws SQLException {
        if (this.statement != null) {
            switch (this.dialect) {
                case POSTGRESQL: {
                    if (!vacuum) break;
                    this.statement.executeUpdate("VACUUM FULL ANALYZE");
                }
            }
            this.statement.close();
        }
    }

    public String getCurrentPosition() {
        String position = null;
        if (this.currentFile != null) {
            position = Vocabulary.format((short)93, this.currentFile, this.currentLine);
        }
        if (this.currentSQL != null) {
            StringBuilder buffer = new StringBuilder();
            if (position != null) {
                buffer.append(position).append('\n');
            }
            position = buffer.append("SQL: ").append(this.currentSQL).toString();
        }
        return position;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName()).append('[');
        if (this.currentFile != null) {
            buffer.append(this.currentFile.getName()).append(" : ").append(this.currentLine);
        }
        buffer.append(']');
        if (this.currentSQL != null) {
            buffer.append('\n').append(this.currentSQL);
        }
        return buffer.toString();
    }
}

