/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.WeakHashSet;
import org.opengis.annotation.Obligation;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.util.InternationalString;

@Deprecated
public class ValueRestriction
implements Serializable {
    private static final long serialVersionUID = 888961503200860655L;
    static final ValueRestriction PENDING = new ValueRestriction(null, null, null);
    private static final WeakHashSet<ValueRestriction> POOL = new WeakHashSet<ValueRestriction>(ValueRestriction.class);
    public final Obligation obligation;
    public final NumberRange<?> range;
    public final Set<?> validValues;

    protected ValueRestriction(Obligation obligation, NumberRange<?> range, Set<?> validValues) {
        this.obligation = obligation;
        this.range = range;
        this.validValues = validValues;
    }

    private static ValueRestriction create(Obligation obligation, NumberRange<?> range, Set<?> validValues) {
        if (range == null && validValues == null && obligation != Obligation.MANDATORY && obligation != Obligation.FORBIDDEN) {
            return null;
        }
        return POOL.unique(new ValueRestriction(obligation, range, validValues));
    }

    public static ValueRestriction create(ExtendedElementInformation info) {
        if (info != null) {
            Obligation o = info.getObligation();
            InternationalString domain = info.getDomainValue();
            return ValueRestriction.create(o != null ? Obligation.valueOf(o.name()) : null, domain instanceof NumberRange ? (NumberRange)((Object)domain) : null, domain instanceof Set ? (Set)((Object)domain) : null);
        }
        return null;
    }

    public final ValueRestriction violation(Object value) {
        Obligation obligation = this.obligation;
        NumberRange<?> range = this.range;
        Set<?> validValues = this.validValues;
        boolean changed = false;
        if (obligation != (value == null ? Obligation.MANDATORY : Obligation.FORBIDDEN)) {
            obligation = null;
            changed = true;
        }
        if (value == null || range == null || value instanceof Number && range.containsAny((Number)value)) {
            range = null;
            changed = true;
        }
        if (value == null || validValues == null || validValues.contains(value)) {
            validValues = null;
            changed = true;
        }
        return changed ? ValueRestriction.create(obligation, range, validValues) : this;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            ValueRestriction that = (ValueRestriction)other;
            return this.obligation == that.obligation && Objects.equals(this.range, that.range) && Objects.equals(this.validValues, that.validValues);
        }
        return false;
    }

    public int hashCode() {
        int code = -112666129;
        if (this.obligation != null) {
            code ^= this.obligation.hashCode();
        }
        if (this.range != null) {
            code ^= this.range.hashCode();
        }
        if (this.validValues != null) {
            code ^= this.validValues.hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this)).append('[');
        String separator = "";
        if (this.obligation != null) {
            buffer.append(this.obligation.name());
            separator = ", ";
        }
        if (this.range != null) {
            buffer.append(separator).append("range=").append(this.range);
            separator = ", ";
        }
        if (this.validValues != null) {
            buffer.append(separator).append("validValues=").append(this.validValues);
        }
        return buffer.append(']').toString();
    }
}

