/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.nio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.geotoolkit.lang.Static;
import org.geotoolkit.nio.CopyFileVisitor;
import org.geotoolkit.nio.IOUtilities;

public class ZipUtilities
extends Static {
    private static final int BUFFER_SIZE = 8192;

    private ZipUtilities() {
    }

    private static FileSystem createZipFileSystem(Path zipPath, boolean create) throws IOException {
        URI uri = URI.create("jar:" + zipPath.toUri());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public static void zipNIO(Path zipPath, Path ... resouces) throws IOException {
        Files.deleteIfExists(zipPath);
        try (FileSystem zipFs = ZipUtilities.createZipFileSystem(zipPath, true);){
            Path zipRoot = zipFs.getPath("/", new String[0]);
            for (Path resouce : resouces) {
                Path nResouce = resouce.normalize();
                if (Files.isRegularFile(nResouce, LinkOption.NOFOLLOW_LINKS)) {
                    Path dest = zipRoot.resolve(nResouce.getFileName().toString());
                    Files.copy(nResouce, dest, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                Path Dest = zipRoot.resolve(nResouce.getFileName().toString());
                Files.walkFileTree(nResouce, new CopyFileVisitor(Dest, StandardCopyOption.REPLACE_EXISTING));
            }
        }
    }

    public static void unzipNIO(Path zipPath, Path target, boolean withRootDirectory) throws IOException {
        Path deflateDirectory;
        if (Files.notExists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        if (withRootDirectory) {
            String folderName = IOUtilities.filenameWithoutExtension(zipPath);
            deflateDirectory = Files.createDirectories(target.resolve(folderName), new FileAttribute[0]);
        } else {
            deflateDirectory = target;
        }
        try (FileSystem zipFS = ZipUtilities.createZipFileSystem(zipPath, false);){
            Path root = zipFS.getPath("/", new String[0]);
            Files.walkFileTree(root, new CopyFileVisitor(deflateDirectory, StandardCopyOption.REPLACE_EXISTING));
        }
    }

    public static void zip(Path zip, Checksum checksum, Path ... resources) throws IOException {
        ZipUtilities.zip(zip, 0, 0, checksum, resources);
    }

    public static void zip(Path zip, int method, int level, Checksum checksum, Path ... resources) throws IOException {
        block22: {
            try (OutputStream outStream = Files.newOutputStream(zip, new OpenOption[0]);){
                if (checksum != null) {
                    try (CheckedOutputStream cos = new CheckedOutputStream(outStream, checksum);
                         BufferedOutputStream buf = new BufferedOutputStream(cos);){
                        ZipUtilities.zipCore(method, level, buf, resources);
                        break block22;
                    }
                }
                try (BufferedOutputStream buf = new BufferedOutputStream(outStream);){
                    ZipUtilities.zipCore(method, level, buf, resources);
                }
            }
        }
    }

    private static void zipCore(int method, int level, BufferedOutputStream buf, Path[] resources) throws IOException {
        try (ZipOutputStream zout = new ZipOutputStream(buf);){
            zout.setMethod(method);
            zout.setLevel(level);
            ZipUtilities.zipCore(zout, method, level, "", Arrays.asList(resources).iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipCore(ZipOutputStream zout, int method, int level, String entryPath, Iterator<Path> resources) throws IOException {
        CRC32 crc = new CRC32();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        boolean stored = false;
        if (0 == method) {
            stored = true;
        } else if (8 != method) {
            throw new IllegalArgumentException("This compression method is not supported.");
        }
        if (Double.isNaN(level) || Double.isInfinite(level) || level > 9 || level < 0) {
            throw new IllegalArgumentException("Illegal compression level.");
        }
        while (resources.hasNext()) {
            Path resource = resources.next();
            String fileName = resource.getFileName().toString();
            ZipEntry entry = new ZipEntry(entryPath + fileName);
            if (stored) {
                long size = Files.size(resource);
                entry.setCompressedSize(size);
                entry.setSize(size);
                entry.setCrc(crc.getValue());
            }
            if (Files.isDirectory(resource, new LinkOption[0])) {
                DirectoryStream<Path> children = Files.newDirectoryStream(resource);
                try {
                    String nextEntryPath = entryPath + fileName + "/";
                    ZipUtilities.zipCore(zout, method, level, nextEntryPath, children.iterator());
                    continue;
                }
                finally {
                    if (children != null) {
                        children.close();
                    }
                    continue;
                }
            }
            zout.putNextEntry(entry);
            if (stored) {
                try (SeekableByteChannel sbc = Files.newByteChannel(resource, StandardOpenOption.READ);){
                    int bytesRead;
                    crc.reset();
                    while ((bytesRead = sbc.read(byteBuffer)) != -1) {
                        crc.update(byteBuffer.array(), 0, bytesRead);
                    }
                }
            }
            try {
                InputStream is = Files.newInputStream(resource, new OpenOption[0]);
                try {
                    IOUtilities.copy(is, zout);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            finally {
                zout.closeEntry();
            }
        }
    }

    public static List<Path> unzip(Path zip, Checksum checksum) throws IOException {
        return ZipUtilities.unzip(zip, zip.getParent(), checksum);
    }

    public static List<Path> unzip(Path zip, Path resource, Checksum checksum) throws IOException {
        List<Path> list;
        InputStream inStream = Files.newInputStream(zip, new OpenOption[0]);
        if (checksum != null) {
            try (CheckedInputStream cis = new CheckedInputStream(inStream, checksum);){
                List<Path> list2;
                try (BufferedInputStream buf = new BufferedInputStream(cis);){
                    list2 = ZipUtilities.unzipCore(buf, resource);
                }
                return list2;
            }
        }
        try (BufferedInputStream buf = new BufferedInputStream(inStream);){
            list = ZipUtilities.unzipCore(buf, resource);
        }
        return list;
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Path> unzipCore(InputStream zip, Path resource) throws IOException {
        ArrayList<Path> unzipped = new ArrayList<Path>();
        try (ZipInputStream zis = new ZipInputStream(zip);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path file = resource.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(file, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                unzipped.add(file);
                OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);
                try {
                    IOUtilities.copy(zis, fos);
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                }
            }
            return unzipped;
        }
    }
}

