/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.parameter.AbstractParameterValue;
import org.geotoolkit.resources.Errors;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;

@Deprecated
public class Parameter<T>
extends AbstractParameterValue<T> {
    private static final long serialVersionUID = -5837826787089486776L;
    private T value;
    private Unit<?> unit;

    public Parameter(ParameterDescriptor<T> descriptor) {
        super(descriptor);
        this.value = descriptor.getDefaultValue();
        this.unit = descriptor.getUnit();
    }

    public Parameter(ParameterDescriptor<T> descriptor, T value) throws InvalidParameterValueException {
        super(descriptor);
        this.unit = descriptor.getUnit();
        this.setValue(value);
    }

    private String getClassTypeError() {
        return Errors.format((short)69, ((ParameterDescriptor)this.descriptor).getValueClass());
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public double doubleValue(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        Unit<?> actual = this.getUnit();
        if (actual == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        ArgumentChecks.ensureNonNull("unit", unit);
        short expectedID = Parameter.getUnitMessageID(actual);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        try {
            return actual.getConverterToAny(unit).convert(this.doubleValue());
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(Errors.format((short)77, unit), e);
        }
    }

    @Override
    public double doubleValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        String name = Parameter.getName(this.descriptor);
        if (value == null) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public int intValue() throws IllegalStateException {
        int integer;
        T value = this.getValue();
        if (value instanceof Number && (double)(integer = ((Number)value).intValue()) == ((Number)value).doubleValue()) {
            return integer;
        }
        String name = Parameter.getName(this.descriptor);
        if (value == null) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public boolean booleanValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String name = Parameter.getName(this.descriptor);
        if (value == null) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public String stringValue() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof CharSequence) {
            return value.toString();
        }
        String name = Parameter.getName(this.descriptor);
        if (value == null) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public double[] doubleValueList(Unit<?> unit) throws IllegalArgumentException, IllegalStateException {
        UnitConverter converter;
        Unit<?> actual = this.getUnit();
        if (actual == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        ArgumentChecks.ensureNonNull("unit", unit);
        short expectedID = Parameter.getUnitMessageID(actual);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        try {
            converter = actual.getConverterToAny(unit);
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(Errors.format((short)77, unit), e);
        }
        double[] values = (double[])this.doubleValueList().clone();
        for (int i = 0; i < values.length; ++i) {
            values[i] = converter.convert(values[i]);
        }
        return values;
    }

    @Override
    public double[] doubleValueList() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof double[]) {
            return (double[])value;
        }
        String name = Parameter.getName(this.descriptor);
        if (value == null) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public int[] intValueList() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof int[]) {
            return (int[])value;
        }
        String name = Parameter.getName(this.descriptor);
        if (value == null) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), name);
    }

    @Override
    public URI valueFile() throws IllegalStateException {
        T value = this.getValue();
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof File) {
            return ((File)value).toURI();
        }
        URISyntaxException cause = null;
        try {
            if (value instanceof URL) {
                return ((URL)value).toURI();
            }
            if (value instanceof String) {
                return new URI(IOUtilities.encodeURI((String)value));
            }
        }
        catch (URISyntaxException exception) {
            cause = exception;
        }
        String name = Parameter.getName(this.descriptor);
        if (value == null) {
            throw new IllegalStateException(Errors.format((short)115, name));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), cause, name);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value, Unit<?> unit) throws InvalidParameterValueException {
        Double converted;
        ArgumentChecks.ensureNonNull("unit", unit);
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> targetUnit = descriptor.getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter(descriptor);
        }
        short expectedID = Parameter.getUnitMessageID(targetUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new InvalidParameterValueException(Errors.format(expectedID, unit), descriptor.getName().getCode(), value);
        }
        try {
            converted = unit.getConverterToAny(targetUnit).convert(value);
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(Errors.format((short)77, unit), e);
        }
        Parameter.ensureValidValue(descriptor, converted);
        this.setSafeValue(descriptor.getValueClass().cast(value), unit);
    }

    @Override
    public void setValue(double value) throws InvalidParameterValueException {
        this.setSafeValue(Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, value), this.unit);
    }

    @Override
    public void setValue(int value) throws InvalidParameterValueException {
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Class type = descriptor.getValueClass();
        if (type == Double.class || type == Float.class) {
            this.setValue((double)value);
        } else {
            this.setSafeValue(Parameter.ensureValidValue(descriptor, value), this.unit);
        }
    }

    @Override
    public void setValue(boolean value) throws InvalidParameterValueException {
        this.setSafeValue(Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, value), this.unit);
    }

    @Override
    public void setValue(Object value) throws InvalidParameterValueException {
        this.setSafeValue(Parameter.ensureValidValue((ParameterDescriptor)this.descriptor, value), this.unit);
    }

    @Override
    public void setValue(double[] values, Unit<?> unit) throws InvalidParameterValueException {
        UnitConverter converter;
        ArgumentChecks.ensureNonNull("unit", unit);
        ParameterDescriptor descriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> targetUnit = descriptor.getUnit();
        if (targetUnit == null) {
            throw Parameter.unitlessParameter(descriptor);
        }
        short expectedID = Parameter.getUnitMessageID(targetUnit);
        if (Parameter.getUnitMessageID(unit) != expectedID) {
            throw new IllegalArgumentException(Errors.format(expectedID, unit));
        }
        double[] converted = (double[])values.clone();
        try {
            converter = unit.getConverterToAny(targetUnit);
        }
        catch (IncommensurableException e) {
            throw new IllegalArgumentException(Errors.format((short)77, unit), e);
        }
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = converter.convert(converted[i]);
        }
        this.setSafeValue(Parameter.ensureValidValue(descriptor, converted), unit);
    }

    protected void setSafeValue(T value, Unit<?> unit) {
        this.value = value;
        this.unit = unit;
        this.fireValueChanged();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Parameter that = (Parameter)object;
            return Objects.equals(this.value, that.value) && Objects.equals(this.unit, that.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 31 * super.hashCode();
        if (this.value != null) {
            code += this.value.hashCode();
        }
        if (this.unit != null) {
            code += 31 * this.unit.hashCode();
        }
        return code ^ 0x9F456C48;
    }

    @Override
    public Parameter<T> clone() {
        return (Parameter)super.clone();
    }
}

