/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.geotoolkit.process.ProcessDescriptor;
import org.geotoolkit.process.ProcessingRegistry;
import org.opengis.metadata.Identifier;
import org.opengis.util.NoSuchIdentifierException;

public final class ProcessFinder {
    private static List<ProcessingRegistry> REGISTRIES = null;

    private ProcessFinder() {
    }

    public static synchronized Iterator<ProcessingRegistry> getProcessFactories() {
        if (REGISTRIES == null) {
            Iterator<ProcessingRegistry> ite = ServiceLoader.load(ProcessingRegistry.class).iterator();
            REGISTRIES = new ArrayList<ProcessingRegistry>();
            while (ite.hasNext()) {
                REGISTRIES.add(ite.next());
            }
        }
        return REGISTRIES.iterator();
    }

    public static synchronized ProcessingRegistry getProcessFactory(String authorityCode) {
        Iterator<ProcessingRegistry> ite = ProcessFinder.getProcessFactories();
        while (ite.hasNext()) {
            ProcessingRegistry candidate = ite.next();
            for (Identifier identifier : candidate.getIdentification().getCitation().getIdentifiers()) {
                if (!identifier.getCode().equalsIgnoreCase(authorityCode)) continue;
                return candidate;
            }
        }
        return null;
    }

    public static synchronized ProcessDescriptor getProcessDescriptor(String authority, String processName) throws NoSuchIdentifierException {
        if (authority != null && authority.trim().isEmpty()) {
            authority = null;
        }
        if (authority != null) {
            ProcessingRegistry factory = ProcessFinder.getProcessFactory(authority);
            if (factory != null) {
                return factory.getDescriptor(processName);
            }
            throw new NoSuchIdentifierException("No processing registry for given code.", authority);
        }
        Iterator<ProcessingRegistry> ite = ProcessFinder.getProcessFactories();
        while (ite.hasNext()) {
            ProcessingRegistry factory = ite.next();
            try {
                return factory.getDescriptor(processName);
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {
            }
        }
        throw new NoSuchIdentifierException("No process for given code.", processName);
    }

    public static void scanForPlugins() {
        REGISTRIES = null;
    }

    public static ProcessingRegistry getProcessFactory(Iterator<? extends ProcessingRegistry> factories, String authorityCode) {
        while (factories.hasNext()) {
            ProcessingRegistry candidate = factories.next();
            for (Identifier identifier : candidate.getIdentification().getCitation().getIdentifiers()) {
                if (!identifier.getCode().equalsIgnoreCase(authorityCode)) continue;
                return candidate;
            }
        }
        return null;
    }

    public static ProcessDescriptor getProcessDescriptor(Iterator<? extends ProcessingRegistry> factories, String authority, String processName) throws NoSuchIdentifierException {
        if (authority != null && authority.trim().isEmpty()) {
            authority = null;
        }
        if (authority != null) {
            ProcessingRegistry factory = ProcessFinder.getProcessFactory(factories, authority);
            if (factory != null) {
                return factory.getDescriptor(processName);
            }
            throw new NoSuchIdentifierException("No processing registry for given code.", authority);
        }
        while (factories.hasNext()) {
            ProcessingRegistry factory = factories.next();
            try {
                return factory.getDescriptor(processName);
            }
            catch (NoSuchIdentifierException noSuchIdentifierException) {
            }
        }
        throw new NoSuchIdentifierException("No process for given code.", processName);
    }
}

