/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.HashMap;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.PredefinedCS;
import org.geotoolkit.resources.Vocabulary;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.InternationalString;

public final class Axes {
    public static final DefaultCoordinateSystemAxis LONGITUDE = Axes.create(157, "\u03bb", AxisDirection.EAST, Units.DEGREE);
    public static final DefaultCoordinateSystemAxis LATITUDE = Axes.create(144, "\u03c6", AxisDirection.NORTH, Units.DEGREE);
    public static final DefaultCoordinateSystemAxis ELLIPSOIDAL_HEIGHT = Axes.create(80, "h", AxisDirection.UP, Units.METRE);
    public static final DefaultCoordinateSystemAxis X = Axes.create(-1, "x", AxisDirection.EAST, Units.METRE);
    public static final DefaultCoordinateSystemAxis Y = Axes.create(-1, "y", AxisDirection.NORTH, Units.METRE);
    public static final DefaultCoordinateSystemAxis Z = Axes.create(-1, "z", AxisDirection.UP, Units.METRE);
    public static final DefaultCoordinateSystemAxis EASTING = Axes.create(75, "E", AxisDirection.EAST, Units.METRE);
    public static final DefaultCoordinateSystemAxis NORTHING = Axes.create(179, "N", AxisDirection.NORTH, Units.METRE);
    public static final DefaultCoordinateSystemAxis COLUMN = Axes.create(32, "i", AxisDirection.COLUMN_POSITIVE, Units.UNITY);
    public static final DefaultCoordinateSystemAxis ROW = Axes.create(226, "j", AxisDirection.ROW_POSITIVE, Units.UNITY);

    private Axes() {
    }

    private static DefaultCoordinateSystemAxis create(int name, String abbreviation, AxisDirection direction, Unit<?> unit) {
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>(4);
        if (name >= 0) {
            InternationalString n = Vocabulary.formatInternational(name);
            properties.put("name", n.toString(null));
            properties.put("alias", n);
        } else {
            properties.put("name", abbreviation);
        }
        DefaultCoordinateSystemAxis axis = new DefaultCoordinateSystemAxis(properties, abbreviation, direction, unit);
        return axis;
    }

    static CoordinateSystemAxis usingUnit(CoordinateSystemAxis a, Unit<?> newUnit) throws IncommensurableException {
        Unit<?> unit = a.getUnit();
        if (unit.equals(newUnit)) {
            return a;
        }
        UnitConverter converter = unit.getConverterToAny(newUnit);
        HashMap<String, Object> properties = new HashMap<String, Object>(PredefinedCS.getProperties(a, null));
        properties.put("minimumValue", converter.convert(a.getMinimumValue()));
        properties.put("maximumValue", converter.convert(a.getMaximumValue()));
        properties.put("rangeMeaning", a.getRangeMeaning());
        return new DefaultCoordinateSystemAxis(properties, a.getAbbreviation(), a.getDirection(), newUnit);
    }
}

