/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Map;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class Krovak
extends UnitaryProjection {
    private static final long serialVersionUID = -8359105634355342212L;
    private static final double ITERATION_TOLERANCE = 1.0E-11;
    private final double sinAzim;
    private final double cosAzim;
    private final double n;
    private final double tanS2;
    private final double alfa;
    private final double hae;
    private final double k1;
    private final double ka;
    private final double ro0;

    private static Map<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles() {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.geotoolkit.referencing.operation.provider.Krovak.LONGITUDE_OF_CENTRE);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.geotoolkit.referencing.operation.provider.Krovak.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.geotoolkit.referencing.operation.provider.Krovak.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.geotoolkit.referencing.operation.provider.Krovak.FALSE_NORTHING);
        return roles;
    }

    public static MathTransform2D create(OperationMethod descriptor, ParameterValueGroup values) {
        Parameters parameters = Parameters.castOrWrap(values);
        Krovak projection = new Krovak(descriptor, parameters);
        try {
            return (MathTransform2D)projection.createMapProjection(DefaultFactories.forBuildin(MathTransformFactory.class));
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected Krovak(OperationMethod method, Parameters parameters) {
        super(method, parameters, Krovak.roles());
        double latitudeOfOrigin = this.getAndStore(parameters, org.geotoolkit.referencing.operation.provider.Krovak.LATITUDE_OF_CENTRE);
        latitudeOfOrigin = Math.toRadians(latitudeOfOrigin);
        double pseudoStandardParallel = Math.toRadians(this.getAndStore(parameters, org.geotoolkit.referencing.operation.provider.Krovak.PSEUDO_STANDARD_PARALLEL));
        double azimuth = Math.toRadians(this.getAndStore(parameters, org.geotoolkit.referencing.operation.provider.Krovak.AZIMUTH));
        this.sinAzim = Math.sin(azimuth);
        this.cosAzim = Math.cos(azimuth);
        this.n = Math.sin(pseudoStandardParallel);
        this.tanS2 = Math.tan(pseudoStandardParallel / 2.0 + 0.7853981633974483);
        double sinLat = Math.sin(latitudeOfOrigin);
        double cosLat = Math.cos(latitudeOfOrigin);
        double cosL2 = cosLat * cosLat;
        this.alfa = Math.sqrt(1.0 + this.eccentricitySquared * (cosL2 * cosL2) / (1.0 - this.eccentricitySquared));
        this.hae = this.alfa * this.eccentricity / 2.0;
        double u0 = Math.asin(sinLat / this.alfa);
        double esl = this.eccentricity * sinLat;
        double g2 = Math.pow((1.0 - esl) / (1.0 + esl), this.alfa * this.eccentricity / 2.0);
        this.k1 = Math.pow(Math.tan(latitudeOfOrigin / 2.0 + 0.7853981633974483), this.alfa) * g2 / Math.tan(u0 / 2.0 + 0.7853981633974483);
        this.ka = Math.pow(1.0 / this.k1, -1.0 / this.alfa);
        this.ro0 = Math.pow(this.tanS2, -this.n);
        double radius = Math.sqrt(1.0 - this.eccentricitySquared) / (1.0 - this.eccentricitySquared * (sinLat * sinLat));
        double rop = radius / (this.ro0 * Math.tan(pseudoStandardParallel));
        this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).convertAfter(0, -this.alfa, null);
        this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertBefore(0, -rop, null);
        this.getContextualParameters().getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertBefore(1, -rop, null);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u0394v = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u0394v = Math.sin(\u0394v);
        double cos\u0394v = Math.cos(\u0394v);
        double esin\u03c6 = this.eccentricity * Math.sin(\u03c6);
        double tan1 = Math.tan(\u03c6 / 2.0 + 0.7853981633974483);
        double g\u03c6 = Math.pow((1.0 - esin\u03c6) / (1.0 + esin\u03c6), this.hae);
        double V = Math.pow(tan1, this.alfa) / this.k1 * g\u03c6;
        double U = 2.0 * (Math.atan(V) - 0.7853981633974483);
        double sinU = Math.sin(U);
        double cosU = Math.cos(U);
        double sinS = this.cosAzim * sinU + this.sinAzim * cosU * cos\u0394v;
        double cosS = Math.sqrt(1.0 - sinS * sinS);
        double S = Math.asin(sinS);
        double \u0190t = cosU * sin\u0394v / cosS;
        double \u0190 = this.n * Math.asin(\u0190t);
        double cos\u0190 = Math.cos(\u0190);
        double sin\u0190 = Math.sin(\u0190);
        double tan2 = Math.tan(S / 2.0 + 0.7853981633974483);
        double \u03c1 = Math.pow(tan2, this.n);
        if (dstPts != null) {
            dstPts[dstOff] = sin\u0190 / \u03c1;
            dstPts[dstOff + 1] = cos\u0190 / \u03c1;
        }
        if (!derivate) {
            return null;
        }
        double dg\u03c6 = this.eccentricitySquared * Math.cos(\u03c6) / (1.0 - esin\u03c6 * esin\u03c6);
        double dU_d\u03c6 = this.alfa * (1.0 / tan1 + tan1 - 2.0 * dg\u03c6) / (1.0 / V + V);
        double dS_d\u03bb = -this.sinAzim * cosU * sin\u0394v / cosS;
        double dS_d\u03c6 = (-this.sinAzim * sinU * cos\u0394v + this.cosAzim * cosU) * dU_d\u03c6 / cosS;
        double t2 = this.n / (cosS * cosS * Math.sqrt(1.0 - \u0190t * \u0190t));
        double d\u0190_d\u03bb = cosU * t2 * (dS_d\u03bb * sin\u0394v * sinS + cos\u0394v * cosS);
        double d\u0190_d\u03c6 = sin\u0394v * t2 * (dS_d\u03c6 * sinS * cosU - dU_d\u03c6 * sinU * cosS);
        double m4 = -this.n / 2.0 * (1.0 / tan2 + tan2);
        return new Matrix2((m4 * dS_d\u03bb * sin\u0190 + d\u0190_d\u03bb * cos\u0190) / \u03c1, (m4 * dS_d\u03c6 * sin\u0190 + d\u0190_d\u03c6 * cos\u0190) / \u03c1, (m4 * dS_d\u03bb * cos\u0190 - d\u0190_d\u03bb * sin\u0190) / \u03c1, (m4 * dS_d\u03c6 * cos\u0190 - d\u0190_d\u03c6 * sin\u0190) / \u03c1);
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double esf;
        double \u03c61;
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double \u03c1 = Math.hypot(x, y);
        double D = Math.atan2(x, y) / this.n;
        double S = 2.0 * (Math.atan(Math.pow(this.ro0 / \u03c1, 1.0 / this.n) * this.tanS2) - 0.7853981633974483);
        double cosS = Math.cos(S);
        double U = Math.asin(this.cosAzim * Math.sin(S) - this.sinAzim * cosS * Math.cos(D));
        double kau = this.ka * Math.pow(Math.tan(U / 2.0 + 0.7853981633974483), 1.0 / this.alfa);
        double \u0394v = Math.asin(cosS * Math.sin(D) / Math.cos(U));
        double \u03c6 = 0.0;
        int i = 15;
        while (!(Math.abs((\u03c61 = \u03c6) - (\u03c6 = 2.0 * (Math.atan(kau * Math.pow((1.0 + (esf = this.eccentricity * Math.sin(\u03c61))) / (1.0 - esf), this.eccentricity / 2.0)) - 0.7853981633974483))) <= 1.0E-11)) {
            if (--i >= 0) continue;
            throw new ProjectionException(Errors.format((short)104));
        }
        dstPts[dstOff] = \u0394v;
        dstPts[dstOff + 1] = \u03c6;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.sinAzim, Utilities.hash(this.n, super.computeHashCode()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            Krovak that = (Krovak)object;
            return InternalUtilities.epsilonEqual(this.sinAzim, that.sinAzim, mode) && InternalUtilities.epsilonEqual(this.cosAzim, that.cosAzim, mode) && InternalUtilities.epsilonEqual(this.n, that.n, mode) && InternalUtilities.epsilonEqual(this.tanS2, that.tanS2, mode) && InternalUtilities.epsilonEqual(this.alfa, that.alfa, mode) && InternalUtilities.epsilonEqual(this.hae, that.hae, mode) && InternalUtilities.epsilonEqual(this.k1, that.k1, mode) && InternalUtilities.epsilonEqual(this.ka, that.ka, mode) && InternalUtilities.epsilonEqual(this.ro0, that.ro0, mode);
        }
        return false;
    }
}

