/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.util.EnumMap;
import java.util.Map;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.referencing.operation.OperationMethod;

abstract class UnitaryProjection
extends NormalizedProjection {
    private static final double ARGUMENT_TOLERANCE = 1.0E-15;
    static final double ANGLE_TOLERANCE = 1.0E-6;
    static final double ITERATION_TOLERANCE = 1.0E-10;
    static final int MAXIMUM_ITERATIONS = 15;
    static final double EPSILON = 1.0E-7;

    private static Map<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> defaultMap(OperationMethod projection) throws ParameterNotFoundException, ClassCastException {
        ParameterDescriptorGroup parameters = projection.getParameters();
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        for (NormalizedProjection.ParameterRole role : NormalizedProjection.ParameterRole.values()) {
            if (role == NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS || role == NormalizedProjection.ParameterRole.FALSE_WESTING || role == NormalizedProjection.ParameterRole.FALSE_SOUTHING) continue;
            String name = role.name().toLowerCase();
            GeneralParameterDescriptor p = parameters.descriptor(name);
            roles.put(role, Parameters.cast((ParameterDescriptor)p, Double.class));
        }
        return roles;
    }

    protected UnitaryProjection(OperationMethod method, Parameters parameters, Map<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles) {
        super(method, parameters, roles != null ? roles : UnitaryProjection.defaultMap(method));
    }

    final double getAndStore(Parameters parameters, ParameterDescriptor<Double> descriptor) {
        double value = parameters.doubleValue(descriptor);
        Double defaultValue = descriptor.getDefaultValue();
        if (defaultValue == null || !defaultValue.equals(value)) {
            MapProjection.validate(descriptor, value);
            String name = IdentifiedObjects.getName(descriptor, parameters.getDescriptor().getName().getAuthority());
            if (name == null) {
                name = descriptor.getName().getCode();
            }
            this.getContextualParameters().parameter(name).setValue(value);
        }
        return value;
    }

    static boolean isSpherical(Parameters parameters) {
        return parameters.parameter("semi_major").doubleValue() == parameters.parameter("semi_minor").doubleValue();
    }

    @Override
    protected abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4) throws ProjectionException;

    final double msfn(double sin\u03c6, double cos\u03c6) {
        assert (!(Math.abs(sin\u03c6 * sin\u03c6 + cos\u03c6 * cos\u03c6 - 1.0) > 1.0E-15));
        return cos\u03c6 / Math.sqrt(1.0 - sin\u03c6 * sin\u03c6 * this.eccentricitySquared);
    }

    final double ssfn(double \u03c6, double sin\u03c6) {
        assert (!(Math.abs(sin\u03c6 - Math.sin(\u03c6)) > 1.0E-15)) : \u03c6;
        return Math.tan(0.7853981633974483 + 0.5 * \u03c6) * Math.pow((1.0 - (sin\u03c6 *= this.eccentricity)) / (1.0 + sin\u03c6), 0.5 * this.eccentricity);
    }

    final double dssfn_d\u03c6(double \u03c6, double sin\u03c6, double cos\u03c6) {
        assert (!(Math.abs(sin\u03c6 - Math.sin(\u03c6)) > 1.0E-15)) : \u03c6;
        assert (!(Math.abs(cos\u03c6 - Math.cos(\u03c6)) > 1.0E-15)) : \u03c6;
        return 1.0 / cos\u03c6 - this.eccentricitySquared * cos\u03c6 / (1.0 - this.eccentricitySquared * sin\u03c6 * sin\u03c6);
    }
}

