/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

@Deprecated
public abstract class AbstractMathTransform
extends org.apache.sis.referencing.operation.transform.AbstractMathTransform {
    protected AbstractMathTransform() {
    }

    public String getName() {
        String code;
        Identifier identifier;
        ParameterDescriptorGroup descriptor = this.getParameterDescriptors();
        if (descriptor != null && (identifier = descriptor.getName()) != null && (code = identifier.getCode()) != null) {
            return code;
        }
        return Classes.getShortClassName(this);
    }

    static String mismatchedDimension(String argument, int dimension, int expected) {
        return Errors.format((short)95, argument, dimension, expected);
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        int dim = this.getSourceDimensions();
        if (dim != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("ptSrc", 2, dim));
        }
        dim = this.getTargetDimensions();
        if (dim != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("ptDst", 2, dim));
        }
        double[] ord = new double[]{ptSrc.getX(), ptSrc.getY()};
        this.transform(ord, 0, ord, 0, false);
        if (ptDst != null) {
            ptDst.setLocation(ord[0], ord[1]);
            return ptDst;
        }
        return new Point2D.Double(ord[0], ord[1]);
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        int dim = this.getSourceDimensions();
        if (dim != 2 || (dim = this.getTargetDimensions()) != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("shape", 2, dim));
        }
        if (this.isIdentity()) {
            return shape;
        }
        try {
            Method method = AbstractMathTransform2D.class.getMethod("createTransformedShape", MathTransform2D.class, Shape.class, AffineTransform.class, AffineTransform.class, Boolean.TYPE);
            method.setAccessible(true);
            return (Shape)method.invoke(null, (MathTransform2D)((Object)this), shape, null, null, false);
        }
        catch (ReflectiveOperationException e) {
            throw new TransformException(e);
        }
    }

    public Matrix derivative(Point2D point) throws TransformException {
        int dimSource = this.getSourceDimensions();
        if (dimSource != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.mismatchedDimension("point", 2, dimSource));
        }
        double[] coordinate = new double[]{point.getX(), point.getY()};
        Matrix derivative = this.transform(coordinate, 0, null, 0, true);
        if (derivative == null) {
            throw new TransformException(Errors.format((short)5));
        }
        return derivative;
    }

    protected static void ensureNonNull(String name, Object object) throws InvalidParameterValueException {
        if (object == null) {
            throw new InvalidParameterValueException(Errors.format((short)145, name), name, object);
        }
    }

    @Override
    public String formatTo(Formatter formatter) {
        return super.formatTo(formatter);
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = 3528274816628012283L;

        protected Inverse() {
        }

        @Override
        public String getName() {
            return AbstractMathTransform.this.getName() + " (" + Vocabulary.format((short)140) + ")";
        }

        @Override
        public int getSourceDimensions() {
            return AbstractMathTransform.this.getTargetDimensions();
        }

        @Override
        public int getTargetDimensions() {
            return AbstractMathTransform.this.getSourceDimensions();
        }

        @Override
        public Matrix derivative(Point2D point) throws TransformException {
            return MatrixSIS.castOrCopy(AbstractMathTransform.this.derivative(this.transform(point, null))).inverse();
        }

        @Override
        public Matrix derivative(DirectPosition point) throws TransformException {
            return MatrixSIS.castOrCopy(AbstractMathTransform.this.derivative(this.transform(point, null))).inverse();
        }

        private AbstractMathTransform enclosing() {
            return AbstractMathTransform.this;
        }

        @Override
        public MathTransform inverse() {
            return AbstractMathTransform.this;
        }

        @Override
        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        @Override
        protected int computeHashCode() {
            return Utilities.hash(AbstractMathTransform.this.hashCode(), super.computeHashCode());
        }

        @Override
        public boolean equals(Object object, ComparisonMode mode) {
            if (object == this) {
                return true;
            }
            if (object != null && object.getClass() == this.getClass()) {
                Inverse that = (Inverse)object;
                return AbstractMathTransform.this.equals(that.enclosing(), mode);
            }
            return false;
        }

        @Override
        public String formatTo(Formatter formatter) {
            ParameterValueGroup parameters = this.getParameterValues();
            if (parameters != null) {
                WKTUtilities.appendParamMT(parameters, formatter);
                return "PARAM_MT";
            }
            formatter.append(AbstractMathTransform.this);
            return "INVERSE_MT";
        }
    }
}

