/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.resources;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.IndexedResourceBundle;

public final class Loggings
extends IndexedResourceBundle {
    public Loggings(URL filename) {
        super(filename);
    }

    public static Loggings getResources(Locale locale) throws MissingResourceException {
        return Loggings.getBundle(Loggings.class, locale);
    }

    public static LogRecord format(Level level, short key) throws MissingResourceException {
        return Loggings.getResources(null).getLogRecord(level, key);
    }

    public static LogRecord format(Level level, short key, Object arg0) throws MissingResourceException {
        return Loggings.getResources(null).getLogRecord(level, key, arg0);
    }

    public static LogRecord format(Level level, short key, Object arg0, Object arg1) throws MissingResourceException {
        return Loggings.getResources(null).getLogRecord(level, key, arg0, arg1);
    }

    public static LogRecord format(Level level, short key, Object arg0, Object arg1, Object arg2) throws MissingResourceException {
        return Loggings.getResources(null).getLogRecord(level, key, arg0, arg1, arg2);
    }

    public static LogRecord format(Level level, short key, Object arg0, Object arg1, Object arg2, Object arg3) throws MissingResourceException {
        return Loggings.getResources(null).getLogRecord(level, key, arg0, arg1, arg2, arg3);
    }

    public static String format(LogRecord record) {
        String message = record.getMessage();
        ResourceBundle resources = record.getResourceBundle();
        if (resources instanceof IndexedResourceBundle) {
            int key = -1;
            try {
                key = Integer.parseInt(message);
            }
            catch (NumberFormatException e) {
                Loggings.unexpectedException(e);
            }
            if (key >= 0) {
                Object[] parameters = record.getParameters();
                return ((IndexedResourceBundle)resources).getString((short)key, parameters);
            }
        }
        if (resources != null) {
            char c;
            int offset;
            try {
                message = resources.getString(message);
            }
            catch (MissingResourceException e) {
                Loggings.unexpectedException(e);
            }
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters.length != 0 && (offset = message.indexOf(123)) >= 0 && offset < message.length() - 1 && (c = message.charAt(offset)) >= '0' && c <= '9') {
                try {
                    return MessageFormat.format(message, parameters);
                }
                catch (IllegalArgumentException e) {
                    Loggings.unexpectedException(e);
                }
            }
        }
        return message;
    }

    private static void unexpectedException(RuntimeException exception) {
        Logging.unexpectedException(null, IndexedResourceBundle.class, "format", exception);
    }

    public static final class Keys {
        public static final short AdjustedGridGeometry_1 = 1;
        public static final short AmbiguousEllipsoid = 2;
        public static final short AppliedOperation_4 = 3;
        public static final short CantCreateCoordinateOperation_1 = 5;
        public static final short CantCreateObjectFromCode_1 = 6;
        public static final short CantLoadService_2 = 7;
        public static final short CantReadFile_1 = 8;
        public static final short CantRegisterJaiOperation_1 = 9;
        public static final short ClosedDatabaseForThread_2 = 10;
        public static final short ClosedEpsgDatabase = 11;
        public static final short ConnectedDatabaseForThread_2 = 12;
        public static final short ConnectedEpsgDatabase_2 = 13;
        public static final short CoverageStore_8 = 14;
        public static final short CreatedCodecOfClass_2 = 15;
        public static final short CreatedCoordinateOperation_3 = 16;
        public static final short CreatedObject_1 = 17;
        public static final short CreatedSerializableImage_2 = 18;
        public static final short CreatingCachedEpsgDatabase_1 = 19;
        public static final short DeferredTilePainting_2 = 20;
        public static final short DuplicatedContentInFile_1 = 21;
        public static final short ExcessiveTileCache_1 = 22;
        public static final short FactoryImplementations_1 = 23;
        public static final short FactoryReplacedForAxisOrder_4 = 24;
        public static final short FallbackFactory_1 = 25;
        public static final short FlushCache_1 = 26;
        public static final short FoundMismatchedCRS_4 = 27;
        public static final short InitializingTransformation_2 = 28;
        public static final short JdbcDriverVersion_3 = 29;
        public static final short LoadingRegion_6 = 30;
        public static final short MismatchedCoordinateOperationFactories_2 = 31;
        public static final short MismatchedUrnType_1 = 32;
        public static final short NativeAccelerationState_2 = 33;
        public static final short NativeCodecState_3 = 34;
        public static final short RecoverableOutOfMemory_1 = 35;
        public static final short RegisteredJaiOperations = 36;
        public static final short SampleTranscode_3 = 37;
        public static final short TableColumnNotFound_3 = 38;
        public static final short TemporaryFileGc_1 = 39;
        public static final short UnavailableAuthorityFactory_1 = 40;
        public static final short UnrecognizedScaleType_1 = 41;
        public static final short UsingFallback_1 = 42;
        public static final short UsingFileAsFactory_2 = 43;

        private Keys() {
        }
    }
}

