/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.temporal.object.DefaultDuration;
import org.opengis.temporal.IntervalLength;

public class DefaultIntervalLength
extends DefaultDuration
implements IntervalLength {
    private static Unit MS_UNIT = Units.SECOND.divide(1000.0);
    private UnitConverter unitConverter;
    private Unit unit;
    private int radix;
    private int factor;
    private int value;

    public DefaultIntervalLength(Unit unit, int radix, int factor, int value) {
        ArgumentChecks.ensureNonNull("unit", unit);
        ArgumentChecks.ensureNonNull("radix", radix);
        ArgumentChecks.ensureStrictlyPositive("radix", radix);
        ArgumentChecks.ensureNonNull("factor", factor);
        ArgumentChecks.ensureNonNull("value", value);
        this.unit = unit;
        this.unitConverter = unit.getConverterTo(MS_UNIT);
        this.radix = radix;
        this.factor = factor;
        this.value = value;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public int getRadix() {
        return this.radix;
    }

    @Override
    public int getFactor() {
        return this.factor;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public long getTimeInMillis() {
        return Double.doubleToLongBits(this.unitConverter.convert((double)this.value * StrictMath.pow(this.radix, -this.factor)));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultIntervalLength) {
            DefaultIntervalLength that = (DefaultIntervalLength)object;
            return Objects.equals(this.factor, that.factor) && Objects.equals(this.radix, that.radix) && Objects.equals(this.unit, that.unit) && Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.unit != null ? this.unit.hashCode() : 0);
        hash = 37 * hash + this.factor;
        hash = 37 * hash + this.radix;
        hash = 37 * hash + this.value;
        return hash;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("IntervalLength:").append('\n');
        if (this.unit != null) {
            s2.append("unit:").append(this.unit).append('\n');
        }
        s2.append("radix:").append(this.radix).append('\n');
        s2.append("factor:").append(this.factor).append('\n');
        s2.append("value:").append(this.value).append('\n');
        return s2.toString();
    }
}

