/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.util.HashMap;
import java.util.Objects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.SimpleInternationalString;
import org.geotoolkit.temporal.reference.DefaultTemporalReferenceSystem;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.TemporalPosition;
import org.opengis.temporal.TemporalReferenceSystem;

public class DefaultTemporalPosition
implements TemporalPosition {
    private static final TemporalReferenceSystem GREGORIAN_CALENDAR;
    private final TemporalReferenceSystem frame;
    private IndeterminateValue indeterminatePosition;

    public DefaultTemporalPosition(IndeterminateValue indeterminatePosition) {
        this(GREGORIAN_CALENDAR, indeterminatePosition);
    }

    public DefaultTemporalPosition(TemporalReferenceSystem frame, IndeterminateValue indeterminatePosition) {
        ArgumentChecks.ensureNonNull("frame", frame);
        this.frame = frame;
        this.indeterminatePosition = indeterminatePosition;
    }

    @Override
    public IndeterminateValue getIndeterminatePosition() {
        return this.indeterminatePosition;
    }

    @Override
    public TemporalReferenceSystem getFrame() {
        return this.frame;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultTemporalPosition) {
            DefaultTemporalPosition that = (DefaultTemporalPosition)object;
            return Objects.equals(this.frame, that.frame) && Objects.equals(this.indeterminatePosition, that.indeterminatePosition);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.frame != null ? this.frame.hashCode() : 0);
        hash = 37 * hash + (this.indeterminatePosition != null ? this.indeterminatePosition.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("TemporalPosition:").append('\n');
        if (this.frame != null) {
            s2.append("frame:").append(this.frame).append('\n');
        }
        if (this.indeterminatePosition != null) {
            s2.append("indeterminatePosition:").append(this.indeterminatePosition).append('\n');
        }
        return s2.toString();
    }

    static {
        HashMap<String, Object> gregUTCProp = new HashMap<String, Object>();
        gregUTCProp.put("name", "Default Gregorian calendar for position");
        gregUTCProp.put("identifiers", new NamedIdentifier(null, new SimpleInternationalString("Gregorian calendar")));
        GREGORIAN_CALENDAR = new DefaultTemporalReferenceSystem(gregUTCProp);
    }
}

