/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.geotoolkit.util.collection.UnSynchronizedCache;

public class ISODateParser {
    private static final TimeZone GMT0 = TimeZone.getTimeZone("GMT+0");
    private final Calendar calendar = Calendar.getInstance();
    private static final int DECIMAL = 10;
    private final Map<String, TimeZone> TIME_ZONES = new UnSynchronizedCache<String, TimeZone>(10){

        @Override
        public TimeZone get(Object o) {
            TimeZone tz = (TimeZone)super.get(o);
            if (tz == null) {
                tz = TimeZone.getTimeZone((String)o);
                this.put((String)o, tz);
            }
            return tz;
        }
    };

    public ISODateParser() {
        this.calendar.setTimeZone(GMT0);
        this.calendar.set(0, 0, 1, 0, 0, 0);
        this.calendar.set(14, 0);
    }

    private void parse(String date) {
        int mil;
        int sec;
        int min2;
        int hour;
        int day;
        int month;
        int year;
        TimeZone[] bufferTZ = new TimeZone[1];
        int index1 = date.indexOf(45, 1);
        if (index1 < 0) {
            index1 = this.searchTimeZone(date, 1, bufferTZ);
            if (index1 <= 5) {
                year = Integer.parseInt(date, 0, index1, 10);
                month = 1;
                day = 1;
                hour = 0;
                min2 = 0;
                sec = 0;
                mil = 0;
            } else {
                int idxNegative = 0;
                if (date.indexOf(45) == 0) {
                    idxNegative = 1;
                }
                year = Integer.parseInt(date, 0, idxNegative + 4, 10);
                if (index1 <= 7) {
                    month = Integer.parseInt(date, idxNegative + 4, index1, 10);
                    day = 1;
                    hour = 0;
                    min2 = 0;
                    sec = 0;
                    mil = 0;
                } else {
                    month = Integer.parseInt(date, idxNegative + 4, idxNegative + 6, 10);
                    day = index1 <= 9 ? Integer.parseInt(date, idxNegative + 6, index1, 10) : Integer.parseInt(date, idxNegative + 6, idxNegative + 8, 10);
                    hour = 0;
                    min2 = 0;
                    sec = 0;
                    mil = 0;
                }
            }
        } else {
            int index2;
            year = Integer.parseInt(date, 0, index1, 10);
            if ((index2 = date.indexOf(45, ++index1)) < 0) {
                index2 = this.searchTimeZone(date, index1, bufferTZ);
                month = Integer.parseUnsignedInt(date, index1, index2, 10);
                day = 1;
                hour = 0;
                min2 = 0;
                sec = 0;
                mil = 0;
            } else {
                month = Integer.parseUnsignedInt(date, index1, index2, 10);
                if ((index1 = date.indexOf(84, ++index2)) < 0) {
                    index1 = this.searchTimeZone(date, index2, bufferTZ);
                    day = Integer.parseUnsignedInt(date, index2, index1, 10);
                    hour = 0;
                    min2 = 0;
                    sec = 0;
                    mil = 0;
                } else {
                    day = Integer.parseUnsignedInt(date, index2, index1, 10);
                    index2 = date.indexOf(58, ++index1);
                    hour = Integer.parseUnsignedInt(date, index1, index2, 10);
                    index1 = date.indexOf(58, ++index2);
                    min2 = Integer.parseUnsignedInt(date, index2, index1, 10);
                    if ((index2 = date.indexOf(46, ++index1)) > 0) {
                        sec = Integer.parseUnsignedInt(date, index1, index2, 10);
                        index1 = this.searchTimeZone(date, ++index2, bufferTZ);
                        mil = Integer.parseUnsignedInt(date, index2, index1, 10);
                    } else {
                        index2 = this.searchTimeZone(date, index1, bufferTZ);
                        sec = Integer.parseUnsignedInt(date, index1, index2, 10);
                        mil = 0;
                    }
                }
            }
        }
        if (year > 0) {
            this.calendar.set(0, 1);
            this.calendar.set(1, year);
        } else {
            this.calendar.set(0, 0);
            this.calendar.set(1, -year);
        }
        this.calendar.setTimeZone(bufferTZ[0]);
        this.calendar.set(2, month - 1);
        this.calendar.set(5, day);
        this.calendar.set(11, hour);
        this.calendar.set(12, min2);
        this.calendar.set(13, sec);
        this.calendar.set(14, mil);
    }

    private int searchTimeZone(String date, int index2, TimeZone[] buffer) {
        int index1 = date.indexOf(90, index2);
        if (index1 > 0) {
            buffer[0] = GMT0;
            return index1;
        }
        index1 = date.indexOf(43, index2);
        if (index1 > 0) {
            buffer[0] = this.TIME_ZONES.get("GMT" + date.substring(index1, date.length()));
            return index1;
        }
        index1 = date.indexOf(45, index2);
        if (index1 > 0) {
            buffer[0] = this.TIME_ZONES.get("GMT" + date.substring(index1, date.length()));
            return index1;
        }
        buffer[0] = TimeZone.getDefault();
        return date.length();
    }

    public Calendar getCalendar(String str) {
        this.parse(str);
        return this.calendar;
    }

    public Date parseToDate(String str) {
        this.parse(str);
        return this.calendar.getTime();
    }

    public long parseToMillis(String str) {
        this.parse(str);
        return this.calendar.getTimeInMillis();
    }
}

