/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.reference;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.geotoolkit.temporal.reference.DefaultTemporalReferenceSystem;
import org.opengis.temporal.Calendar;
import org.opengis.temporal.Clock;
import org.opengis.temporal.ClockTime;
import org.opengis.util.InternationalString;

@XmlType(name="TimeClock_Type", propOrder={"referenceEvent", "referenceTim", "UTCReferenc", "dateBasis"})
@XmlRootElement(name="TimeClock")
public class DefaultClock
extends DefaultTemporalReferenceSystem
implements Clock {
    private InternationalString referenceEvent;
    private ClockTime referenceTime;
    private ClockTime utcReference;
    private Collection<Calendar> dateBasis;

    public DefaultClock(Map<String, ?> properties, ClockTime referenceTime, ClockTime utcReference, Collection<Calendar> dateBasis) {
        super(properties);
        Object ref = properties.get("referenceEvent");
        ArgumentChecks.ensureNonNull("referenceEvent", ref);
        if (!(ref instanceof InternationalString)) {
            throw new IllegalArgumentException("reference Event must be instance of referenceEvent");
        }
        this.referenceEvent = (InternationalString)ref;
        this.referenceTime = referenceTime;
        this.utcReference = utcReference;
        this.dateBasis = dateBasis;
    }

    private DefaultClock() {
    }

    private DefaultClock(Clock object) {
        super(object);
        if (object != null) {
            this.referenceEvent = object.getReferenceEvent();
            ArgumentChecks.ensureNonNull("referenceEvent", this.referenceEvent);
            this.referenceTime = object.getReferenceTime();
            this.utcReference = object.getUTCReference();
            if (object instanceof DefaultClock) {
                this.dateBasis = ((DefaultClock)object).getDateBasis();
            }
        }
    }

    public static DefaultClock castOrCopy(Clock object) {
        if (object == null || object instanceof DefaultClock) {
            return (DefaultClock)object;
        }
        return new DefaultClock(object);
    }

    @Override
    @XmlElement(name="referenceEvent", required=true)
    public InternationalString getReferenceEvent() {
        return this.referenceEvent;
    }

    @Override
    public ClockTime getReferenceTime() {
        return this.referenceTime;
    }

    @XmlElement(name="referenceTime", required=true)
    private String getReferenceTim() {
        Number[] ref = this.referenceTime.getClockTime();
        String refs = (ref[0].intValue() < 10 ? "0" : "") + ref[0];
        for (int r = 1; r < ref.length; ++r) {
            String str = (ref[r].intValue() < 10 ? "0" : "") + ref[r];
            refs = refs + ":" + str;
        }
        return refs;
    }

    @Override
    public ClockTime getUTCReference() {
        return this.utcReference;
    }

    @XmlElement(name="utcReference", required=true)
    private String getUTCReferenc() {
        Number[] ref = this.utcReference.getClockTime();
        String refs = (ref[0].intValue() < 10 ? "0" : "") + ref[0];
        for (int r = 1; r < ref.length; ++r) {
            String str = (ref[r].intValue() < 10 ? "0" : "") + ref[r];
            refs = refs + ":" + str;
        }
        return refs;
    }

    @XmlElement(name="dateBasis")
    public Collection<Calendar> getDateBasis() {
        return this.dateBasis;
    }

    @Override
    public ClockTime clkTrans(ClockTime uTime) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ClockTime utcTrans(ClockTime clkTime) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        boolean sup = super.equals(object, mode);
        if (!sup) {
            return false;
        }
        if (object instanceof DefaultClock) {
            DefaultClock that = (DefaultClock)object;
            return Objects.equals(this.dateBasis, that.dateBasis) && Objects.equals(this.referenceEvent, that.referenceEvent) && Objects.equals(this.referenceTime, that.referenceTime) && Objects.equals(this.utcReference, that.utcReference);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        int hash = 5;
        hash = 37 * hash + (this.dateBasis != null ? this.dateBasis.hashCode() : 0);
        hash = 37 * hash + (this.referenceEvent != null ? this.referenceEvent.hashCode() : 0);
        hash = 37 * hash + (this.referenceTime != null ? this.referenceTime.hashCode() : 0);
        hash = 37 * hash + (this.utcReference != null ? this.utcReference.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder("Clock:").append('\n');
        if (this.referenceEvent != null) {
            s2.append("referenceEvent:").append(this.referenceEvent).append('\n');
        }
        if (this.referenceTime != null) {
            s2.append("referenceTime:").append(this.referenceTime).append('\n');
        }
        if (this.utcReference != null) {
            s2.append("utcReference:").append(this.utcReference).append('\n');
        }
        if (this.dateBasis != null) {
            s2.append("dateBasis:").append(this.dateBasis).append('\n');
        }
        return s2.toString();
    }
}

