/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public final class GeotkClipboard {
    public static final Clipboard INSTANCE = new Clipboard("GeotkClipboard");

    private GeotkClipboard() {
    }

    public static String getSystemClipboardValue() {
        Clipboard systemboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (systemboard == null) {
            return null;
        }
        try {
            Transferable trs = systemboard.getContents(null);
            if (trs == null) {
                return null;
            }
            boolean hasTransferableText = trs.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (hasTransferableText) {
                return (String)trs.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void setSystemClipboardValue(String value) {
        if (value == null) {
            return;
        }
        Clipboard systemboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (systemboard == null) {
            return;
        }
        StringSelection item = new StringSelection(value);
        systemboard.setContents(item, item);
    }
}

