/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class CheckedHashMap<K, V>
extends LinkedHashMap<K, V>
implements Cloneable {
    private static final long serialVersionUID = -5983828895888575736L;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public CheckedHashMap(Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        ArgumentChecks.ensureNonNull("keyType", keyType);
        ArgumentChecks.ensureNonNull("valueType", valueType);
    }

    private static <E> void ensureValidType(E element, Class<E> type) throws IllegalArgumentException {
        if (element != null && !type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format((short)43, "element", type, element.getClass()));
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
        assert (Thread.holdsLock(this.getLock()));
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return super.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object object = this.getLock();
        synchronized (object) {
            return super.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return super.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) throws IllegalArgumentException, UnsupportedOperationException {
        CheckedHashMap.ensureValidType(key, this.keyType);
        CheckedHashMap.ensureValidType(value, this.valueType);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m4) throws UnsupportedOperationException {
        for (Map.Entry<K, V> entry : m4.entrySet()) {
            CheckedHashMap.ensureValidType(entry.getKey(), this.keyType);
            CheckedHashMap.ensureValidType(entry.getValue(), this.valueType);
        }
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.putAll(m4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Object object = this.getLock();
        synchronized (object) {
            return new SyncSet(super.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Object object = this.getLock();
        synchronized (object) {
            return new Sync(super.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Object object = this.getLock();
        synchronized (object) {
            return new SyncSet(super.entrySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedHashMap<K, V> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedHashMap)super.clone();
        }
    }

    private final class SyncSet<E>
    extends Sync<E>
    implements Set<E> {
        SyncSet(Set<E> set) {
            super(set);
        }
    }

    private class Sync<E>
    implements Collection<E> {
        private final Collection<E> view;

        Sync(Collection<E> view) {
            this.view = view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Iterator<E> iterator() {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return new Iter<E>(this.view.iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int size() {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean isEmpty() {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean contains(Object element) {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.contains(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean containsAll(Collection<?> collection) {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.containsAll(collection);
            }
        }

        @Override
        public final boolean add(E element) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(Errors.format((short)162, "add"));
        }

        @Override
        public final boolean addAll(Collection<? extends E> collection) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(Errors.format((short)162, "addAll"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean remove(Object element) throws UnsupportedOperationException {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                CheckedHashMap.this.checkWritePermission();
                return this.view.remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean removeAll(Collection<?> collection) throws UnsupportedOperationException {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                CheckedHashMap.this.checkWritePermission();
                return this.view.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean retainAll(Collection<?> collection) throws UnsupportedOperationException {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                CheckedHashMap.this.checkWritePermission();
                return this.view.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void clear() throws UnsupportedOperationException {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                CheckedHashMap.this.checkWritePermission();
                this.view.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object[] toArray() {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> T[] toArray(T[] array) {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.toArray(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final String toString() {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean equals(Object other) {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.equals(other);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int hashCode() {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.view.hashCode();
            }
        }
    }

    private final class Iter<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        Iter(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.iterator.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() throws NoSuchElementException {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                return this.iterator.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() throws UnsupportedOperationException {
            Object object = CheckedHashMap.this.getLock();
            synchronized (object) {
                CheckedHashMap.this.checkWritePermission();
                this.iterator.remove();
            }
        }
    }
}

