/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.grid;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.util.grid.MonoDimensionMove;
import org.geotoolkit.util.grid.MultiDimensionMove;

public class GridTraversal
implements Spliterator<double[]> {
    static final double EPSILON = 1.0E-8;
    static final double COLINEAR_EPSILON = 1.0E-5;
    private final PointList trajectory;
    private int startPoint;
    private final int endPoint;
    private Spliterator<double[]> intersectionEvaluator;

    private GridTraversal(PointList trajectory) {
        this.trajectory = trajectory;
        this.startPoint = 0;
        this.endPoint = this.trajectory.size() - 1;
        this.prepareSegment();
    }

    private GridTraversal(PointList trajectory, int startPoint, int endPoint) {
        this.trajectory = trajectory;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.prepareSegment();
    }

    @Override
    public boolean tryAdvance(Consumer<? super double[]> action) {
        while (this.intersectionEvaluator != null) {
            boolean pushedForward = this.intersectionEvaluator.tryAdvance(action);
            if (pushedForward) {
                return true;
            }
            this.intersectionEvaluator = null;
            ++this.startPoint;
            this.prepareSegment();
        }
        return false;
    }

    private void prepareSegment() {
        if (this.startPoint >= this.endPoint) {
            return;
        }
        double[] start = this.trajectory.getPoint(this.startPoint);
        double[] end = this.trajectory.getPoint(this.startPoint + 1);
        double[] vec = GridTraversal.toVector(start, end);
        int nonZeroCount = 0;
        int lastNonZero = 0;
        for (int i = 0; i < vec.length; ++i) {
            if (GridTraversal.isNearZero(vec[i])) continue;
            ++nonZeroCount;
            lastNonZero = i;
        }
        switch (nonZeroCount) {
            case 0: {
                ++this.startPoint;
                this.prepareSegment();
                break;
            }
            case 1: {
                this.intersectionEvaluator = new MonoDimensionMove(lastNonZero, start, vec[lastNonZero]);
                break;
            }
            default: {
                this.intersectionEvaluator = new MultiDimensionMove(start, end);
            }
        }
    }

    @Override
    public Spliterator<double[]> trySplit() {
        int span = this.endPoint - this.startPoint;
        if (span > 1) {
            int splitPoint = this.startPoint + span / 2;
            GridTraversal prefix = new GridTraversal(this.trajectory, this.startPoint, splitPoint);
            this.startPoint = splitPoint;
            this.prepareSegment();
            return prefix;
        }
        if (this.intersectionEvaluator == null) {
            this.prepareSegment();
        }
        if (this.intersectionEvaluator != null) {
            return this.intersectionEvaluator.trySplit();
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 273;
    }

    static double ceilOrIncrement(double source) {
        double upper = Math.ceil(source);
        if (GridTraversal.isNearZero(source - upper)) {
            upper += 1.0;
        }
        return upper;
    }

    static double floorOrDecrement(double source) {
        double lower = Math.floor(source);
        if (GridTraversal.isNearZero(source - lower)) {
            lower -= 1.0;
        }
        return lower;
    }

    static boolean isNearZero(double ordinate) {
        return -1.0E-8 <= ordinate && ordinate <= 1.0E-8;
    }

    static double[] toVector(double[] start, double[] end) {
        double[] vec = new double[start.length];
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = end[i] - start[i];
        }
        return vec;
    }

    public static Stream<double[]> stream(double[] trajectory, int dimension, boolean includeStart, boolean parallel) {
        return new Builder().setPolyline(trajectory, dimension).setIncludeStart(includeStart).setParallel(parallel).stream();
    }

    static boolean areColinear(double[] u, double[] v) {
        return Double.isFinite(GridTraversal.colinearityFactor(u, v, 1.0E-5));
    }

    static double colinearityFactor(double[] u, double[] v, double tolerance) {
        double coef = 1.0;
        boolean coefInitialized = false;
        for (int i = 0; i < u.length; ++i) {
            double uv = v[i] - u[i];
            if (!Double.isFinite(uv)) {
                return Double.NaN;
            }
            if (GridTraversal.isNearZero(uv)) continue;
            if (GridTraversal.isNearZero(u[i])) {
                return Double.NaN;
            }
            if (!coefInitialized) {
                coef = v[i] / u[i];
                coefInitialized = true;
                continue;
            }
            if (!(Math.abs(coef - v[i] / u[i]) > tolerance)) continue;
            return Double.NaN;
        }
        return coef;
    }

    static interface PointList {
        public int size();

        public boolean isEmpty();

        public double[] getPoint(int var1);

        public int getDimension();
    }

    public static class Builder {
        PointList polyline;
        boolean includeStart = true;
        boolean parallel = false;

        public Builder setPolyline(Point2D ... coordinates) {
            if (coordinates == null || coordinates.length == 0) {
                this.polyline = null;
            }
            return this.setPolyline(Arrays.asList(coordinates));
        }

        public Builder setPolyline(List<Point2D> coordinates) {
            this.polyline = coordinates == null ? null : new Point2DList(coordinates);
            return this;
        }

        @Deprecated
        public Builder setPolyline(double[] coordinates, int dimension) {
            return this.setPolyline(dimension, coordinates);
        }

        public Builder setPolyline(int dimension, double ... coordinates) {
            this.polyline = coordinates == null ? null : new ContiguousArrayPoint(dimension, coordinates);
            return this;
        }

        public Builder setIncludeStart(boolean includeStart) {
            this.includeStart = includeStart;
            return this;
        }

        public Builder setParallel(boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        public Stream<double[]> stream() {
            ArgumentChecks.ensureNonNull("Polyline", this.polyline);
            if (this.polyline.isEmpty()) {
                return Stream.empty();
            }
            if (this.polyline.size() == 1) {
                return this.includeStart ? Stream.of(this.polyline.getPoint(0)) : Stream.empty();
            }
            Stream<double[]> pointStream = StreamSupport.stream(new GridTraversal(this.polyline), this.parallel);
            if (this.includeStart) {
                double[] firstPoint = this.polyline.getPoint(0);
                Stream<double[]> startPoint = Stream.of(firstPoint);
                return Stream.concat(startPoint, pointStream);
            }
            return pointStream;
        }
    }

    private static class Point2DList
    implements PointList {
        final List<Point2D> source;

        Point2DList(List<Point2D> source) {
            this.source = source;
        }

        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        public double[] getPoint(int index) {
            Point2D pt2d = this.source.get(index);
            return new double[]{pt2d.getX(), pt2d.getY()};
        }

        @Override
        public int getDimension() {
            return 2;
        }
    }

    private static class ContiguousArrayPoint
    implements PointList {
        final double[] coordinates;
        final int dimension;
        final int size;

        public ContiguousArrayPoint(int dimension, double ... coordinates) {
            ArgumentChecks.ensureStrictlyPositive("dimension", dimension);
            if (coordinates.length % dimension != 0) {
                throw new IllegalArgumentException(String.format("Given array size (%d) is not a multiple the number of dimensions (%d) specified", coordinates.length, dimension));
            }
            this.coordinates = coordinates;
            this.dimension = dimension;
            this.size = coordinates.length / dimension;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.coordinates.length <= 0;
        }

        @Override
        public double[] getPoint(int index) {
            return Arrays.copyOfRange(this.coordinates, index *= this.dimension, index + this.dimension);
        }

        @Override
        public int getDimension() {
            return this.dimension;
        }
    }
}

