/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.wmm;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.geotoolkit.util.wmm.GeoMagneticElements;
import org.geotoolkit.util.wmm.LegendreFunction;
import org.geotoolkit.util.wmm.MagneticModel;
import org.geotoolkit.util.wmm.MagneticResults;
import org.geotoolkit.util.wmm.SphericalHarmonicVariables;
import org.geotoolkit.util.wmm.UTMParameters;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class WorldMagneticModel {
    private static final double MEAN_RADIUS = 6371.2;
    private static final double MAG_PS_MIN_LAT_DEGREE = -55.0;
    private static final double MAG_PS_MAX_LAT_DEGREE = 55.0;
    private static final double MAG_UTM_MIN_LAT_DEGREE = -80.5;
    private static final double MAG_UTM_MAX_LAT_DEGREE = 84.5;

    public static MagneticModel readMagModel() throws IOException {
        List<String> lines;
        InputStream stream = WorldMagneticModel.class.getResourceAsStream("WMM.COF");
        if (stream == null) {
            throw new FileNotFoundException("WMM.COF");
        }
        try (InputStream in = stream;
             InputStreamReader inr = new InputStreamReader(in, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inr);){
            lines = reader.lines().collect(Collectors.toList());
        }
        return WorldMagneticModel.readMagModel(lines);
    }

    public static MagneticModel readMagModel(Path path) throws IOException {
        return WorldMagneticModel.readMagModel(Files.readAllLines(path));
    }

    private static MagneticModel readMagModel(List<String> coefficients) throws IOException {
        boolean stop = false;
        int l = 0;
        int nMax = 0;
        while (!stop && l < coefficients.size()) {
            String line;
            if (stop = (line = coefficients.get(l++)).startsWith("99999")) continue;
            String field = line.trim().split(" +")[0];
            try {
                int n = Integer.parseInt(field);
                nMax = Math.max(n, nMax);
            }
            catch (NumberFormatException n) {}
        }
        MagneticModel model = new MagneticModel(nMax * (nMax + 1) / 2 + nMax);
        model.nMax = nMax;
        model.nMaxSecVar = nMax;
        String[] headers = coefficients.get(0).trim().split(" +");
        model.epoch = Double.parseDouble(headers[0]);
        model.ModelName = headers[1];
        stop = false;
        l = 1;
        while (!stop && l < coefficients.size()) {
            String line;
            if (stop = (line = coefficients.get(l++)).startsWith("99999")) continue;
            String[] fields = line.trim().split(" +");
            int n = Integer.parseInt(fields[0]);
            int m4 = Integer.parseInt(fields[1]);
            double gnm = Double.parseDouble(fields[2]);
            double hnm = Double.parseDouble(fields[3]);
            double dgnm = Double.parseDouble(fields[4]);
            double dhnm = Double.parseDouble(fields[5]);
            if (m4 > n) continue;
            int index = n * (n + 1) / 2 + m4;
            model.Main_Field_Coeff_G[index] = gnm;
            model.Secular_Var_Coeff_G[index] = dgnm;
            model.Main_Field_Coeff_H[index] = hnm;
            model.Secular_Var_Coeff_H[index] = dhnm;
        }
        model.CoefficientFileEndDate = model.epoch + 5.0;
        return model;
    }

    public static GeoMagneticElements computeGeoMagneticElements(MagneticModel timedMagneticModel, DirectPosition positionOfInterest) throws FactoryException, TransformException {
        DirectPosition coordGeodetic = WorldMagneticModel.to4326(positionOfInterest);
        DirectPosition coordSpherical = WorldMagneticModel.toSpherical(coordGeodetic);
        SphericalHarmonicVariables SphVariables = WorldMagneticModel.ComputeSphericalHarmonicVariables(coordSpherical, timedMagneticModel.nMax);
        LegendreFunction LegendreFunction2 = WorldMagneticModel.computeLegendreFunction(coordSpherical, timedMagneticModel.nMax);
        MagneticResults MagneticResultsSph = WorldMagneticModel.summation(LegendreFunction2, timedMagneticModel, SphVariables, coordSpherical);
        MagneticResults MagneticResultsSphVar = WorldMagneticModel.secVarSummation(LegendreFunction2, timedMagneticModel, SphVariables, coordSpherical);
        MagneticResults MagneticResultsGeo = WorldMagneticModel.rotateMagneticVector(coordSpherical, coordGeodetic, MagneticResultsSph);
        MagneticResults MagneticResultsGeoVar = WorldMagneticModel.rotateMagneticVector(coordSpherical, coordGeodetic, MagneticResultsSphVar);
        GeoMagneticElements GeoMagneticElements2 = WorldMagneticModel.calculateGeoMagneticElements(MagneticResultsGeo);
        WorldMagneticModel.calculateSecularVariationElements(MagneticResultsGeoVar, GeoMagneticElements2);
        WorldMagneticModel.calculateGridVariation(coordGeodetic, GeoMagneticElements2);
        return GeoMagneticElements2;
    }

    private static DirectPosition to4326(DirectPosition source) throws FactoryException, TransformException {
        CoordinateReferenceSystem sourceCrs = source.getCoordinateReferenceSystem();
        if (sourceCrs == null) {
            throw new IllegalArgumentException("Cannot identify coordinate system of given point. Please set the point CRS.");
        }
        CoordinateOperation op = CRS.findOperation(sourceCrs, CommonCRS.WGS84.geographic3D(), null);
        GeneralDirectPosition geo = new GeneralDirectPosition(CommonCRS.WGS84.geographic3D());
        return op.getMathTransform().transform(source, geo);
    }

    private static DirectPosition toSpherical(DirectPosition source) throws FactoryException, TransformException {
        CoordinateOperation toGeoCentric = CRS.findOperation(source.getCoordinateReferenceSystem(), CommonCRS.WGS84.geocentric(), null);
        CoordinateOperation toSpheric = CRS.findOperation(CommonCRS.WGS84.geocentric(), CommonCRS.WGS84.spherical(), null);
        GeneralDirectPosition spheric = new GeneralDirectPosition(CommonCRS.WGS84.spherical());
        return MathTransforms.concatenate(toGeoCentric.getMathTransform(), toSpheric.getMathTransform()).transform(source, spheric);
    }

    private static SphericalHarmonicVariables ComputeSphericalHarmonicVariables(DirectPosition coordSpherical, int nMax) {
        SphericalHarmonicVariables sphVariables = new SphericalHarmonicVariables(nMax);
        double cos_lambda = Math.cos(Math.toRadians(coordSpherical.getOrdinate(1)));
        double sin_lambda = Math.sin(Math.toRadians(coordSpherical.getOrdinate(1)));
        double radiusRatio = 6371.2 / (coordSpherical.getOrdinate(2) / 1000.0);
        sphVariables.RelativeRadiusPower[0] = Math.pow(radiusRatio, 2.0);
        for (int n = 1; n <= nMax; ++n) {
            sphVariables.RelativeRadiusPower[n] = sphVariables.RelativeRadiusPower[n - 1] * radiusRatio;
        }
        sphVariables.cos_mlambda[0] = 1.0;
        sphVariables.sin_mlambda[0] = 0.0;
        sphVariables.cos_mlambda[1] = cos_lambda;
        sphVariables.sin_mlambda[1] = sin_lambda;
        for (int m4 = 2; m4 <= nMax; ++m4) {
            sphVariables.cos_mlambda[m4] = sphVariables.cos_mlambda[m4 - 1] * cos_lambda - sphVariables.sin_mlambda[m4 - 1] * sin_lambda;
            sphVariables.sin_mlambda[m4] = sphVariables.cos_mlambda[m4 - 1] * sin_lambda + sphVariables.sin_mlambda[m4 - 1] * cos_lambda;
        }
        return sphVariables;
    }

    private static LegendreFunction computeLegendreFunction(DirectPosition coordSpherical, int nMax) {
        double sin_phi = Math.sin(Math.toRadians(coordSpherical.getOrdinate(0)));
        return nMax <= 16 || 1.0 - Math.abs(sin_phi) < 1.0E-10 ? WorldMagneticModel.computePcupLow(sin_phi, nMax) : WorldMagneticModel.computePcupHigh(sin_phi, nMax);
    }

    private static LegendreFunction computePcupLow(double x, int nMax) {
        int index;
        int m4;
        int n;
        int NumTerms = (nMax + 1) * (nMax + 2) / 2;
        LegendreFunction legendreFunction = new LegendreFunction(NumTerms);
        legendreFunction.Pcup[0] = 1.0;
        legendreFunction.dPcup[0] = 0.0;
        double z = Math.sqrt((1.0 - x) * (1.0 + x));
        double[] schmidtQuasiNorm = new double[NumTerms + 1];
        for (n = 1; n <= nMax; ++n) {
            for (m4 = 0; m4 <= n; ++m4) {
                int index1;
                index = n * (n + 1) / 2 + m4;
                if (n == m4) {
                    index1 = (n - 1) * n / 2 + m4 - 1;
                    legendreFunction.Pcup[index] = z * legendreFunction.Pcup[index1];
                    legendreFunction.dPcup[index] = z * legendreFunction.dPcup[index1] + x * legendreFunction.Pcup[index1];
                    continue;
                }
                if (n == 1 && m4 == 0) {
                    index1 = (n - 1) * n / 2 + m4;
                    legendreFunction.Pcup[index] = x * legendreFunction.Pcup[index1];
                    legendreFunction.dPcup[index] = x * legendreFunction.dPcup[index1] - z * legendreFunction.Pcup[index1];
                    continue;
                }
                if (n <= 1 || n == m4) continue;
                index1 = (n - 2) * (n - 1) / 2 + m4;
                int index2 = (n - 1) * n / 2 + m4;
                if (m4 > n - 2) {
                    legendreFunction.Pcup[index] = x * legendreFunction.Pcup[index2];
                    legendreFunction.dPcup[index] = x * legendreFunction.dPcup[index2] - z * legendreFunction.Pcup[index2];
                    continue;
                }
                double k = (double)((n - 1) * (n - 1) - m4 * m4) / (double)((2 * n - 1) * (2 * n - 3));
                legendreFunction.Pcup[index] = x * legendreFunction.Pcup[index2] - k * legendreFunction.Pcup[index1];
                legendreFunction.dPcup[index] = x * legendreFunction.dPcup[index2] - z * legendreFunction.Pcup[index2] - k * legendreFunction.dPcup[index1];
            }
        }
        schmidtQuasiNorm[0] = 1.0;
        for (n = 1; n <= nMax; ++n) {
            int index2 = n * (n + 1) / 2;
            int index1 = (n - 1) * n / 2;
            schmidtQuasiNorm[index2] = schmidtQuasiNorm[index1] * (double)(2 * n - 1) / (double)n;
            for (int m5 = 1; m5 <= n; ++m5) {
                index2 = n * (n + 1) / 2 + m5;
                index1 = n * (n + 1) / 2 + m5 - 1;
                schmidtQuasiNorm[index2] = schmidtQuasiNorm[index1] * Math.sqrt((double)((n - m5 + 1) * (m5 == 1 ? 2 : 1)) / (double)(n + m5));
            }
        }
        for (n = 1; n <= nMax; ++n) {
            for (m4 = 0; m4 <= n; ++m4) {
                index = n * (n + 1) / 2 + m4;
                legendreFunction.Pcup[index] = legendreFunction.Pcup[index] * schmidtQuasiNorm[index];
                legendreFunction.dPcup[index] = -legendreFunction.dPcup[index] * schmidtQuasiNorm[index];
            }
        }
        return legendreFunction;
    }

    private static LegendreFunction computePcupHigh(double x, int nMax) {
        double pm1;
        if (Math.abs(x) == 1.0) {
            throw new IllegalArgumentException("Error in PcupHigh: derivative cannot be calculated at poles");
        }
        if (nMax == 0) {
            throw new IllegalArgumentException("Error in PcupHigh: nMax must be > 0");
        }
        int NumTerms = (nMax + 1) * (nMax + 2) / 2;
        LegendreFunction legendreFunction = new LegendreFunction(NumTerms);
        double[] f1 = new double[NumTerms + 1];
        double[] f2 = new double[NumTerms + 1];
        double[] PreSqr = new double[NumTerms + 1];
        double scalef = 1.0E-280;
        for (int n = 0; n <= 2 * nMax + 1; ++n) {
            PreSqr[n] = Math.sqrt(n);
        }
        int k = 2;
        for (int n = 2; n <= nMax; ++n) {
            f1[++k] = (double)(2 * n - 1) / (double)n;
            f2[k] = (double)(n - 1) / (double)n;
            for (int m4 = 1; m4 <= n - 2; ++m4) {
                f1[++k] = (double)(2 * n - 1) / PreSqr[n + m4] / PreSqr[n - m4];
                f2[k] = PreSqr[n - m4 - 1] * PreSqr[n + m4 - 1] / PreSqr[n + m4] / PreSqr[n - m4];
            }
            k += 2;
        }
        double z = Math.sqrt((1.0 - x) * (1.0 + x));
        double pm2 = 1.0;
        legendreFunction.Pcup[0] = 1.0;
        legendreFunction.dPcup[0] = 0.0;
        legendreFunction.Pcup[1] = pm1 = x;
        legendreFunction.dPcup[1] = z;
        k = 1;
        for (int n = 2; n <= nMax; ++n) {
            double plm;
            legendreFunction.Pcup[k += n] = plm = f1[k] * x * pm1 - f2[k] * pm2;
            legendreFunction.dPcup[k] = (double)n * (pm1 - x * plm) / z;
            pm2 = pm1;
            pm1 = plm;
        }
        double pmm = PreSqr[2] * 1.0E-280;
        double rescalem = 1.0E280;
        int kstart = 0;
        for (int m5 = 1; m5 <= nMax - 1; ++m5) {
            kstart = kstart + m5 + 1;
            pmm = pmm * PreSqr[2 * m5 + 1] / PreSqr[2 * m5];
            legendreFunction.Pcup[kstart] = pmm * (rescalem *= z) / PreSqr[2 * m5 + 1];
            legendreFunction.dPcup[kstart] = -((double)m5 * x * legendreFunction.Pcup[kstart] / z);
            pm2 = pmm / PreSqr[2 * m5 + 1];
            k = kstart + m5 + 1;
            pm1 = x * PreSqr[2 * m5 + 1] * pm2;
            legendreFunction.Pcup[k] = pm1 * rescalem;
            legendreFunction.dPcup[k] = (pm2 * rescalem * PreSqr[2 * m5 + 1] - x * (double)(m5 + 1) * legendreFunction.Pcup[k]) / z;
            for (int n = m5 + 2; n <= nMax; ++n) {
                double plm = x * f1[k += n] * pm1 - f2[k] * pm2;
                legendreFunction.Pcup[k] = plm * rescalem;
                legendreFunction.dPcup[k] = (PreSqr[n + m5] * PreSqr[n - m5] * (pm1 * rescalem) - (double)n * x * legendreFunction.Pcup[k]) / z;
                pm2 = pm1;
                pm1 = plm;
            }
        }
        kstart = kstart + nMax + 1;
        legendreFunction.Pcup[kstart] = (pmm /= PreSqr[2 * nMax]) * (rescalem *= z);
        legendreFunction.dPcup[kstart] = -((double)nMax) * x * legendreFunction.Pcup[kstart] / z;
        return legendreFunction;
    }

    private static MagneticResults summation(LegendreFunction legendreFunction, MagneticModel magneticModel, SphericalHarmonicVariables sphVariables, DirectPosition coordSpherical) {
        MagneticResults magneticResults = new MagneticResults();
        for (int n = 1; n <= magneticModel.nMax; ++n) {
            for (int m4 = 0; m4 <= n; ++m4) {
                int index = n * (n + 1) / 2 + m4;
                magneticResults.Bz -= sphVariables.RelativeRadiusPower[n] * (magneticModel.Main_Field_Coeff_G[index] * sphVariables.cos_mlambda[m4] + magneticModel.Main_Field_Coeff_H[index] * sphVariables.sin_mlambda[m4]) * (double)(n + 1) * legendreFunction.Pcup[index];
                magneticResults.By += sphVariables.RelativeRadiusPower[n] * (magneticModel.Main_Field_Coeff_G[index] * sphVariables.sin_mlambda[m4] - magneticModel.Main_Field_Coeff_H[index] * sphVariables.cos_mlambda[m4]) * (double)m4 * legendreFunction.Pcup[index];
                magneticResults.Bx -= sphVariables.RelativeRadiusPower[n] * (magneticModel.Main_Field_Coeff_G[index] * sphVariables.cos_mlambda[m4] + magneticModel.Main_Field_Coeff_H[index] * sphVariables.sin_mlambda[m4]) * legendreFunction.dPcup[index];
            }
        }
        double cos_phi = Math.cos(Math.toRadians(coordSpherical.getOrdinate(0)));
        if (Math.abs(cos_phi) > 1.0E-10) {
            magneticResults.By /= cos_phi;
        } else {
            WorldMagneticModel.summationSpecial(magneticModel, sphVariables, coordSpherical, magneticResults);
        }
        return magneticResults;
    }

    private static void summationSpecial(MagneticModel magneticModel, SphericalHarmonicVariables sphVariables, DirectPosition coordSpherical, MagneticResults magneticResults) {
        double[] PcupS = new double[magneticModel.nMax + 1];
        PcupS[0] = 1.0;
        double schmidtQuasiNorm1 = 1.0;
        magneticResults.By = 0.0;
        double sin_phi = Math.sin(Math.toRadians(coordSpherical.getOrdinate(0)));
        for (int n = 1; n <= magneticModel.nMax; ++n) {
            int index = n * (n + 1) / 2 + 1;
            double schmidtQuasiNorm2 = schmidtQuasiNorm1 * (double)(2 * n - 1) / (double)n;
            double schmidtQuasiNorm3 = schmidtQuasiNorm2 * Math.sqrt((double)(n * 2) / (double)(n + 1));
            schmidtQuasiNorm1 = schmidtQuasiNorm2;
            if (n == 1) {
                PcupS[n] = PcupS[n - 1];
            } else {
                double k = (double)((n - 1) * (n - 1) - 1) / (double)((2 * n - 1) * (2 * n - 3));
                PcupS[n] = sin_phi * PcupS[n - 1] - k * PcupS[n - 2];
            }
            magneticResults.By += sphVariables.RelativeRadiusPower[n] * (magneticModel.Main_Field_Coeff_G[index] * sphVariables.sin_mlambda[1] - magneticModel.Main_Field_Coeff_H[index] * sphVariables.cos_mlambda[1]) * PcupS[n] * schmidtQuasiNorm3;
        }
    }

    private static MagneticResults secVarSummation(LegendreFunction legendreFunction, MagneticModel magneticModel, SphericalHarmonicVariables sphVariables, DirectPosition coordSpherical) {
        magneticModel.SecularVariationUsed = true;
        MagneticResults magneticResults = new MagneticResults();
        for (int n = 1; n <= magneticModel.nMaxSecVar; ++n) {
            for (int m4 = 0; m4 <= n; ++m4) {
                int index = n * (n + 1) / 2 + m4;
                magneticResults.Bz -= sphVariables.RelativeRadiusPower[n] * (magneticModel.Secular_Var_Coeff_G[index] * sphVariables.cos_mlambda[m4] + magneticModel.Secular_Var_Coeff_H[index] * sphVariables.sin_mlambda[m4]) * (double)(n + 1) * legendreFunction.Pcup[index];
                magneticResults.By += sphVariables.RelativeRadiusPower[n] * (magneticModel.Secular_Var_Coeff_G[index] * sphVariables.sin_mlambda[m4] - magneticModel.Secular_Var_Coeff_H[index] * sphVariables.cos_mlambda[m4]) * (double)m4 * legendreFunction.Pcup[index];
                magneticResults.Bx -= sphVariables.RelativeRadiusPower[n] * (magneticModel.Secular_Var_Coeff_G[index] * sphVariables.cos_mlambda[m4] + magneticModel.Secular_Var_Coeff_H[index] * sphVariables.sin_mlambda[m4]) * legendreFunction.dPcup[index];
            }
        }
        double cos_phi = Math.cos(Math.toRadians(coordSpherical.getOrdinate(0)));
        if (Math.abs(cos_phi) > 1.0E-10) {
            magneticResults.By /= cos_phi;
        } else {
            WorldMagneticModel.secVarSummationSpecial(magneticModel, sphVariables, coordSpherical, magneticResults);
        }
        return magneticResults;
    }

    private static void secVarSummationSpecial(MagneticModel magneticModel, SphericalHarmonicVariables sphVariables, DirectPosition coordSpherical, MagneticResults magneticResults) {
        double[] PcupS = new double[magneticModel.nMaxSecVar + 1];
        PcupS[0] = 1.0;
        double schmidtQuasiNorm1 = 1.0;
        magneticResults.By = 0.0;
        double sin_phi = Math.sin(Math.toRadians(coordSpherical.getOrdinate(0)));
        for (int n = 1; n <= magneticModel.nMaxSecVar; ++n) {
            int index = n * (n + 1) / 2 + 1;
            double schmidtQuasiNorm2 = schmidtQuasiNorm1 * (double)(2 * n - 1) / (double)n;
            double schmidtQuasiNorm3 = schmidtQuasiNorm2 * Math.sqrt((double)(n * 2) / (double)(n + 1));
            schmidtQuasiNorm1 = schmidtQuasiNorm2;
            if (n == 1) {
                PcupS[n] = PcupS[n - 1];
            } else {
                double k = (double)((n - 1) * (n - 1) - 1) / (double)((2 * n - 1) * (2 * n - 3));
                PcupS[n] = sin_phi * PcupS[n - 1] - k * PcupS[n - 2];
            }
            magneticResults.By += sphVariables.RelativeRadiusPower[n] * (magneticModel.Secular_Var_Coeff_G[index] * sphVariables.sin_mlambda[1] - magneticModel.Secular_Var_Coeff_H[index] * sphVariables.cos_mlambda[1]) * PcupS[n] * schmidtQuasiNorm3;
        }
    }

    private static MagneticResults rotateMagneticVector(DirectPosition coordSpherical, DirectPosition coordGeodetic, MagneticResults magneticResultsSph) {
        MagneticResults MagneticResultsGeo = new MagneticResults();
        double Psi = Math.toRadians(coordSpherical.getOrdinate(0) - coordGeodetic.getOrdinate(0));
        MagneticResultsGeo.Bz = magneticResultsSph.Bx * Math.sin(Psi) + magneticResultsSph.Bz * Math.cos(Psi);
        MagneticResultsGeo.Bx = magneticResultsSph.Bx * Math.cos(Psi) - magneticResultsSph.Bz * Math.sin(Psi);
        MagneticResultsGeo.By = magneticResultsSph.By;
        return MagneticResultsGeo;
    }

    private static GeoMagneticElements calculateGeoMagneticElements(MagneticResults magneticResultsGeo) {
        GeoMagneticElements geoMagneticElements = new GeoMagneticElements();
        geoMagneticElements.X = magneticResultsGeo.Bx;
        geoMagneticElements.Y = magneticResultsGeo.By;
        geoMagneticElements.Z = magneticResultsGeo.Bz;
        geoMagneticElements.H = Math.sqrt(magneticResultsGeo.Bx * magneticResultsGeo.Bx + magneticResultsGeo.By * magneticResultsGeo.By);
        geoMagneticElements.F = Math.sqrt(geoMagneticElements.H * geoMagneticElements.H + magneticResultsGeo.Bz * magneticResultsGeo.Bz);
        geoMagneticElements.Decl = Math.toDegrees(Math.atan2(geoMagneticElements.Y, geoMagneticElements.X));
        geoMagneticElements.Incl = Math.toDegrees(Math.atan2(geoMagneticElements.Z, geoMagneticElements.H));
        return geoMagneticElements;
    }

    private static void calculateSecularVariationElements(MagneticResults magneticVariation, GeoMagneticElements magneticElements) {
        magneticElements.Xdot = magneticVariation.Bx;
        magneticElements.Ydot = magneticVariation.By;
        magneticElements.Zdot = magneticVariation.Bz;
        magneticElements.Hdot = (magneticElements.X * magneticElements.Xdot + magneticElements.Y * magneticElements.Ydot) / magneticElements.H;
        magneticElements.Fdot = (magneticElements.X * magneticElements.Xdot + magneticElements.Y * magneticElements.Ydot + magneticElements.Z * magneticElements.Zdot) / magneticElements.F;
        magneticElements.Decldot = 57.29577951308232 * (magneticElements.X * magneticElements.Ydot - magneticElements.Y * magneticElements.Xdot) / (magneticElements.H * magneticElements.H);
        magneticElements.Incldot = 57.29577951308232 * (magneticElements.H * magneticElements.Zdot - magneticElements.Z * magneticElements.Hdot) / (magneticElements.F * magneticElements.F);
        magneticElements.GVdot = magneticElements.Decldot;
    }

    private static void calculateGridVariation(DirectPosition location, GeoMagneticElements elements) {
        if (location.getOrdinate(0) >= 55.0) {
            elements.GV = elements.Decl - location.getOrdinate(1);
        } else if (location.getOrdinate(0) <= -55.0) {
            elements.GV = elements.Decl + location.getOrdinate(1);
        } else {
            UTMParameters utmParameters = WorldMagneticModel.getTransverseMercator(location);
            elements.GV = elements.Decl - utmParameters.ConvergenceOfMeridians;
        }
    }

    private static UTMParameters getTransverseMercator(DirectPosition DirectPosition2) {
        double Lambda = Math.toRadians(DirectPosition2.getOrdinate(1));
        double Phi = Math.toRadians(DirectPosition2.getOrdinate(0));
        UTMParameters utmParameters = WorldMagneticModel.getUTMParameters(Phi, Lambda);
        double K0 = 0.9996;
        double falseE = 500000.0;
        double falseN = 0.0;
        if (utmParameters.HemiSphere == 'n' || utmParameters.HemiSphere == 'N') {
            falseN = 0.0;
        }
        if (utmParameters.HemiSphere == 's' || utmParameters.HemiSphere == 'S') {
            falseN = 1.0E7;
        }
        double Eps = 0.0818191908426215;
        double Epssq = 0.006694379990141317;
        double K0R4 = 6367449.145823415;
        double K0R4oa = 0.9983242984312528;
        double[] Acoeff = new double[]{8.377318206244697E-4, 7.608527773572486E-7, 1.1976455032424912E-9, 2.429170680397089E-12, 5.711818370428014E-15, 1.4799979313796617E-17, 4.1076241093707153E-20, 1.210785038922577E-22};
        boolean XYonly = false;
        WorldMagneticModel.TMfwd4(0.0818191908426215, 0.006694379990141317, 6367449.145823415, 0.9983242984312528, Acoeff, Math.toRadians(utmParameters.CentralMeridian), 0.9996, falseE, falseN, 0, Lambda, Phi, utmParameters);
        return utmParameters;
    }

    private static UTMParameters getUTMParameters(double latitude, double longitude) {
        if (latitude < Math.toRadians(-80.5) || latitude > Math.toRadians(84.5)) {
            throw new IndexOutOfBoundsException("Latitude out of range");
        }
        if (longitude < -Math.PI || longitude > Math.PI * 2) {
            throw new IndexOutOfBoundsException("Longitude out of range");
        }
        if (longitude < 0.0) {
            longitude += 6.283185307279586;
        }
        long Lat_Degrees = (long)(latitude * 180.0 / Math.PI);
        long Long_Degrees = (long)(longitude * 180.0 / Math.PI);
        long temp_zone = longitude < Math.PI ? (long)(31.0 + longitude * 180.0 / Math.PI / 6.0) : (long)(longitude * 180.0 / Math.PI / 6.0 - 29.0);
        if (temp_zone > 60L) {
            temp_zone = 1L;
        }
        if (Lat_Degrees > 55L && Lat_Degrees < 64L && Long_Degrees > -1L && Long_Degrees < 3L) {
            temp_zone = 31L;
        }
        if (Lat_Degrees > 55L && Lat_Degrees < 64L && Long_Degrees > 2L && Long_Degrees < 12L) {
            temp_zone = 32L;
        }
        if (Lat_Degrees > 71L && Long_Degrees > -1L && Long_Degrees < 9L) {
            temp_zone = 31L;
        }
        if (Lat_Degrees > 71L && Long_Degrees > 8L && Long_Degrees < 21L) {
            temp_zone = 33L;
        }
        if (Lat_Degrees > 71L && Long_Degrees > 20L && Long_Degrees < 33L) {
            temp_zone = 35L;
        }
        if (Lat_Degrees > 71L && Long_Degrees > 32L && Long_Degrees < 42L) {
            temp_zone = 37L;
        }
        UTMParameters utmParameters = new UTMParameters();
        utmParameters.CentralMeridian = temp_zone >= 31L ? 6.0 * (double)temp_zone - 183.0 : 6.0 * (double)temp_zone + 177.0;
        utmParameters.Zone = (int)temp_zone;
        utmParameters.HemiSphere = latitude < 0.0 ? (char)83 : (char)78;
        return utmParameters;
    }

    private static void TMfwd4(double Eps, double Epssq, double K0R4, double K0R4oa, double[] Acoeff, double Lam0, double K0, double falseE, double falseN, int XYonly, double Lambda, double Phi, UTMParameters utmParameters) {
        double Lam = Lambda - Lam0;
        double CLam = Math.cos(Lam);
        double SLam = Math.sin(Lam);
        double CPhi = Math.cos(Phi);
        double SPhi = Math.sin(Phi);
        double P = Math.exp(Eps * WorldMagneticModel.ATanH(Eps * SPhi));
        double part1 = (1.0 + SPhi) / P;
        double part2 = (1.0 - SPhi) * P;
        double denom = 1.0 / (part1 + part2);
        double CChi = 2.0 * CPhi * denom;
        double SChi = (part1 - part2) * denom;
        double T = CChi * SLam;
        double U = WorldMagneticModel.ATanH(T);
        double V = Math.atan2(SChi, CChi * CLam);
        double Tsq = T * T;
        double denom2 = 1.0 / (1.0 - Tsq);
        double c2u = (1.0 + Tsq) * denom2;
        double s2u = 2.0 * T * denom2;
        double c2v = (-1.0 + CChi * CChi * (1.0 + CLam * CLam)) * denom2;
        double s2v = 2.0 * CLam * CChi * SChi * denom2;
        double c4u = 1.0 + 2.0 * s2u * s2u;
        double s4u = 2.0 * c2u * s2u;
        double c4v = 1.0 - 2.0 * s2v * s2v;
        double s4v = 2.0 * c2v * s2v;
        double c6u = c4u * c2u + s4u * s2u;
        double s6u = s4u * c2u + c4u * s2u;
        double c6v = c4v * c2v - s4v * s2v;
        double s6v = s4v * c2v + c4v * s2v;
        double c8u = 1.0 + 2.0 * s4u * s4u;
        double s8u = 2.0 * c4u * s4u;
        double c8v = 1.0 - 2.0 * s4v * s4v;
        double s8v = 2.0 * c4v * s4v;
        double Xstar = Acoeff[3] * s8u * c8v;
        Xstar += Acoeff[2] * s6u * c6v;
        Xstar += Acoeff[1] * s4u * c4v;
        Xstar += Acoeff[0] * s2u * c2v;
        double Ystar = Acoeff[3] * c8u * s8v;
        Ystar += Acoeff[2] * c6u * s6v;
        Ystar += Acoeff[1] * c4u * s4v;
        Ystar += Acoeff[0] * c2u * s2v;
        utmParameters.Easting = K0R4 * (Xstar += U) + falseE;
        utmParameters.Northing = K0R4 * (Ystar += V) + falseN;
        if (XYonly == 1) {
            utmParameters.PointScale = K0;
            utmParameters.ConvergenceOfMeridians = 0.0;
        } else {
            double sig1 = 8.0 * Acoeff[3] * c8u * c8v;
            sig1 += 6.0 * Acoeff[2] * c6u * c6v;
            sig1 += 4.0 * Acoeff[1] * c4u * c4v;
            sig1 += 2.0 * Acoeff[0] * c2u * c2v;
            double sig2 = 8.0 * Acoeff[3] * s8u * s8v;
            sig2 += 6.0 * Acoeff[2] * s6u * s6v;
            sig2 += 4.0 * Acoeff[1] * s4u * s4v;
            double comroo = Math.sqrt((1.0 - Epssq * SPhi * SPhi) * denom2 * ((sig1 += 1.0) * sig1 + (sig2 += 2.0 * Acoeff[0] * s2u * s2v) * sig2));
            utmParameters.PointScale = K0R4oa * 2.0 * denom * comroo;
            utmParameters.ConvergenceOfMeridians = Math.atan2(SChi * SLam, CLam) + Math.atan2(sig2, sig1);
        }
    }

    private static double ATanH(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }
}

