/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.DoubleStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.xml.MarshallerPool;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.geometry.jts.JTSEnvelope2D;
import org.geotoolkit.gml.GeometrytoJTS;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.GMLMarshallerPool;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extents {
    private static final String CRSREF_OWS = "crs";
    private static final String CRSREF_GML = "srsName";
    private static final String GML_NS = "http://www.opengis.net/gml/3.2";
    private static final GeometryFactory JTS_GEOM_FACTORY = new GeometryFactory();

    private Extents() {
    }

    public static org.opengis.geometry.Envelope calculateEnvelope(NodeList geomNodes) throws JAXBException {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = GMLMarshallerPool.getInstance();
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        Envelope envelope = new Envelope();
        CoordinateReferenceSystem crs = null;
        for (int i = 0; i < geomNodes.getLength(); ++i) {
            Geometry jtsGeom;
            JAXBElement result;
            AbstractGeometry gmlGeom;
            String srsName;
            Element geom = (Element)geomNodes.item(i);
            if (geom.getAttribute(CRSREF_GML).isEmpty()) {
                GmlUtils.findCRSReference(geom);
            }
            if (geom.getLocalName().startsWith("Multi")) {
                GmlUtils.setSrsNameOnCollectionMembers(geom);
            }
            if (geom.getLocalName().equals("Curve") || geom.getLocalName().equals("Surface")) {
                geom = GmlUtils.convertToMultiType(geomNodes.item(i));
            }
            if ((srsName = (gmlGeom = (AbstractGeometry)(result = (JAXBElement)unmarshaller.unmarshal(geom)).getValue()).getSrsName()).startsWith("http")) {
                gmlGeom.setSrsName(GeodesyUtils.convertSRSNameToURN(srsName));
            }
            crs = gmlGeom.getCoordinateReferenceSystem(false);
            try {
                jtsGeom = GeometrytoJTS.toJTS(gmlGeom);
            }
            catch (FactoryException e) {
                throw new RuntimeException(String.format("Failed to create JTS geometry from GML geometry: %s \nCause: %s", gmlGeom.toString(), e.getMessage()));
            }
            envelope.expandToInclude(jtsGeom.getEnvelopeInternal());
        }
        return new JTSEnvelope2D(envelope, crs);
    }

    public static org.opengis.geometry.Envelope calculateEnvelopeUsingSingleGeometry(NodeList geomNodes) throws JAXBException {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = GMLMarshallerPool.getInstance();
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        Envelope envelope = new Envelope();
        CoordinateReferenceSystem crs = null;
        for (int i = 0; i < 1; ++i) {
            Geometry jtsGeom;
            JAXBElement result;
            AbstractGeometry gmlGeom;
            String srsName;
            Node geomNode;
            Element geom = (Element)geomNodes.item(i);
            if (geom.getAttribute(CRSREF_GML).isEmpty()) {
                GmlUtils.findCRSReference(geom);
            }
            if (geom.getLocalName().startsWith("Multi")) {
                GmlUtils.setSrsNameOnCollectionMembers(geom);
            }
            if (geom.getLocalName().equals("Curve") || geom.getLocalName().equals("Surface")) {
                geom = GmlUtils.convertToMultiType(geomNodes.item(i));
            }
            if (GmlUtils.checkForAbstractSurfacePatchTypes(geomNode = geomNodes.item(i))) {
                geom = GmlUtils.handleAbstractSurfacePatch(geomNode);
            }
            if ((srsName = (gmlGeom = (AbstractGeometry)(result = (JAXBElement)unmarshaller.unmarshal(geom)).getValue()).getSrsName()).startsWith("http")) {
                gmlGeom.setSrsName(GeodesyUtils.convertSRSNameToURN(srsName));
            }
            crs = gmlGeom.getCoordinateReferenceSystem(false);
            try {
                jtsGeom = GeometrytoJTS.toJTS(gmlGeom);
            }
            catch (FactoryException e) {
                throw new RuntimeException(String.format("Failed to create JTS geometry from GML geometry: %s \nCause: %s", gmlGeom.toString(), e.getMessage()));
            }
            envelope.expandToInclude(jtsGeom.getEnvelopeInternal());
        }
        return new JTSEnvelope2D(envelope, crs);
    }

    public static Document envelopeAsGML(org.opengis.geometry.Envelope envelope) {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element gmlEnv = doc.createElementNS(GML_NS, "gml:Envelope");
        doc.appendChild(gmlEnv);
        gmlEnv.setAttribute(CRSREF_GML, GeodesyUtils.getCRSIdentifier(envelope.getCoordinateReferenceSystem()));
        NumberFormat numFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        DecimalFormat decFormat = (DecimalFormat)DecimalFormat.class.cast(numFormat);
        decFormat.applyPattern("#.##");
        decFormat.setRoundingMode(RoundingMode.DOWN);
        StringBuffer lowerCoord = new StringBuffer();
        StringBuffer upperCoord = new StringBuffer();
        for (int i = 0; i < envelope.getDimension(); ++i) {
            lowerCoord.append(decFormat.format(envelope.getMinimum(i)));
            upperCoord.append(decFormat.format(envelope.getMaximum(i)));
            if (i >= envelope.getDimension() - 1) continue;
            lowerCoord.append(' ');
            upperCoord.append(' ');
        }
        Element lowerCorner = doc.createElementNS(GML_NS, "gml:lowerCorner");
        lowerCorner.setTextContent(lowerCoord.toString());
        gmlEnv.appendChild(lowerCorner);
        Element upperCorner = doc.createElementNS(GML_NS, "gml:upperCorner");
        upperCorner.setTextContent(upperCoord.toString());
        gmlEnv.appendChild(upperCorner);
        return doc;
    }

    public static Polygon envelopeAsPolygon(org.opengis.geometry.Envelope envelope) {
        DirectPosition lowerCorner = envelope.getLowerCorner();
        DirectPosition upperCorner = envelope.getUpperCorner();
        LinearRing ring = JTS_GEOM_FACTORY.createLinearRing(new Coordinate[]{new Coordinate(lowerCorner.getOrdinate(0), lowerCorner.getOrdinate(1)), new Coordinate(upperCorner.getOrdinate(0), lowerCorner.getOrdinate(1)), new Coordinate(upperCorner.getOrdinate(0), upperCorner.getOrdinate(1)), new Coordinate(lowerCorner.getOrdinate(0), upperCorner.getOrdinate(1)), new Coordinate(lowerCorner.getOrdinate(0), lowerCorner.getOrdinate(1))});
        Polygon polygon = JTS_GEOM_FACTORY.createPolygon(ring);
        JTS.setCRS(polygon, envelope.getCoordinateReferenceSystem());
        return polygon;
    }

    public static org.opengis.geometry.Envelope coalesceBoundingBoxes(List<Node> bboxNodes) throws FactoryException, TransformException {
        GeneralEnvelope totalExtent = null;
        for (Node bboxNode : bboxNodes) {
            org.opengis.geometry.Envelope nextEnv = Extents.createEnvelope(bboxNode);
            if (null == totalExtent) {
                totalExtent = (GeneralEnvelope)nextEnv;
                continue;
            }
            CoordinateReferenceSystem crs = nextEnv.getCoordinateReferenceSystem();
            if (!crs.equals(totalExtent.getCoordinateReferenceSystem())) {
                nextEnv = Envelopes.transform(nextEnv, totalExtent.getCoordinateReferenceSystem());
            }
            totalExtent.add(nextEnv);
        }
        return totalExtent;
    }

    public static org.opengis.geometry.Envelope createEnvelope(Node envelopeNode) throws FactoryException {
        String crsRef;
        Element envElem = Document.class.isInstance(envelopeNode) ? ((Document)Document.class.cast(envelopeNode)).getDocumentElement() : (Element)Element.class.cast(envelopeNode);
        CoordinateReferenceSystem crs = null;
        String string = crsRef = envElem.hasAttribute(CRSREF_OWS) ? envElem.getAttribute(CRSREF_OWS) : envElem.getAttribute(CRSREF_GML);
        if (crsRef.isEmpty() || crsRef.equals("urn:ogc:def:crs:OGC:1.3:CRS84")) {
            crs = CommonCRS.defaultGeographic();
        } else {
            String id = GeodesyUtils.getAbbreviatedCRSIdentifier(crsRef);
            crs = CRS.forCode(id);
        }
        GeneralEnvelope env = new GeneralEnvelope(crs);
        String namespaceURI = envElem.getNamespaceURI();
        String lowerCornerName = namespaceURI.equals(GML_NS) ? "lowerCorner" : "LowerCorner";
        String[] lowerCoords = envElem.getElementsByTagNameNS(namespaceURI, lowerCornerName).item(0).getTextContent().trim().split("\\s");
        String upperCornerName = namespaceURI.equals(GML_NS) ? "upperCorner" : "UpperCorner";
        String[] upperCoords = envElem.getElementsByTagNameNS(namespaceURI, upperCornerName).item(0).getTextContent().trim().split("\\s");
        int dim = lowerCoords.length;
        double[] coords = new double[dim * 2];
        for (int i = 0; i < dim; ++i) {
            coords[i] = Double.parseDouble(lowerCoords[i]);
            coords[i + dim] = Double.parseDouble(upperCoords[i]);
        }
        env.setEnvelope(coords);
        return env;
    }

    public static String envelopeToString(org.opengis.geometry.Envelope envelope) {
        StringBuilder kvp = new StringBuilder();
        double[] lowerCorner = envelope.getLowerCorner().getCoordinate();
        for (int i = 0; i < lowerCorner.length; ++i) {
            kvp.append(lowerCorner[i]).append(',');
        }
        double[] upperCorner = envelope.getUpperCorner().getCoordinate();
        for (int i = 0; i < upperCorner.length; ++i) {
            kvp.append(upperCorner[i]).append(',');
        }
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (!crs.equals(CommonCRS.defaultGeographic())) {
            kvp.append(GeodesyUtils.getCRSIdentifier(crs));
        } else {
            kvp.deleteCharAt(kvp.lastIndexOf(","));
        }
        return kvp.toString();
    }

    public static org.opengis.geometry.Envelope antipodalEnvelope(org.opengis.geometry.Envelope envelope) {
        GeneralEnvelope antipodalEnv;
        try {
            CoordinateReferenceSystem epsg4326 = CRS.forCode("EPSG:4326");
            antipodalEnv = !envelope.getCoordinateReferenceSystem().equals(epsg4326) ? new GeneralEnvelope(Envelopes.transform(envelope, epsg4326)) : new GeneralEnvelope(envelope);
        }
        catch (TransformException | FactoryException e) {
            throw new RuntimeException(e);
        }
        double[] apLowerCorner = Extents.getAntipode(antipodalEnv.getLowerCorner().getCoordinate());
        double[] apUpperCorner = Extents.getAntipode(antipodalEnv.getUpperCorner().getCoordinate());
        double lower0 = apLowerCorner[0];
        apLowerCorner[0] = apUpperCorner[0];
        apUpperCorner[0] = lower0;
        DoubleStream corners = DoubleStream.concat(Arrays.stream(apLowerCorner), Arrays.stream(apUpperCorner));
        antipodalEnv.setEnvelope(corners.toArray());
        return antipodalEnv;
    }

    public static double[] getAntipode(double[] coordTuple) {
        double[] antipode = Arrays.copyOf(coordTuple, coordTuple.length);
        antipode[0] = -antipode[0];
        antipode[1] = antipode[1] < 0.0 ? antipode[1] + 180.0 : antipode[1] - 180.0;
        return antipode;
    }
}

