/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.gpkg12;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opengis.cite.gpkg12.SuiteAttribute;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeSuite;

public class SuitePreconditions {
    private static final Logger LOGR = Logger.getLogger(SuitePreconditions.class.getName());

    @BeforeSuite
    public void verifySQLiteMajorVersion() throws IOException {
        byte[] headerBytes;
        SuiteAttribute testFileAttr = SuiteAttribute.TEST_SUBJ_FILE;
        Object sutObj = Reporter.getCurrentTestResult().getTestContext().getSuite().getAttribute(testFileAttr.getName());
        Class expectedType = testFileAttr.getType();
        if (null != sutObj && expectedType.isInstance(sutObj)) {
            File dataFile = (File)File.class.cast(sutObj);
            Assert.assertTrue(dataFile.isFile(), String.format("Data file not found at %s", dataFile.getAbsolutePath()));
            headerBytes = new byte[100];
            try (FileInputStream fileInputStream = new FileInputStream(dataFile);){
                fileInputStream.read(headerBytes);
            }
        } else {
            String msg = String.format("Value of test suite attribute '%s' is missing or is not an instance of %s", testFileAttr.getName(), expectedType.getName());
            LOGR.log(Level.SEVERE, msg);
            throw new AssertionError((Object)msg);
        }
        byte[] versionNumBytes = Arrays.copyOfRange(headerBytes, 96, headerBytes.length);
        int version = new BigInteger(versionNumBytes).intValue();
        Assert.assertEquals(version / 1000000, 3, "Unexpected SQLite major version in file header.");
    }
}

