/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.validation;

import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;

public class ValidationError {
    private String message;
    private String diagnostics;
    private final ErrorSeverity severity;
    private ErrorLocator locator;

    public ValidationError(ErrorSeverity severity, String message, int lineNum, int columnNum, String pointer) {
        this(severity, message, null, new ErrorLocator(lineNum, columnNum, pointer));
    }

    public ValidationError(ErrorSeverity severity, String message, String diagnostics, int lineNum, int columnNum, String pointer) {
        this(severity, message, diagnostics, new ErrorLocator(lineNum, columnNum, pointer));
    }

    public ValidationError(ErrorSeverity severity, String message, String diagnostics, ErrorLocator locator) {
        if (null == message || message.length() == 0) {
            message = "No information available.";
        }
        this.severity = severity;
        this.message = message;
        this.diagnostics = diagnostics;
        this.locator = locator;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public ErrorSeverity getSeverity() {
        return this.severity;
    }

    public int getLineNumber() {
        return this.locator.getLineNumber();
    }

    public int getColumnNumber() {
        return this.locator.getColumnNumber();
    }

    public String getPointer() {
        return this.locator.getPointer();
    }

    public String toXml() {
        StringBuilder xmlInfo = new StringBuilder("\n<error>");
        xmlInfo.append("\n  <severity>").append((Object)this.severity).append("</severity>");
        xmlInfo.append("\n  <message>").append(this.escapeXmlString(this.message)).append("</message>");
        if (null != this.diagnostics) {
            xmlInfo.append("\n  <diagnosticInfo>").append(this.escapeXmlString(this.diagnostics)).append("</diagnosticInfo>");
        }
        if (null != this.locator) {
            xmlInfo.append("\n  <location>");
            if (this.getLineNumber() > 0) {
                xmlInfo.append("\n    <lineNumber>").append(this.getLineNumber()).append("</lineNumber>");
            }
            if (this.getColumnNumber() > 0) {
                xmlInfo.append("\n    <columnNumber>").append(this.getColumnNumber()).append("</columnNumber>");
            }
            if (null != this.getPointer()) {
                xmlInfo.append("\n    <pointer>").append(this.getPointer()).append("</pointer>");
            }
            xmlInfo.append("\n  </location>");
        }
        xmlInfo.append("\n</error>");
        return xmlInfo.toString();
    }

    public String toString() {
        StringBuilder errorInfo = new StringBuilder();
        errorInfo.append("\nSeverity: ").append((Object)this.severity);
        errorInfo.append("\nMessage: ").append(this.message);
        if (null != this.diagnostics) {
            errorInfo.append("\nDiagnostic info: ").append(this.diagnostics);
        }
        if (null != this.locator) {
            errorInfo.append("\nLocation: ");
            if (this.getLineNumber() > 0) {
                errorInfo.append(" line=").append(this.getLineNumber());
            }
            if (this.getColumnNumber() > 0) {
                errorInfo.append(" column=").append(this.getColumnNumber());
            }
            if (null != this.getPointer()) {
                errorInfo.append(" pointer=").append(this.getPointer());
            }
        }
        return errorInfo.toString();
    }

    private String escapeXmlString(String str) {
        if (str.indexOf("<") != -1 && str.indexOf(">") != -1) {
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
        }
        return str;
    }
}

