/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.filter;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.opengis.filter.BetweenComparisonOperator;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinarySpatialOperator;
import org.opengis.filter.DistanceOperator;
import org.opengis.filter.Expression;
import org.opengis.filter.Filter;
import org.opengis.filter.LikeOperator;
import org.opengis.filter.Literal;
import org.opengis.filter.LogicalOperator;
import org.opengis.filter.MatchAction;
import org.opengis.filter.NilOperator;
import org.opengis.filter.NullOperator;
import org.opengis.filter.ResourceId;
import org.opengis.filter.SortOrder;
import org.opengis.filter.SortProperty;
import org.opengis.filter.TemporalOperator;
import org.opengis.filter.ValueReference;
import org.opengis.filter.Version;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.geometry.Envelope;
import org.opengis.util.Factory;

public interface FilterFactory<R, G, T>
extends Factory {
    public FilterCapabilities getCapabilities();

    default public ResourceId<R> resourceId(String string) {
        return this.resourceId(string, null, null, null);
    }

    public ResourceId<R> resourceId(String var1, Version var2, Instant var3, Instant var4);

    default public ValueReference<R, ?> property(String string) {
        return this.property(string, Object.class);
    }

    public <V> ValueReference<R, V> property(String var1, Class<V> var2);

    public <V> Literal<R, V> literal(V var1);

    default public BinaryComparisonOperator<R> equal(Expression<R, ?> expression, Expression<R, ?> expression2) {
        return this.equal(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> equal(Expression<R, ?> var1, Expression<R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> notEqual(Expression<R, ?> expression, Expression<R, ?> expression2) {
        return this.notEqual(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> notEqual(Expression<R, ?> var1, Expression<R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> less(Expression<R, ?> expression, Expression<R, ?> expression2) {
        return this.less(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> less(Expression<R, ?> var1, Expression<R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> greater(Expression<R, ?> expression, Expression<R, ?> expression2) {
        return this.greater(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> greater(Expression<R, ?> var1, Expression<R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> lessOrEqual(Expression<R, ?> expression, Expression<R, ?> expression2) {
        return this.lessOrEqual(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> lessOrEqual(Expression<R, ?> var1, Expression<R, ?> var2, boolean var3, MatchAction var4);

    default public BinaryComparisonOperator<R> greaterOrEqual(Expression<R, ?> expression, Expression<R, ?> expression2) {
        return this.greaterOrEqual(Objects.requireNonNull(expression), Objects.requireNonNull(expression2), true, MatchAction.ANY);
    }

    public BinaryComparisonOperator<R> greaterOrEqual(Expression<R, ?> var1, Expression<R, ?> var2, boolean var3, MatchAction var4);

    public BetweenComparisonOperator<R> between(Expression<R, ?> var1, Expression<R, ?> var2, Expression<R, ?> var3);

    default public LikeOperator<R> like(Expression<R, ?> expression, String string) {
        return this.like(Objects.requireNonNull(expression), Objects.requireNonNull(string), '%', '_', '\\', true);
    }

    public LikeOperator<R> like(Expression<R, ?> var1, String var2, char var3, char var4, char var5, boolean var6);

    public NullOperator<R> isNull(Expression<R, ?> var1);

    public NilOperator<R> isNil(Expression<R, ?> var1, String var2);

    default public LogicalOperator<R> and(Filter<R> filter, Filter<R> filter2) {
        return this.and(List.of(Objects.requireNonNull(filter), Objects.requireNonNull(filter2)));
    }

    public LogicalOperator<R> and(Collection<? extends Filter<R>> var1);

    default public LogicalOperator<R> or(Filter<R> filter, Filter<R> filter2) {
        return this.or(List.of(Objects.requireNonNull(filter), Objects.requireNonNull(filter2)));
    }

    public LogicalOperator<R> or(Collection<? extends Filter<R>> var1);

    public LogicalOperator<R> not(Filter<R> var1);

    public BinarySpatialOperator<R> bbox(Expression<R, ? extends G> var1, Envelope var2);

    public BinarySpatialOperator<R> equals(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public BinarySpatialOperator<R> disjoint(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public BinarySpatialOperator<R> intersects(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public BinarySpatialOperator<R> touches(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public BinarySpatialOperator<R> crosses(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public BinarySpatialOperator<R> within(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public BinarySpatialOperator<R> contains(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public BinarySpatialOperator<R> overlaps(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2);

    public DistanceOperator<R> beyond(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2, Quantity<Length> var3);

    public DistanceOperator<R> within(Expression<R, ? extends G> var1, Expression<R, ? extends G> var2, Quantity<Length> var3);

    public TemporalOperator<R> after(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> before(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> begins(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> begunBy(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> tcontains(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> during(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> tequals(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> toverlaps(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> meets(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> ends(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> overlappedBy(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> metBy(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> endedBy(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public TemporalOperator<R> anyInteracts(Expression<R, ? extends T> var1, Expression<R, ? extends T> var2);

    public Expression<R, Number> add(Expression<R, ? extends Number> var1, Expression<R, ? extends Number> var2);

    public Expression<R, Number> subtract(Expression<R, ? extends Number> var1, Expression<R, ? extends Number> var2);

    public Expression<R, Number> multiply(Expression<R, ? extends Number> var1, Expression<R, ? extends Number> var2);

    public Expression<R, Number> divide(Expression<R, ? extends Number> var1, Expression<R, ? extends Number> var2);

    default public Expression<R, ?> function(String string, Expression<R, ?> expression) {
        return this.function(string, new Expression[]{Objects.requireNonNull(expression)});
    }

    default public Expression<R, ?> function(String string, Expression<R, ?> expression, Expression<R, ?> expression2) {
        return this.function(string, new Expression[]{Objects.requireNonNull(expression), Objects.requireNonNull(expression2)});
    }

    public Expression<R, ?> function(String var1, Expression<R, ?>[] var2);

    public SortProperty<R> sort(ValueReference<R, ?> var1, SortOrder var2);
}

