/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.identification;

import java.util.ArrayList;
import java.util.List;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.util.CodeList;

@UML(identifier="DS_AssociationTypeCode", specification=Specification.ISO_19115)
public final class AssociationType
extends CodeList<AssociationType> {
    private static final long serialVersionUID = 6031427859661710114L;
    private static final List<AssociationType> VALUES = new ArrayList<AssociationType>(10);
    @UML(identifier="crossReference", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType CROSS_REFERENCE = new AssociationType("CROSS_REFERENCE");
    @UML(identifier="largerWorkCitation", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType LARGER_WORK_CITATION;
    @Deprecated
    public static final AssociationType LARGER_WORD_CITATION;
    @UML(identifier="partOfSeamlessDatabase", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType PART_OF_SEAMLESS_DATABASE;
    @Deprecated
    @UML(identifier="source", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115, version=2003)
    public static final AssociationType SOURCE;
    @UML(identifier="stereoMate", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType STEREO_MATE;
    @UML(identifier="isComposedOf", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType IS_COMPOSED_OF;
    @UML(identifier="collectiveTitle", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType COLLECTIVE_TITLE;
    @UML(identifier="series", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType SERIES;
    @UML(identifier="dependency", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType DEPENDENCY;
    @UML(identifier="revisionOf", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public static final AssociationType REVISION_OF;

    private AssociationType(String string) {
        super(string, VALUES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssociationType[] values() {
        List<AssociationType> list = VALUES;
        synchronized (list) {
            return (AssociationType[])VALUES.toArray(AssociationType[]::new);
        }
    }

    public AssociationType[] family() {
        return AssociationType.values();
    }

    public static AssociationType valueOf(String string) {
        return AssociationType.valueOf(AssociationType.class, string);
    }

    static {
        LARGER_WORD_CITATION = LARGER_WORK_CITATION = new AssociationType("LARGER_WORK_CITATION");
        PART_OF_SEAMLESS_DATABASE = new AssociationType("PART_OF_SEAMLESS_DATABASE");
        SOURCE = new AssociationType("SOURCE");
        STEREO_MATE = new AssociationType("STEREO_MATE");
        IS_COMPOSED_OF = new AssociationType("IS_COMPOSED_OF");
        COLLECTIVE_TITLE = new AssociationType("COLLECTIVE_TITLE");
        SERIES = new AssociationType("SERIES");
        DEPENDENCY = new AssociationType("DEPENDENCY");
        REVISION_OF = new AssociationType("REVISION_OF");
    }
}

